﻿// <summary>ソースコード：クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.AddInSysOptions.CordingSampleSys
{
    /// <summary><para>class outline:</para>
    /// <para>演算中にフィードバックする情報を格納するクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>フィードバックする情報はシステムの目的やモデルによって異なる為、適応側で派生クラスを作成する</para>
    /// </remarks>
    [Serializable]
    public class SampleMyFeedbakData : McSTGSysFeedbackDataBase
    {
        /// <summary>計算結果</summary>
        protected double m_dSimData;
        /// <summary>観測結果</summary>
        protected double m_dObservedData;
        /// <summary>観測時刻</summary>
        protected HySTime m_csTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary>計算開始シミュレーション時刻</summary>
        protected HySTime m_csCalStartTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary>計算終了シミュレーション時刻</summary>
        protected HySTime m_csCalStopTime = HySTime.DEFAULT_TIME.Clone();


        // 各種セッター
        public void SetSimuData(double dDt)
        { m_dSimData = dDt; }
        public void SetObservedData(double dDt)
        { m_dObservedData = dDt; }
        public void SetTime(HySTime csTime)
        { m_csTime.SetTime(csTime); }
        public void SetCalStartTime(HySTime csTime)
        { m_csCalStartTime.SetTime(csTime); }
        public void SetCalStopTime(HySTime csTime)
        { m_csCalStopTime.SetTime(csTime); }

        // 各種ゲッター
        public double GetSimuData()
        { return m_dSimData; }
        public double GetObservedData()
        { return m_dObservedData; }
        public HySTime GetTime()
        { return m_csTime; }
        public HySTime GetCalStartTime()
        { return m_csCalStartTime; }
        public HySTime GetCalStopTime()
        { return m_csCalStopTime; }
    }
}
