﻿

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.AddInSysOptions.CordingSampleSys
{
    /// <summary><para>class outline:</para>
    /// <para>フィードバック情報出力モデルクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public class SampleSTGFeedbackModel : McSTGFeedbackModelBase
    {

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = false;
            
            // コーディング例
            if (lInputDataNum == 2)
            {
                bRtn = true;
                for (long lLp = 0; lLp < lInputDataNum; lLp++)
                {
                    HySID csInputPtnID = csInputCellData[lLp].GetReceivePatternID();
                    if (csInputPtnID.Equals(SampleMySysDefine.IN_PATTERN_SIMULATION) == false &&
                        csInputPtnID.Equals(SampleMySysDefine.IN_PATTERN_OBSERVED) == false)
                    {   // シミュレーション結果入力でも観測結果結果入力でも無い場合
                        csErrorInf.AddCheckErrorData(this.GetID(), SampleMySysDefine.STG_FEEDBACK_OUT_KIND,
                            "Unexpected receive data type.");
                        bRtn = false;
                    }
                }
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>フィードバック情報を初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitializeFeedbackData(ref csInitialData,lInputDataNum,ref csInputCellData, ref csFeedbackData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <param name="csFeedbackData">フィードバック情報</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool InitializeFeedbackData(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData, ref McSTGSysFeedbackDataBase csFeedbackData)
        {
            // コーディング例
            // あくまでも、コーディングの例である為、意味のある処理ではない
            SampleMyFeedbakData csFBDt = csFeedbackData as SampleMyFeedbakData;
            csFBDt.SetObservedData(0.0);
            csFBDt.SetSimuData(0.0);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>入力値を元にフィードバック情報を書き込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = WriteToFeedbackData(lInputDataNum, ref csInputCellData,ref csFeedbackData)</para>
        /// </example>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <param name="csFeedbackData">フィードバック書き込み情報</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long WriteToFeedbackData(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData, ref McSTGSysFeedbackDataBase csFeedbackData)
        {
            // コーディング例
            // あくまでも、コーディングの例である為、意味のある処理ではない
            SampleMyFeedbakData csFdBkDt = csFeedbackData as SampleMyFeedbakData;

            //long lQIdx = 0; // 受信するデータの　セル内の変数の０番目は　流量
            long lHIdx = 1; // 受信するデータの　セル内の変数の１番目は　水位

            double dHIn = 0.0; // 水位
            HySCellData csCell = null;
            for (long lLp = 0; lLp < lInputDataNum; lLp++)
            {   // 出力する伝送データ数分繰り返します。
                HySID csInputPtnID = csInputCellData[lLp].GetReceivePatternID();
                if (csInputPtnID.Equals(SampleMySysDefine.IN_PATTERN_SIMULATION) == true)
                {
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得
                    
                    // フィードバック情報を書き込む
                    csFdBkDt.SetSimuData(dHIn);
                    csFdBkDt.SetTime(this.m_csSimTime);
                }
                else if (csInputPtnID.Equals(SampleMySysDefine.IN_PATTERN_OBSERVED) == true)
                {
                    csCell = csInputCellData[lLp].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                    dHIn = csInputCellData[lLp].Data(csCell, lHIdx);   // セル内の流量値を取得

                    // フィードバック情報を書き込む
                    csFdBkDt.SetObservedData(dHIn);
                }
            }
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            // 通常の要素モデルと同様に、画面で設定されたプロパティ情報に従って、要素モデル内のパラメーターを設定します。
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算開始時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadyCalculation( csFeedbackData )</para>
        /// </example>
        /// <param name="csFeedbackData">フィードバックデータ</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        protected override bool ReadyCalculation(ref McSTGSysFeedbackDataBase csFeedbackData)
        {
            // コーディング例
            // あくまでも、コーディングの例である為、意味のある処理ではない
            SampleMyFeedbakData csMyFeedbackData = csFeedbackData as SampleMyFeedbakData;
            csMyFeedbackData.SetCalStartTime(m_csSimTime);
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>計算終了時に動作する処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CompleteCalculation( csFeedbackData　)</para>
        /// </example>
        /// <param name="csFeedbackData">フィードバックデータ</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        protected override bool CompleteCalculation(ref McSTGSysFeedbackDataBase csFeedbackData)
        {
            // コーディング例
            // あくまでも、コーディングの例である為、意味のある処理ではない
            SampleMyFeedbakData csMyFeedbackData = csFeedbackData as SampleMyFeedbakData;
            csMyFeedbackData.SetCalStopTime(m_csSimTime);
            return true;
        }
    }
}
