﻿// <summary>ソースコード：常数定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;

namespace CommonMP.HYMCO.AddInSysOptions.CordingSampleSys
{
    /// <summary><para>class outline:</para>
    /// <para>ＤＬＬ内で使用する共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public class SampleMySysDefine
    {
        // =======================
        // 独自画面
        // =======================
        /// <summary>独自画面Kind</summary>
        public static readonly HySObjectKind MY_SCREEN_KIND = new HySObjectKind("CordingSample.MySys.MyScreen");
        /// <summary>独自画面ID</summary>
        public static readonly HySID MY_SCREEN_ID = new HySID("CordingSample.MySys.MyScreen");

        // =======================
        // モデル関係
        // =======================
        /// <summary>モデルファクトリ</summary>
        public static readonly HySID HYMCO_STG_FEEDBACK_MODEL_LIB = new HySID("CordingSample.Feedback.Mdl.Fctry");
        /// <summary>フィードバック情報出力モデル種別</summary>
        public static readonly HySObjectKind STG_FEEDBACK_OUT_KIND = new HySObjectKind("CordingSample.Feedback.Mdl.OutFeedbackInfModel");
        /// <summary>フィードバック情報出力モデル名称</summary>
        public static readonly HySString STG_FEEDBACK_OUT_NAME = new HySString("コーディングサンプル：フィードバック情報出力要素");

        //---------------------------------
        // イベント番号( -15001 >= No >= -19999 ）
        //---------------------------------
        //// <summary> 独自メニューコールバック番号 </summary>
        //public static readonly long MY_MENU_NO = -15001;

        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // SampleSTGFeedbackModel用
        // ===============================
        /// <summary>シミュレーション結果入力</summary>
        public static readonly HySID IN_PATTERN_SIMULATION = new HySID("SimulationResult");
        /// <summary>観測結果結果入力</summary>
        public static readonly HySID IN_PATTERN_OBSERVED = new HySID("ObservedData");

    }
}
