﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.CoreOption.McSTGSystemViewBase;

namespace CommonMP.HYMCO.AddInSysOptions.CordingSampleSys
{
    public partial class SampleMySysForm : McSTGSysFormBase //Form
    {
        /// <summary>
        /// 表示データ
        /// （本サンプルではSampleFloodPrdctFeedbakDataとしているが独自の表示データクラスを作成しても良い） 
        /// </summary>
        protected SampleMyDispData m_csDispData = null;

        //public SampleMySysForm()
        //{
        //    InitializeComponent();
        //}
         
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetAddInBaseForm csNewProjectForm = new HySDotNetAddInBaseForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public SampleMySysForm(HySScreen csScreen)
            : base(csScreen)    // :base(csScreen) のコールは必須
        {
            InitializeComponent();  // ★ <-- 必須処理
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Redraw(csDispData)</para>
        /// </example>
        /// <param name="csDispData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void Redraw(HySDataRoot csDispData)
        {
            m_csDispData = csDispData as SampleMyDispData;
            if (m_csDispData != null)
            {
                DispTextBox.Text = HySCalendar.ToString(m_csDispData.GetCalStartTime(), HySCalendar.FORMAT.lSW_YEAR) + " ～ " +
                                  HySCalendar.ToString(m_csDispData.GetCalStopTime(), HySCalendar.FORMAT.lSW_YEAR);

            }
        }
   
        /// <summary>
        /// <para>method outline</para>
        /// <para>閉じるボタン押下イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            m_csScreen.CloseScreen();
        }

    }
}
