﻿// <summary>ソースコード：スクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;
using CommonMP.HYMCO.CoreOption.McSTGSystemViewBase;

namespace CommonMP.HYMCO.AddInSysOptions.CordingSampleSys
{
    /// <summary><para>class outline:</para>
    /// <para>サンプルスクリーンファクトリークラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public class SampleMySysScreenFactory : McSTGSysDotNetScreenFactoryBase // 必ず McSTGSysDotNetScreenFactoryBaseから派生させる
    {
        /// <summary><para>method outline:</para>
        /// <para>スクリーンクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySScreen csScreen = CreateScreen( csSimulatorKind,csID,csScreenKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csScreenKind">画面種別</param>
        /// <returns>スクリーンクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public HySScreen CreateScreen(HySKind csSimulatorKind, HySIdentifier csID, HySKind csScreenKind)
        {
            HySScreen csScreen = null;

            if (SampleMySysDefine.MY_SCREEN_KIND.Equals(csScreenKind) == true)
            {
                csScreen = new SampleMySysScreen();
            }
            // ★　↓必須↓　★
            else
            {   // 自業務で意図しない画面種別の場合
                // base.CreateScreen()ﾒｿｯﾄﾞをコールする事が必須
                csScreen = base.CreateScreen(csSimulatorKind, csID, csScreenKind);
            }
            // ★　↑必須↑　★

            return csScreen;
        }
    }
}
