﻿// <summary>ソースコード：表示情報格納クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.AddInSysOptions.SampleFloodPrediction
{
    /// <summary><para>class outline:</para>
    /// <para>表示情報格納クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class SampleFloodPrdctDispData : HySDataRoot
    {
        /// <summary>計算開始シミュレーション時刻</summary>
        protected HySTime m_csCalStartTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary>計算終了シミュレーション時刻</summary>
        protected HySTime m_csCalStopTime = HySTime.DEFAULT_TIME.Clone();

        /// <summary>計算結果</summary>
        protected double[] m_dSimData = new double[5];
        /// <summary>観測結果</summary>
        protected double m_dObservedData;

        /// <summary>観測誤差重み</summary>
        protected double[] m_dWeight = new double[5];

        //コンストラクタ
        public SampleFloodPrdctDispData()
        {
            for (long lP = 0; lP < 5; lP++)
            {
                m_dSimData[lP] = 0.0d;
                m_dWeight[lP] = 0.2d;
            }
            m_dObservedData = 0.0d;
        }
        
        // 各種セッター
        public void SetCalStartTime(HySTime csTime)
        { m_csCalStartTime.SetTime(csTime); }
        public void SetCalStopTime(HySTime csTime)
        { m_csCalStopTime.SetTime(csTime); }
        public void SetSimuData(double dDt, long number)
        { m_dSimData[number] = dDt; }
        public void SetObservedData(double dDt)
        { m_dObservedData = dDt; }
        public void SetWeight(double dDt, long number)
        { m_dWeight[number] = dDt; }

        // 各種ゲッター
        public HySTime GetCalStartTime()
        { return m_csCalStartTime; }
        public HySTime GetCalStopTime()
        { return m_csCalStopTime; }
        public double GetSimuData(long number)
        { return m_dSimData[number]; }
        public double GetObservedData()
        { return m_dObservedData; }
        public double GetWeight(long number)
        { return m_dWeight[number]; }
    }
}
