﻿// <summary>ソースコード：データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.AddInSysOptions.SampleFloodPrediction
{ 
    /// <summary><para>class outline:</para>
    /// <para>データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class SampleSTGFeedbackCalInf : McCalInfo
    {
        /// <summary>現時刻</summary>
        public HySTime m_csNowTime = null;

        ///<summary>計算時間が現時刻よりも前:Flase、後:True</summary>
        public bool[] m_bNowTime_after_cal = new bool[5];

        ///<summary>計算時間が現時刻よりも前:Flase、後:True</summary>
        public bool m_bNowTime_after_obs = false;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            SampleSTGFeedbackCalInf csRtn = new SampleSTGFeedbackCalInf();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            SampleSTGFeedbackCalInf csOrgDt = (SampleSTGFeedbackCalInf)csOrgInfo;
            return true;
        }
    }
}
