﻿// <summary>ソースコード：独自画面フォームクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreOption.McSTGSystemViewBase;

namespace CommonMP.HYMCO.AddInSysOptions.SampleFloodPrediction
{
    /// <summary><para>class outline:</para>
    /// <para>独自画面フォームクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public partial class SampleMySysForm : McSTGSysFormBase
    {
        /// <summary>
        /// 表示データ
        /// </summary>
        protected SampleFloodPrdctDispData m_csDispData = null;
         
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDotNetAddInBaseForm csNewProjectForm = new HySDotNetAddInBaseForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public SampleMySysForm(HySScreen csScreen)
            : base(csScreen)
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Redraw(csDispData)</para>
        /// </example>
        /// <param name="csDispData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal void Redraw(HySDataRoot csDispData)
        {
            m_csDispData = csDispData as SampleFloodPrdctDispData;
            
            if (m_csDispData != null)
            {
                StringBuilder Disp_text = new StringBuilder();
                //観測値の出力
                string aaa = string.Format("観測値：{0,10:F3}", m_csDispData.GetObservedData());
                Disp_text.AppendLine(string.Format("観測値：{0,10:F3}", m_csDispData.GetObservedData()));
                Disp_text.AppendLine();
                //計算値の出力
                for (long lP=0;lP<5;lP++)
                {
                    Disp_text.AppendLine(string.Format("計算結果{0:D2}：{1,10:F3}", lP, m_csDispData.GetSimuData(lP)));
                }
                DispCalcStatus.Text = Disp_text.ToString();

                Disp_text.Remove(0,Disp_text.Length);
                //計算値の出力
                for (long lP=0;lP<5;lP++)
                {
                    Disp_text.AppendLine(string.Format("Feedback重み{0:D2}：{1,10:F3}", lP, m_csDispData.GetWeight(lP)));
                }
                DispWeight.Text = Disp_text.ToString();
            }

            if (m_csDispData != null)
            {
                DispTextBox.Text = HySCalendar.ToString(m_csDispData.GetCalStartTime(), HySCalendar.FORMAT.lSW_YEAR) + " ～ " +
                                  HySCalendar.ToString(m_csDispData.GetCalStopTime(), HySCalendar.FORMAT.lSW_YEAR);

            }
        }
   
        /// <summary>
        /// <para>method outline</para>
        /// <para>閉じるボタン押下イベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>CloseButton_Click(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void CloseButton_Click(object sender, EventArgs e)
        {
            m_csScreen.CloseScreen();
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>フォーム読込み時のイベント</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SampleMySysForm_Load(sender, e)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SampleMySysForm_Load(object sender, EventArgs e)
        {

        }

    }
}
