﻿// <summary>ソースコード：スクリーンクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreOption.McSTGSystemViewBase;

namespace CommonMP.HYMCO.AddInSysOptions.SampleFloodPrediction
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>スクリーンクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public class SampleMySysScreen : McSTGSysScreenBase
    {
        /// <summary>フォーム</summary>
        protected SampleMySysForm m_csMySysForm = null;
        
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Initialize()
        {   
            // Formを生成
            m_csMySysForm = new SampleMySysForm(this);

            // 親クラスにFormを設定する
            base.SetViewForm(m_csMySysForm);

            m_csMySysForm.StartPosition = FormStartPosition.Manual;
            m_csMySysForm.SetDesktopLocation(600, 5);

        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override public void Terminate()
        {
            m_csMySysForm = null;
        }

        /// <summary>
        /// <para>method outline</para>
        /// <para>描画情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDispData(csDispData)</para>
        /// </example>
        /// <param name="csDispData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected void SetDispData(HySDataRoot csDispData)
        {
            m_csMySysForm.Redraw(csDispData);
        }
    }
}
