﻿// <summary>ソースコード：業務処理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using System.Runtime.InteropServices;
using System.Diagnostics;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.BusiProc;

using CommonMP.HYMCO.CoreOption.McSTGSystemBase;

namespace CommonMP.HYMCO.AddInSysOptions.VerySimpleTGCSys
{
    /// <summary><para>class outline:</para>
    /// <para>一番単純なTGC業務クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/12/01][新規作成]</para>
    /// </remarks>
    public class VerySimpleTGCSysBusiProc : McSTGSysBusiProcedureBase
    {
        // ------------------------------------------------
        //  派生側で実装すべきメソッド
        // ------------------------------------------------

        /// <summary><para>method outline:</para>
        /// <para>システム起動直後の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = StartBusiProc( csHySEvent ) </para>
        /// </example>
        /// <param name="csHySEvent">送られたイベント</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool StartBusiProc(HySEventObject csHySEvent)
        {
            // ★ 計算のモードを指定する（モデルの計算モードが　個別制御の場合は必須）
            m_csSTGMngData.SetSTGCalMode(McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL);  // 全てのプロジェクトが一斉に計算を行う場合

            // ★ 最初から一般評価グラフ表示画面を表示
            this.RedrawLineGraph();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＳＴＧ計算指定時刻になったが、今だ計算続行中等により計算開始出来ない事を通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CannotCalStart(csSetTime) </para>
        /// </example>
        /// <param name="csSetTime">ＳＴＧ計算に設定されていた時刻</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool CannotCalStart(HySTime csSetTime)
        {
            // 処理例：計算の継続が不能なため、30秒後に再度計算を開始するようにタイマーセット
            HySTime csWaitTime = new HySTime(30); // ３０秒
            this.WaitCalculation(csSetTime, csWaitTime);  // ３０秒間待つ（３０秒後、計算開始が行われる）
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＳＴＧ計算指定時刻になったことを通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CalculationTimerOut( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// this.m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.ASYNCHRONOUS_CAL　の時
        /// コールされる
        /// （this.m_csSTGMngData.GetSTGCalMode() == McSTGSysManageData.STGCalMode.SYNCHRONOUS_CAL　の時はコールされない）
        /// </para>
        /// </remarks>
        override protected void CalculationTimerOut()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル構築通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeModelConstruction(csPrjID,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">構築されたプロジェクトＩＤ</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool NoticeModelConstruction(HySID csPrjID, HySSimulationDataContainer csDtCnt)
        {
            // モデル構築が正常終了か異常終了か判断して、必要な処理を実施する
            McSimulationStatus csSimSta = (McSimulationStatus)csDtCnt.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            if (csSimSta.GetModelConStatus() != McSimulationStatus.ModelConstructionStatus.CONSTRUCTED)
            {   // モデル構築異常終了通知を受け必要な処理を行なう。
                // 画面に通知
                HySEventObject csEventObject = new HySEventObject(HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION);
                csEventObject.SetToSimKind(m_csSimKindID);
                csEventObject.SetSuppID(csPrjID);
                this.PutEvent(csEventObject);
            }

            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalInitialize(csPrjID,csFeedBackData,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">初期化されたプロジェクトＩＤ</param>
        /// <param name="csFeedBackData">プロジェクトが保持するフィードバック情報</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool NoticeCalInitialize(HySID csPrjID, McSTGSysFeedbackDataBase csFeedBackData, HySSimulationDataContainer csDtCnt)
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para> 計算完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeCalComplete(csPrjID,csFeedBackData,csDtCnt) </para>
        /// </example>
        /// <param name="csPrjID">計算が完了したプロジェクトＩＤ</param>
        /// <param name="csFeedBackData">プロジェクトが保持するフィードバック情報</param>
        /// <param name="csDtCnt">プロジェクトが保持するデータコンテナ</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool NoticeCalComplete(HySID csPrjID, McSTGSysFeedbackDataBase csFeedBackData, HySSimulationDataContainer csDtCnt)
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para> ＳＴＧを構成する全プロジェクトの計算完了通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSTGCalComplete( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool NoticeSTGCalComplete()
        {
            // ★１．グラフの更新を指示する
            this.RedrawLineGraph();
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム固有ヘルプ表示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DispSysHelp( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        override protected bool DispSysHelp()
        {
            // コーディング例（PDFファイルを表示する）
            HySString csPDFFile = HySEnvInf.GetHomeDirectory() + new HySString("\\help\\UserSys\\VerySimpleTGCSManual.pdf");
            return this.ShowManual(csPDFFile);
        }

    }
}
