﻿// <summary>ソースコード：ＨＹＭＣＯ ＣＵＩ専用　業務処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.BusiProc;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ ＣＵＩ用業務処理クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McCUIBusiProcedure : McBusiProcedure //, HySBridgeIF
    {
        /// <summary>　プロセス終了フラグ </summary>
        protected long m_lEndFlg = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure cdBusiProc = new HySBusiProcedure( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCUIBusiProcedure()
            :base(McDefine.SIMULATOR_KIND)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure.Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Terminate()
        {
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSysUnit.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            ((HySEventObject)csEvent).SetToSimKind(m_csSimKindID);
            bRtn = m_csController.PutEvent(csEvent);
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            if (m_bWorkFlg == true)
            { return false; }
            else
            { return true; }
        }

        /* 
        // start of Ver1.7
        /// <summary><para>method outline:</para>
        /// <para>終了フラグONを待ち続ける</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MainLoop( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MainLoop()
        {
            for (; ; )
            {   // 無限ループ内でプロセス終了を監視する。
                if (m_lEndFlg > 0)
                {   // プロセス終了ならば
                    break;  // ループを抜ける
                }
                System.Threading.Thread.Sleep(333); // 一定間隔で見張る。
            }   // end of for(∞)
        }

        /// <summary><para>method outline:</para>
        /// <para>終了フラグをONにする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetExitFlgON( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetExitFlgON()
        {
            m_lEndFlg = 1;
        }
        
        //void SetRemoteDivider(HySRemoteDividerIF csDivider);
        //Int32 ReceiveRmtEvent(ref HySSysEvent csRcvEvent, ref HySSysEvent csAnsEvent);

        // end of Ver1.7
        */
    }
}
