﻿// <summary>ソースコード：HYMCO CUI 用システム内イベント制御クラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO CUI 用システム内イベント制御クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McCUIEventManager : HySEventManager
    {       
        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean WakeUp()
        {
            // Do nothing
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ShutDown()
        {
            // Do nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを宛先に従ってシステム制御クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySEventMngRoot.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean PutEvent(HySSysEvent csEvent)
        {
            bool bRtn = false;
            long lToNo = csEvent.To();
            if (lToNo == HySSysEvent.OBJID_SYSCONTROLLER)
            {   // 宛先がシステムコントローラーならば
                if (m_csSystemCtl != null)
                {
                    bRtn = m_csSystemCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_BUSIPROCEDURE)
            {   // 宛先が業務コントローラーならば
                if (m_csBusiCtl != null)
                {
                    bRtn = m_csBusiCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_VIEWER)
            {   // 宛先がビューアコントローラーならば
                if (m_csViewerCtl != null)
                {
                    bRtn = m_csViewerCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_SIMULATOR)
            {   // 宛先がシミュレーションコントローラーならば
                if (m_csSimCtl != null)
                {
                    bRtn = m_csSimCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_LIBMANAGER)
            {   // 宛先がライブラリコントローラーならば
                if (m_csLibraryCtl != null)
                {
                    bRtn = m_csLibraryCtl.EventCallback(csEvent);
                }
            }
            else if (lToNo == HySSysEvent.OBJID_GISCONTROLLER)
            {   // 宛先がＧＩＳコントローラーならば
                if (m_csGISCtl != null)
                {
                    bRtn = m_csGISCtl.EventCallback(csEvent);
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // Do nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを宛先に従ってシステム制御クラスにポストする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> this.BranchEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override Boolean BranchEvent(HySSysEvent csEvent)
        {
            // Do nothing
            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>スレッド処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> スレッド起動時に呼ばれる </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void ThreadRun()
        {
            // Do nothing
        }
    }
}
