﻿// <summary>ソースコード：メインビューアクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;


using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>メインビューアクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McCUIViewer : HySViewer
    {
        /// <summary>ビューア制御</summary>
        protected HySViewerController m_csViewerCtl;
        /// <summary>ファクトリ管理</summary>
        protected HySFactoryManager m_csFactoryManager;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewer csViewer = new McCUIViewer( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCUIViewer()
        {
            // Do nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ管理クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.SetFactoryManager( csFactoryManager ) </para>
        /// </example>
        /// <param name="csFactoryManager">ファクトリ管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetFactoryManager(HySFactoryMng csFactoryManager)
        {
            m_csFactoryManager = (HySFactoryManager)csFactoryManager;
        }

        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラス追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HyStViewer.AddViewerJob( csViewerJob ) </para>
        /// </example>
        /// <param name="csViewerJob">ビューア内部処理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void AddViewerJob(HySViewerJob csViewerJob)
        {
            // Do Nothing
        }
        /// <summary><para>method outline:</para>
        /// <para>ビューア内部処理クラスの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySViewerJob csJob = GetViewerJob( ) </para>
        /// </example>
        /// <param name="csKey">取得識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySViewerJob GetViewerJob(HySStringRoot csKey)
        {
            // DoNothing
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Initialize()
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void Run()
        {
            // Do Nothing
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Terminate()
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetController(HySControllerRoot csCtl)
        {
            m_csViewerCtl = (HySViewerController)csCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        virtual public Boolean EventCallback(HySSysEvent csEvent)
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDotNetViewer.PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            return m_csViewerCtl.PutEvent(csEvent);
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>画面へのイベント見張り（ウエイトしない）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> TryWatchEvent( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 画面側のタイマーからコールされて、
        /// 他の処理部から画面へのイベントを取り出し、
        /// 画面の　EventCallback() を呼ぶ</para>
        /// </remarks>
        public virtual void TryWatchEvent()
        {
            m_csViewerCtl.TryWatchEvent();
        }
        */
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean ExitOK()
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロセス終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewerController.Exit( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void Exit()
        {
            // Do Nothing
        }

    }
}
