﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>コマンド引数格納クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.4][2013/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HymcoCUICmnd : HySDataRoot
    {
        /// <summary>コマンド</summary>
        public string m_sCmnd = "";
        //public long m_lCmndNo = -1;
        /// <summary>コマンド引数１</summary>
        public string m_sPara1 = "";
        /// <summary>コマンド引数２</summary>
        public string m_sPara2 = "";
        /// <summary>コマンド引数３</summary>
        public string m_sPara3 = "";
    }

    /// <summary><para>class outline:</para>
    /// <para>コマンド引数リストクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.4][2013/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HymcoCUICmndList : HySDataRoot
    {
        /// <summary>コマンド管理テーブル</summary>
        protected HySDataHashTable m_csCmndList = new HySDataHashTable();
        //protected HySDataLinkedList m_csCmndList = new HySDataLinkedList();
        //List<HymcoCUICmnd> m_csCmndList = new List<HymcoCUICmnd>();

        /// <summary><para>method outline:</para>
        /// <para>コマンドクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearCmnd( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearCmnd()
        {
            m_csCmndList.ClearAllObject();
        }
        /// <summary><para>method outline:</para>
        /// <para>コマンド追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddCmnd(lOrdeNo, pcsCmnd) </para>
        /// </example>
        /// <param name="lOrdeNo">順番</param>
        /// <param name="pcsCmnd">コマンド</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddCmnd( long lOrdeNo, HymcoCUICmnd pcsCmnd)
        {
            m_csCmndList.AddObject(new HySString(lOrdeNo.ToString()), pcsCmnd);
        }
        /// <summary><para>method outline:</para>
        /// <para>コマンド数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCmndNum() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>コマンド数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCmndNum()
        {
            return m_csCmndList.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>コマンド取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HymcoCUICmnd csCmnd = GetCmnd(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">順番</param>
        /// <returns>コマンド</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HymcoCUICmnd GetCmnd(long lOrderNo)
        {
            HymcoCUICmnd csCmnd = m_csCmndList.GetObject( new HySString(lOrderNo.ToString())) as HymcoCUICmnd;
            return csCmnd;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public virtual string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public virtual void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
