﻿// <summary>ソースコード：ＨＹＭＣＯ　ＣＵＩ　メインプログラム</summary>
// <author>CommonMP</author>


using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.IO;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSSimulator;
using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.FigureUnity;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.TranInfo;
using CommonMP.HYMCO.CoreImpl.Tool;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>HYNCO CUI メイン制御</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HymcoCUIProgram : HySSystemController
    {
        //// <summary> static long Main(string[] sArgs)　の　リターン値 </summary>
        //public static long s_lRtn = 0;
        /// <summary>　シミュレーション制御本体 </summary>
        protected McCUISimulationController m_csSimulatorCtl = null;
        /// <summary> ＨＹＭＣＯシミュレーターファクトリ </summary>
        protected McFigureUnityFactory m_csMcSimulatorFctry = null;
        /// <summary>　モデル生成ファクトリ </summary>
        protected McModelFactorySet m_csModelFactorySet = null;

        /// <summary> 制御区分番号 </summary>
        protected long m_lProcNo = 0;

        /// <summary> プロジェクト定義ファイル </summary>
        protected string m_sProjectFileWithPath = null;
        /// <summary> 構造定義ファイル </summary>
        protected string m_sSCFNameWithPath=null;
        /// <summary> プロジェクトグループ名 </summary>
        protected string m_sProjectGroupName = "_defaultCUIProjectGroup";

        /// <summary> CommonMP動作条件設定ファイル </summary>
        protected HySString m_csEnvInfName = new HySString("HymcoCUI.cfg");

        /// <summary> シミュレーション開始時刻 </summary>
        protected HySTime m_csStime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> シミュレーション終了時刻 </summary>
        protected HySTime m_csGtime = HySTime.DEFAULT_TIME.Clone();
        /// <summary> シミュレーション刻み時間 </summary>
        protected HySTime m_csDltT = new HySTime(0);
        /// <summary> シミュレーション一時中断時刻 </summary>
        protected HySTime m_csPause = HySTime.DEFAULT_TIME.Clone();
        /// <summary> シミュレーション一時中断有り無しフラグ </summary>
        protected bool bPauseFlg = false;

        /// <summary> モデルリスト出力ファイル </summary>
        protected string m_sModelListFileWithPath=null;

        /// <summary> コマンドのリスト </summary>
        protected HymcoCUICmndList m_csCmndList = new HymcoCUICmndList();

        // start of Ver1.6.1
        /// <summary>起動モード</summary>
        public enum CUI_Mode
        {
            /// <summary> -svmdl オプション起動(サーバー仕様) </summary>
            SVMdl_mode = 1,
            /// <summary> -zr オプション起動(繰り返し中にリセット有) </summary>
            Z_mode_R,
            /// <summary> -zc オプション起動(繰り返し中にリセット無：状態継続) </summary>
            Z_mode_C,
            /// <summary> その他 </summary>
            Etc_mode
        }
        /// <summary>起動モード</summary>
        internal protected CUI_Mode m_eMode = CUI_Mode.Etc_mode;
        /// <summary>プロセス識別番号 </summary>
        protected long m_lProcessIDNo = 0;
        /// <summary>ホームディレクトリ </summary>
        static public string m_sHomeDirectory = "";
        /// <summary>計算終了ロックファイル名 </summary>
        static public string m_sLockFileName = "";
        /// <summary>ファイルストリーム</summary>
        static protected FileStream m_csFile;

#if DEBUG
        /// <summary>zモード起動時の無限ループを抜け出す</summary>
        static public long m_iBreakFlg = 0; 
#endif
        // end of Ver1.6.1

        // start of Ver1.7
        /// <summary>サーバーモード起動変数</summary>
        public static readonly string SV_MODE_ARG = "-svmdl";
        // end of Ver1.7

        // ====================================
        //  シミュレーションを行う区別に従って、定義を増やす
        // ====================================
        /// <summary> シミュレーション </summary>
        protected static readonly long SIMULATION_START = 1;
        /// <summary> モデルリスト取得 </summary>
        protected static readonly long GET_MODEL_LIST = 2;

        /// <summary> 入力処理正常終了</summary>
        static private readonly string MSG_COMPLETE_INSTALL =
            "ライブラリのインストールが完了しました。";
        /// <summary> 出力処理正常終了</summary>
        static private readonly string MSG_COMPLETE_ARCHIVE =
            "ライブラリのアーカイブが完了しました。";
        /// <summary> 入力処理異常終了</summary>
        static private readonly string ERROR_MSG_INSTALL =
            "ライブラリ入力に失敗しました。";

        /// <summary>CUIリターンコード定義</summary>
        public enum CuiResult
        {
            /// <summary>正常</summary>
            NORMAL,
            /// <summary>オプション不正エラー</summary>
            ERROR_OPTION,
            /// <summary>アーカイブファイルパス不正エラー</summary>
            ERROR_ARCHIVE_FILE_PATH,
            /// <summary>コマンドの構文不正エラー</summary>
            ERROR_COMMAND_SYNTAX,
            /// <summary>実行形式ファイル無しエラー</summary>
            ERROR_NOT_BIN_FILE,
            /// <summary>モデルアイコンファイル無しエラー</summary>
            ERROR_NOT_MODELICON_FILE,
            /// <summary>プロジェクトフォルダパス不正エラー</summary>
            ERROR_PROJECT_FOLDER_PATH,
            /// <summary>ファイル入力失敗エラー</summary>
            ERROR_FILE_INPUT,
            /// <summary>ファイルアクセス失敗エラー</summary>
            ERROR_FILE_ACCESS,
            /// <summary>入力ファイルパス不正エラー</summary>
            ERROR_INPUT_FILE_PATH,
            /// <summary>サポート対象外アーカイブエラー</summary>
            ERROR_NON_SUPPORT_ARCHIVE,
            /// <summary>プロパティ画面プロジェクトフォルダパス不正エラー</summary>
            ERROR_PROPERTY_PRJ_FOLDER_PATH,
            /// <summary>プロパティ画面プロジェクト実行形式ファイル無しエラー</summary>
            ERROR_NOT_PROPERTY_PRJ_BIN_FILE,
            /// <summary>その他エラー</summary>
            ERROR_OTHERS = 999,
        };
        
        //====================================
        //  メインプログラム
        //====================================
        /// <summary><para>method outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> コマンドプロンプトより　himco -x xxxxx xxxxx として使用する
        ///    himco -c xxxxx.xml :  "xxxxx.xml"に定義された計算期間とモデルで　計算を行う。
        ///    　　　計算は、同時に一つのみ動作。
        ///    himco -p yyyyy.cfg xxxxx.xml  "yyyyy.cfg" に定義された条件で　xxxxx.xmlに定義された期間とモデルで　計算を行う。
        ///    　　　この場合、複数の計算を同時に起動する事が可能である。
        ///    　　　但し、下記は　ユーザー側で確実に設定を行う必要がある。
        ///    　　　①同時に動作する計算のログ出力ファイルが異なる様に yyyyy.cfg ファイルを設定する事
        ///    　　　②モデル内の入出力要素が、同時に一つのリソース（例えばファイル）に同時にアクセスしないように設定する事。
        ///    himco -s yyyyy.cfg xxxxx.xml  "yyyyy.cfg" に定義された条件で　xxxxx.xmlに定義された期間とモデルで　計算を行う。
        ///          （-p との違い：内部に簡単な計算シーケンスを組むことが可能）
        ///    　　　この場合、複数の計算を同時に起動する事が可能である。
        ///    　　　但し、下記は　ユーザー側で確実に設定を行う必要がある。
        ///    　　　①同時に動作する計算のログ出力ファイルが異なる様に yyyyy.cfg ファイルを設定する事
        ///    　　　②モデル内の入出力要素が、同時に一つのリソース（例えばファイル）に同時にアクセスしないように設定する事。
        ///    himco -zr no yyyyy.cfg xxxxx.xml 識別番号：no として "yyyyy.cfg" に定義された条件で　xxxxx.xmlに定義された期間とモデルで　計算を行う。
        ///    　　　計算完了後、プロセスを exit しない。（ＡＰＩ：hymcoAPIh28を用いて、計算の開始、終了を制御する）
        ///    　　　計算開始時には、初期化が行われる
        ///    　　　複数の計算を同時に起動する事が可能である。
        ///    　　　但し、下記は　ユーザー側で確実に設定を行う必要がある。
        ///    　　　①同時に動作する計算のログ出力ファイルが異なる様に yyyyy.cfg ファイルを設定する事
        ///    　　　②モデル内の入出力要素が、同時に一つのリソース（例えばファイル）に同時にアクセスしないように設定する事。
        ///    himco -zc no yyyyy.cfg xxxxx.xml 識別番号：no として "yyyyy.cfg" に定義された条件で　xxxxx.xmlに定義された期間とモデルで　計算を行う。
        ///    　　　計算完了後、プロセスを exit しない。（ＡＰＩ：hymcoAPIh28を用いて、計算の開始、終了を制御する）
        ///    　　　計算開始時には、初期化を行わず、前回状態を引き継いで計算を行う事が可能
        ///    　　　複数の計算を同時に起動する事が可能である。
        ///    　　　但し、下記は　ユーザー側で確実に設定を行う必要がある。
        ///    　　　①同時に動作する計算のログ出力ファイルが異なる様に yyyyy.cfg ファイルを設定する事
        ///    　　　②モデル内の入出力要素が、同時に一つのリソース（例えばファイル）に同時にアクセスしないように設定する事。
        /// </para>
        /// </example>
        /// <param name="sArgs">CUI 引数
        /// </param>
        /// <returns>o:正常終了、-1:異常終了</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>history:</para>
        /// <para>
        /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
        /// [CommonMP][ver 1.1.1][2012/03/01][引数追加 -p Option]
        /// [CommonMP][ver 1.1.4][2013/04/01][引数追加 -s Option]
        /// [CommonMP][ver 1.6.1][2016/12/01][引数追加 -zr, -zc Option]
        /// </para>
        /// </remarks>
        [STAThread]
        static int Main(string[] sArgs)
        {

            int iRtn = 0;
            Console.WriteLine(">>start of HYMCO<<");

            HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
            csErrFile.Delete();

            //-------------------------------------
            // ライブラリ入力／出力機能指定の場合は
            // 別処理を行う
            //-------------------------------------
            if (0 < sArgs.Length)
            {
                if (sArgs[0] == "-a")
                {
                    // ライブラリ出力処理を実行する
                    HymcoCUIProgram programForLibraryExport = new HymcoCUIProgram();
                    CuiResult result = programForLibraryExport.ExportLibrary(sArgs);
                    HySEnvInf.Terminate();
                    Console.WriteLine("<<end of HYMCO>>");
                    return (int)result;
                }
                else if (sArgs[0] == "-e")
                {
                    // ライブラリ入力処理を実行する
                    HymcoCUIProgram programForLibraryImport = new HymcoCUIProgram();
                    CuiResult result = programForLibraryImport.ImportLibrary(sArgs);
                    HySEnvInf.Terminate();
                    Console.WriteLine("<<end of HYMCO>>");
                    return (int)result;
                }
                // start of Ver1.6.1
                else if (sArgs[0] == "-v")
                {
                    //自分自身のバージョン情報を取得する
                    System.Diagnostics.FileVersionInfo ver =
                        System.Diagnostics.FileVersionInfo.GetVersionInfo(
                        System.Reflection.Assembly.GetExecutingAssembly().Location);
                    //結果を表示
                    Console.WriteLine("hymco Ver. = ");
                    Console.WriteLine(ver);
                    return (int)CuiResult.NORMAL;
                }
                // end of Ver1.6.1
           }


            // === 引数無しの場合、ProjectFile.xml から読み出し
            if (sArgs.Length == 0)
            {
                sArgs = new string[2];
                sArgs[0] = "-c";
                sArgs[1] = "ProjectFile.xml";
                //sArgs[0] = "-l";
                //sArgs[1] = "MdlList.xml";
            }
            // === 引数無しの場合、ProjectFile.xml から読み出し

            try
            {
                // 二重起動チェックを行う。
                if (
                    (sArgs[0].Equals("-s") == true) ||
                    (sArgs[0].Equals("-p") == true) ||
                    (sArgs[0].Equals("-zr") == true) ||
                    (sArgs[0].Equals("-zc") == true) ||
                    (sArgs[0].Equals(HymcoCUIProgram.SV_MODE_ARG) == true) ||
                    (System.Diagnostics.Process.GetProcessesByName(
                        System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length <= 1)
                    )
                {   // 複数起動可能の時以外は、起動されていない場合のみ起動する。

                    // システム制御生成
                    HymcoCUIProgram csSysCtl = new HymcoCUIProgram();
                    csSysCtl.SetSystemController(csSysCtl);

// start of Add Ver1.7　（Ver1.7時にコメントを消して復活させる）
//HySSystemController.m_eSvMode = SERVER_MODE.SV_ON;  // SVモード＝GUI無し
// end of Add Ver1.7　（Ver1.7時にコメントを消して復活させる）

                    // 引数解読
                    if (csSysCtl.DecipherArg(sArgs) == true)
                    {
                        // システム制御初期処理
                        if (csSysCtl.Initialize() == true)
                        {
                            // システム起動
                            if (csSysCtl.WakeUp() == true)
                            {
                                if (sArgs[0].Equals("-s") == true)
                                {   // -s 起動時
                                    csSysCtl.SequentialRun();
                                }
                                // start of Ver1.6.1
                                else if (sArgs[0].Equals("-zr") == true || sArgs[0].Equals("-zc") == true)
                                {   // -z 起動時
                                    csSysCtl.ZmodeRun();
                                }
                                // end of Ver1.6.1
                                // start of Ver1.7
                                /* サーバーサイドCommonMPの場合復活させる
                                else if (sArgs[0].Equals(SV_MODE_ARG) == true)
                                {   // -svmdl 起動時
                                    iRtn = csSysCtl.SVRun();
                                }
                                */
                                // end of Ver1.7
                                else
                                {   // 一般起動時
                                    csSysCtl.Run();
                                }
                            }
                            else
                            {   // システム起動失敗
                                if (csErrFile.Exist() == true)
                                {
                                    csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                                }
                                else
                                {
                                    csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                                }
                                csErrFile.WriteText("Fail System WakeUp.");
                                csErrFile.WriteText("Abnormal End  CommonMP.");
                                csErrFile.Close();
                                Console.WriteLine("Fail System WakeUp.");
                                iRtn = -1;
                            }
                            // システム終了
                            csSysCtl.ShutDown();
                        }
                        else
                        {   // 初期化失敗
                            if (csErrFile.Exist() == true)
                            {
                                csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                            }
                            else
                            {
                                csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                            }
                            csErrFile.WriteText("Fail System Initialize.");
                            csErrFile.WriteText("Abnormal End  CommonMP.");
                            csErrFile.Close();
                            Console.WriteLine("Fail System Initialize.");
                            iRtn = -1;
                        }
                    }
                    else
                    {   // 引数解読失敗
                        iRtn = -1;
                    }
                }
                else
                {   // 多重起動
                    if (csErrFile.Exist() == true)
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    else
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    csErrFile.WriteText("多重起動");
                    csErrFile.WriteText("Abnormal End  CommonMP.");
                    csErrFile.Close();
                    Console.WriteLine("多重起動");
                    iRtn = -1;
                }
                //Console.Read(); 
                for (int iLp = 0; iLp < 1; iLp++)
                { 
                    System.Threading.Thread.Sleep(300);
                }

                Console.WriteLine("<<end of HYMCO>>");

                if (iRtn != 0)
                {   // 異常発生の場合には強制終了
                    System.Environment.Exit(iRtn);
                }

            }
            catch
            {
                Console.WriteLine("Error ::  Catch Exception");
                System.Threading.Thread.Sleep(3000);
                iRtn = -1;
                System.Environment.Exit(iRtn);
            }

            return iRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数解析処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DecipherArg(sArgs) </para>
        /// </example>
        /// <param name="sArgs">CUI 引数</param>
        /// <returns>=true:正常、=false:引数異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean DecipherArg(string[] sArgs)
        {
            //HySString csParam = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");  <-- 此処で行ってもダメ
            bool bRtn = false;

            int lArgCnt = sArgs.Length;
            if( lArgCnt > 1 )
            {
                if (sArgs[0].Equals("-c") == true)
                {
                    m_lProcNo = HymcoCUIProgram.SIMULATION_START;
                    m_sProjectFileWithPath = sArgs[1];
                    bRtn = true;
                }
                else if (sArgs[0].Equals("-l") == true)
                {
                    m_lProcNo = HymcoCUIProgram.GET_MODEL_LIST;
                    m_sModelListFileWithPath = sArgs[1];
                    bRtn = true;
                }
                else if (sArgs[0].Equals("-p") == true || sArgs[0].Equals("-s") == true)
                {
                    if (sArgs.Length == 3)
                    {
                        m_lProcNo = HymcoCUIProgram.SIMULATION_START;
                        m_csEnvInfName = new HySString(sArgs[1]);   // Configファイル名
                        m_sProjectFileWithPath = sArgs[2];  // プロジェクトファイル名
                        bRtn = true;
                    }
                    else
                    {
                        Console.WriteLine("wrong command parameter number");
                        HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
                        if (csErrFile.Exist() == true)
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        else
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        csErrFile.WriteText("wrong command parameter number");
                        csErrFile.Close();
                    }
                }
                // start of Ver1.6.1
                else if (sArgs[0].Equals("-zr") == true || sArgs[0].Equals("-zc") == true )
                {
                    if (sArgs.Length == 4)
                    {
                        m_lProcNo = HymcoCUIProgram.SIMULATION_START;
                        m_lProcessIDNo = long.Parse(sArgs[1]);  // プロセス番号
                        m_csEnvInfName = new HySString(sArgs[2]);   // Configファイル名
                        m_sProjectFileWithPath = sArgs[3];  // プロジェクトファイル名
                        if (sArgs[0].Equals("-zr") == true)
                        {   // 初期化有
                            m_eMode = CUI_Mode.Z_mode_R;
                        }
                        else
                        {   // 初期化無
                            m_eMode = CUI_Mode.Z_mode_C;
                        }
                        DirectoryInfo csDi = Directory.GetParent(Directory.GetCurrentDirectory());
                        m_sHomeDirectory = csDi.ToString(); // 現在のディレクトリ
                        m_sLockFileName = m_sHomeDirectory + @"\.\temp\" + HymcoDefine.LOCKFILE_NAME;
                        bRtn = true;
                    }
                    else
                    {
                        Console.WriteLine("wrong command parameter number");
                        HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
                        if (csErrFile.Exist() == true)
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        else
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        csErrFile.WriteText("wrong command parameter number");
                        csErrFile.Close();
                    }
                }
                // end of Ver1.6.1
                // start of Ver1.7
                /*  将来（サーバーサイドＣｏｍｍｏｎＭＰの時）復活させる
                else if (sArgs[0].Equals(SV_MODE_ARG))
                {
                    if (sArgs.Length == 4)
                    {
                        m_lProcNo = HymcoCUIProgram.SIMULATION_START;
                        m_lProcessIDNo = long.Parse(sArgs[0]);  // プロセス番号 <-- CommonMPData内を示すようにする。
                        m_csEnvInfName = new HySString(sArgs[2]);   // Configファイル名 <-- CommonMPData内を示すようにする。
                        m_sProjectFileWithPath = sArgs[3];  // プロジェクトファイル名
                        m_eMode = CUI_Mode.SVMdl_mode;
                        bRtn = true;
                    }
                    else
                    {
                        Console.WriteLine("wrong command parameter number");
                        HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
                        if (csErrFile.Exist() == true)
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        else
                        {
                            csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                        }
                        csErrFile.WriteText("wrong command parameter number");
                        csErrFile.Close();
                    }
                }
                */
                // end of Ver1.7
                //else if (sArgs[0].Equals("-xxxx") == true)  <--- コマンド追加により　ケースが増えてゆく
                //{
                //    bRtn = true;
                //}
                else
                {
                    Console.WriteLine("unknown command");
                    HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
                    if (csErrFile.Exist() == true)
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    else
                    {
                        csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    }
                    csErrFile.WriteText("unknown command");
                    csErrFile.Close();
                }
            }
            else
            {
                Console.WriteLine("abnormal argument");
                HySFile csErrFile = new HySFile(HySEnvInf.sErorrFileName);
                if (csErrFile.Exist() == true)
                {
                    csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                }
                else
                {
                    csErrFile.Open(HySFile.OPEN_MODE.OPEN_OR_CREAT, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                }
                csErrFile.WriteText("abnormal argument");
                csErrFile.Close();
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean Initialize()
        {
            //HySString csEnvInfName = new HySString("HymcoCUI.cfg");
            HySString csEnvInfName = m_csEnvInfName;
            // 環境情報管理クラス生成
            m_csEnvInf = new HySEnvInf(csEnvInfName);
            
            if (m_csEnvInf.Initialize() != 0)
            {
                return false;
            }

            // === start of ファクトリ管理関係処理
            try
            {
                // ファクトリ管理生成
                m_csFactoryMng = new HySFactoryManager();
                // ＤＩコンテナ生成
                HySSystemDIContainer csSystemDIContainer = new HySSystemDIContainer();
                // 定義データ管理取得
                HySConfigDataManager csDataManager = csSystemDIContainer.GetConfigDataManager((HySFactoryManager)m_csFactoryMng);
                // 定義データ読込
                csDataManager.ConfigDataLoad();
                // 全ファクトリクラス生成
                csDataManager.CreateFactoryClassAll();

                m_csMcSimulatorFctry = new McFigureUnityFactory();
                m_csMcSimulatorFctry.Init(m_csFactoryMng);
                m_csFactoryMng.AddFactory(m_csMcSimulatorFctry);
                m_csModelFactorySet = m_csMcSimulatorFctry.GetModelFactorySet();
                // === end of ファクトリ管理関係処理

                // システム全体制御
                m_csSystemCtl = this;

                // イベント管理生成
                m_csEventManager = new McCUIEventManager();

                // システム全体制御
                m_csEventManager.AddSysController(m_csSystemCtl);

                // ＧＩＳ制御生成
                m_csGISCtl = new HySGISController();
                m_csEventManager.AddSysController(m_csGISCtl);
                // ライブラリ管理制御生成
                m_csLibraryCtl = new HySLibraryController();
                m_csEventManager.AddSysController(m_csLibraryCtl);
                // 演算制御生成
                m_csSimulatorCtl = new McCUISimulationController();
                m_csSimCtl = m_csSimulatorCtl;
                m_csEventManager.AddSysController(m_csSimCtl);
                // 業務管理制御生成
                m_csBusiCtl = new HySBusiController();
                m_csEventManager.AddSysController(m_csBusiCtl);
                // 画面制御生成
                m_csViewerCtl = new HySViewerController();
                m_csEventManager.AddSysController(m_csViewerCtl);
                m_csViewerCtl.SetConfigDataMng(csDataManager);

                // ＧＩＳ制御にファクトリ管理を教える
                m_csGISCtl.SetFactoryManager(m_csFactoryMng);
                // ＧＩＳ初期化処理（インスタンス等生成）
                m_csGISCtl.Initialize();

                // ライブラリ制御にファクトリ管理を教える
                m_csLibraryCtl.SetFactoryManager(m_csFactoryMng);
                // ライブラリ初期化処理（インスタンス等生成）
                m_csLibraryCtl.Initialize();

                // シミュレーター制御にファクトリ管理を教える
                m_csSimCtl.SetFactoryManager(m_csFactoryMng);
                // シミュレーター制御初期化処理（インスタンス等生成）
                m_csSimCtl.Initialize();

                // 業務制御にファクトリ管理を教える
                m_csBusiCtl.SetFactoryManager(m_csFactoryMng);
                // 業務制御初期化処理（インスタンス等生成）
                m_csBusiCtl.Initialize();
                HySBusiProcedure csBusiProc = new McCUIBusiProcedure();
                csBusiProc.SetController(m_csBusiCtl);
                m_csBusiCtl.SetSysUnit(csBusiProc);

                // 画面制御にファクトリ管理を教える
                m_csViewerCtl.SetFactoryMng(m_csFactoryMng);
                // ビューアクラス生成
                HySViewer csViewer = new McCUIViewer();
                csViewer.SetController(m_csViewerCtl);
                csViewer.SetFactoryManager(m_csFactoryMng);
                m_csViewerCtl.SetSysUnit(csViewer);

                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "Initialize", "end");

                return true;
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySSystemController.Initialize",
                    Properties.HymcoCUIResources.STATEMENT_ABEND + "(" + Properties.HymcoCUIResources.STATEMENT_CATCH_EXCEPTION +  ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "HySSystemController.Initialize", "Abend  (catch exception  " + ex.Message + ")");
                return false;
            }
            // === end of ファクトリから各種インスタンスを生成し管理クラスに設定する
        }

        /// <summary><para>method outline:</para>
        /// <para>立ち上がり処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean WakeUp()
        {
            bool bRtn = true;
            // 各コンポーネントの　立ち上げ
            try
            {
                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main","WakeUp", "start");
                // イベントマネージャー動作開始
                m_csEventManager.WakeUp();

                // ＧＩＳ管理制御起動
                m_csGISCtl.WakeUp();
                // ライブラリ管理制御起動
                m_csLibraryCtl.WakeUp();
                // シミュレーター制御起動
                m_csSimCtl.WakeUp();
                // 業務制御起動
                m_csBusiCtl.WakeUp();
                // 最後に画面を立ち上げる
                m_csViewerCtl.WakeUp();

                McLog.SetCUIDebugMode(true);  // モデルログ

                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main","WakeUp", "end");
            }
            catch (Exception ex)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "HySSystemController.WakeUp", 
                    Properties.HymcoCUIResources.STATEMENT_ABEND + "(" + Properties.HymcoCUIResources.STATEMENT_CATCH_EXCEPTION + ex.Message + ")");
               // HySLog.LogOut(HySLog.ONLINE, "HySSystemController.WakeUp", "Abend  (catch exception  " + ex.Message + ")");
                bRtn = false;
                //this.ShutDown();
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>メイン画面起動処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Run( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Run()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "Run", "start");
            bool bRtn = true;
            if (m_lProcNo == HymcoCUIProgram.SIMULATION_START)
            {   // シミュレーション計算実行
                bRtn = this.SimCalculation();
            }
            else if (m_lProcNo == HymcoCUIProgram.GET_MODEL_LIST)
            {   // モデルのリストの吐き出し
                bRtn = this.ModelListOut();

                // McPropertyInfo.XmlINメソッド確認用
                //bRtn = this.ModelListIn();
            }
            else
            {   // その他の命令
            }
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "Run", "End");
        }
        /// <summary><para>method outline:</para>
        /// <para>連続動作メイン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.SequentialRun( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SequentialRun()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "SequentialRun", "start");

            // プロジェクトファイル解析
            bool bRtn = this.DecipherPrjectFile();

            // 構造定義ファイル存在チェック
            HySFile csSCFile = new HySFile(m_sSCFNameWithPath);
            if (csSCFile.Exist() == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun",
                    Properties.HymcoCUIResources.STATEMENT_NOT_STRUCT_CONF );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", " not found Structure Configuration File");
                return;
            }

            HySEventObject csEvent = null;
            // シミュレーター生成
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "SequentialRun", "シミュレーター生成");
            HySID csSimuID = new HySID("Dmy");
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", 
                    Properties.HymcoCUIResources.STATEMENT_NOT_CREATE_SIM );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", "シミュレーター生成失敗");
                return;
            }
            // コンテナ取得
            HySSimulatorRoot csSimulator = m_csSimulatorCtl.GetSimulator(McDefine.SIMULATOR_KIND, csSimuID);
            HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csSimulator.GetContainer();

            // プロジェクト情報設定
            McProjectInfData csPrjInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            csPrjInf.SetProjectGroupName(new HySString(this.m_sProjectGroupName));

            // 構造定義ファイル復元
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "SequentialRun", "構造定義ファイル復元");
            McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);

            HySXmlReader csReader = new HySXmlReader(m_sSCFNameWithPath);
            csStructInfo.ReadStructureConfiguration(csReader, m_csModelFactorySet, m_sProjectGroupName);
            HySID csID = csStructInfo.GetID() as HySID;
            csContainer.SetID(csID);
            csSimuID = csID;

            HySString csPrptyFileName = csStructInfo.GetPropertyXmlFileName();
            HySString csInitialFileName = csStructInfo.GetInitialXmlFileName();

            string sFileName = "";
            string sFileNameWithoutSfx = "";
            string sPath = "";
            //GetFileNameString(sSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath);
            csStructInfo.GetFileNameString(new HySString(m_sSCFNameWithPath), ref sFileName, ref sFileNameWithoutSfx, ref sPath);

            if ((object)csPrptyFileName != null)
            {   // プロパティ定義ファイル有りならば
                csPrptyFileName.SetChar(sPath + "\\" + csPrptyFileName.ToString());
                csReader = new HySXmlReader(csPrptyFileName);
                csStructInfo.ReadPropertyConfiguration(csReader, m_csModelFactorySet);
            }
            if ((object)csInitialFileName != null)
            {   // 初期設定ファイルありならば
                csInitialFileName.SetChar(sPath + "\\" + csInitialFileName.ToString());
                csReader = new HySXmlReader(csInitialFileName);
                csStructInfo.ReadInitialConfiguration(csReader, m_csModelFactorySet);
            }

            // モデル生成
            McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            csSimuStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.CONSTRUCTED); // 構築済に設定
            csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);  // 未計算に設定
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "SequentialRun", "モデル生成");
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_MODEL_CONSTRUCTION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", 
                    Properties.HymcoCUIResources.STATEMENT_MODEL_CREATE_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", "モデル生成失敗");
                return;
            }

            // 初期化
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "SequentialRun", "初期化");

            csContainer.SetSimuTime(m_csStime);
            csContainer.SetStartTime(m_csStime);
            csContainer.SetGoalTime(m_csGtime);
            csContainer.SetDeltaTime(m_csDltT);

            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_INITIALIZE_SIMULATION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", 
                    Properties.HymcoCUIResources.STATEMENT_INIT_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", "初期化失敗");
                return;
            }

            /* Ver1.6.1 delete
            // 演算ロット情報の設定
            HySCalcLotInfo csCalcLotInf = new HySCalcLotInfo(csContainer.GetSimKind(), csContainer.GetID());
            csCalcLotInf.SetRCalcExecDate(HySCalendar.CreateNowTime());
            // コンテナに設定
            csContainer.SetData(HySCalcLotInfo.DATA_KEY_CALC_LOT, csCalcLotInf);
            // DBに登録する
            HySStockData csStockData = new HySStockData(csCalcLotInf.GetSimKind(), csCalcLotInf.GetSimID());
            csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
            csStockData.SetData(csCalcLotInf);
            HySEventObject csEventObj = new HySEventObject(HySEventObject.OBJID_LIBMANAGER, HySEventObject.CMND_DB_REGISTER);
            // 送り元を業務に設定
            csEventObj.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
            // 送り元シミュレータ種別を設定
            csEventObj.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEventObj.SetSubEventNo(HySLibraryMngDefine.DB_REGISTER_DATA_NEW);
            csEventObj.SetToSimKind(HySDefine.SIMULATOR_KIND);
            csEventObj.SetData(csStockData);
            csEventObj.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO);
            csEventObj.SetResponseInfo((HySID)csContainer.GetID());
            //bRtn = PutEvent(csEventObj);
            bRtn = m_csLibraryCtl.EventCallback(csEventObj);
            if (!bRtn)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", "演算ロット情報の登録失敗");
                return ;
            }
            */

            Console.WriteLine("\n <<Start of Command_Sequence (" + DateTime.Now.ToString() + ")>>\n");
            //////////////////////////////
            // コマンドシーケンス処理開始
            HymcoCUICmnd csCmnd = null;
            long lCmndNum = this.m_csCmndList.GetCmndNum();
            if (lCmndNum == 0)
            {   // コマンド設定が無い場合には　-p オプション設定と同じ処理を行う
                Console.WriteLine("\n >>start of Calculation (" + DateTime.Now.ToString() + ")<<\n");
                // 計算開始
                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "計算開始");
                csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION, csSimuID);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                bRtn = m_csSimulatorCtl.EventCallback(csEvent);
                if (bRtn != true)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", Properties.HymcoCUIResources.STATEMENT_CALC_NG);
                   // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "計算失敗");
                    return;
                }
                Console.WriteLine("\n >>end of Calculation (" + DateTime.Now.ToString() + ")<<\n");
            }
            else
            {   // コマンド設定がある場合には　設定されたシーケンス通りに処理を行う
                for (long lLp = 1; lLp <= lCmndNum; lLp++)
                {
                    HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "SequentialRun", "Command_No=" + lLp.ToString());
                    csCmnd = m_csCmndList.GetCmnd(lLp);
                    if (csCmnd.m_sCmnd == HymcoCUIProgram.cmd_CMND_SIMULATOR_RESTORE)
                    {   // CUI制御コマンド：シミュレーション状態保存ファイルの読み込み
                        bRtn = SqcCmdReadSimulator(csCmnd, csContainer, csSimuID);
                    }
                    else if (csCmnd.m_sCmnd == HymcoCUIProgram.cmd_CMND_SIMULATOR_SAVE)
                    {   // CUI制御コマンド：シミュレーション状態をファイルへ保存する
                        bRtn = SqcCmdWriteSimulator(csCmnd, csContainer, csSimuID);
                    }
                    else if (csCmnd.m_sCmnd == HymcoCUIProgram.cmd_CMND_RENEW_PARAMETER)
                    {   // CUI制御コマンド：シミュレーションパラメーター値修正
                        bRtn = SqcCmdRenewParameter(csCmnd, csContainer, csSimuID);
                    }
                    else if (csCmnd.m_sCmnd == HymcoCUIProgram.cmd_CMND_RESTART_SIMULATION)
                    {   // CUI制御コマンド：シミュレーション計算再開（CMND_SIMULATOR_RESTOREが発行された時にはここから計算を行う）
                        bRtn = SqcCmdRestartSimulation(csCmnd, csContainer, csSimuID);
                    }
                    else if (csCmnd.m_sCmnd == HymcoCUIProgram.cmd_CMND_START_SIMULATION)
                    {   // CUI制御コマンド：シミュレーション計算開始（CMND_SIMULATOR_RESTOREが発行されなかった時にはここから計算を行う）
                        bRtn = SqcCmdStartSimulation(csCmnd, csContainer, csSimuID);
                    }

                    if (bRtn != true)
                    {
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", 
                            Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG + lLp.ToString());
                       // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "SequentialRun", "シーケンス失敗::Command_No=" + lLp.ToString());
                        return;
                    }
                    // 内部でインスタンスが変更されている場合が考えられるので絶えず最新インスタンスを取得する
                    csSimulator = m_csSimulatorCtl.GetSimulator(McDefine.SIMULATOR_KIND, csSimuID);
                    csContainer = (HySSimulationDataContainer)csSimulator.GetContainer();
                    csContainer.SetGoalTime(m_csGtime); // 最終時刻も更新
                }
            }
            // コマンドシーケンス処理終了
            //////////////////////////////
            Console.WriteLine("\n <<End of Command_Sequence (" + DateTime.Now.ToString() + ")>>\n");

            //Console.ReadLine();

            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "SequentialRun", "End");
            return ;
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ShutDown()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main","ShutDown", "");

            // 演算制御終了
            m_csSimCtl.ShutDown();
            // 業務制御終了
            m_csBusiCtl.ShutDown();
            // ライブラリ管理制御終了
            m_csLibraryCtl.ShutDown();
            // ＧＩＳエンジン終了
            m_csGISCtl.ShutDown();

            // 画面制御終了
            m_csViewerCtl.ShutDown();

            // イベントマネージャー終了
            m_csEventManager.ShutDown();
            // ファクトリマネージャ終了
            m_csFactoryMng.ShutDown();

            // 環境情報終了
            HySEnvInf.Terminate();

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean ExitOK()
        {
            // Do Nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>システム終了指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CmndShutDown( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override Boolean CmndShutDown()
        {
            // Do Nohing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>常に true</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベントをシステム構成要素にポストする</para>
        /// </remarks>
        public override Boolean EventCallback(HySSysEvent csEvent)
        {
            // Do nothing
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算実行</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SimCalculation( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected Boolean SimCalculation()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "SimCalculation", "start");

            // プロジェクトファイル解析
            bool bRtn = this.DecipherPrjectFile();

            // 構造定義ファイル存在チェック
            HySFile csSCFile = new HySFile(m_sSCFNameWithPath);
            if (csSCFile.Exist() == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run",
                    Properties.HymcoCUIResources.STATEMENT_NOT_STRUCT_CONF );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", " not found Structure Configuration File");
                return bRtn;
            }

            HySEventObject csEvent = null;
            // シミュレーター生成
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "シミュレーター生成");
            HySID csSimuID = new HySID("Dmy");
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", 
                    Properties.HymcoCUIResources.STATEMENT_NOT_CREATE_SIM );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "シミュレーター生成失敗");
                return bRtn;
            }
            // コンテナ取得
            HySSimulatorRoot csSimulator = m_csSimulatorCtl.GetSimulator(McDefine.SIMULATOR_KIND, csSimuID);
            HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csSimulator.GetContainer();

            // プロジェクト情報設定
            McProjectInfData csPrjInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            csPrjInf.SetProjectGroupName(new HySString(this.m_sProjectGroupName));

            // 構造定義ファイル復元
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "構造定義ファイル復元");
            McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);

            HySXmlReader csReader = new HySXmlReader(m_sSCFNameWithPath);
            csStructInfo.ReadStructureConfiguration(csReader, m_csModelFactorySet, m_sProjectGroupName);

            HySString csPrptyFileName = csStructInfo.GetPropertyXmlFileName();
            HySString csInitialFileName = csStructInfo.GetInitialXmlFileName();
            string sFileName = "";
            string sFileNameWithoutSfx = "";
            string sPath = "";
            //GetFileNameString(sSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath);
            csStructInfo.GetFileNameString(new HySString(m_sSCFNameWithPath), ref sFileName, ref sFileNameWithoutSfx, ref sPath);

            if ((object)csPrptyFileName != null)
            {   // プロパティ定義ファイル有りならば
                csPrptyFileName.SetChar(sPath + "\\" + csPrptyFileName.ToString());
                csReader = new HySXmlReader(csPrptyFileName);
                csStructInfo.ReadPropertyConfiguration(csReader, m_csModelFactorySet);
            }
            if ((object)csInitialFileName != null)
            {   // 初期設定ファイルありならば
                csInitialFileName.SetChar(sPath + "\\" + csInitialFileName.ToString());
                csReader = new HySXmlReader(csInitialFileName);
                csStructInfo.ReadInitialConfiguration(csReader, m_csModelFactorySet);
            }

            // モデル生成
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "モデル生成");
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_MODEL_CONSTRUCTION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", 
                    Properties.HymcoCUIResources.STATEMENT_MODEL_CREATE_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "モデル生成失敗");
                return bRtn;
            }

            // 初期化
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "初期化");

            csContainer.SetSimuTime(m_csStime);
            csContainer.SetStartTime(m_csStime);
            if (bPauseFlg == true)
            {   // 一時中断有り
                csContainer.SetGoalTime(m_csPause);
            }
            else
            {
                csContainer.SetGoalTime(m_csGtime);
            }
            csContainer.SetDeltaTime(m_csDltT);
            
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_INITIALIZE_SIMULATION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", 
                    Properties.HymcoCUIResources.STATEMENT_INIT_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "初期化失敗");
                return bRtn;
            }

            /* * Ver1.6.1 delete
            // 演算ロット情報の設定
            HySCalcLotInfo csCalcLotInf = new HySCalcLotInfo(csContainer.GetSimKind(), csContainer.GetID());
            csCalcLotInf.SetRCalcExecDate(HySCalendar.CreateNowTime());
            // コンテナに設定
            csContainer.SetData(HySCalcLotInfo.DATA_KEY_CALC_LOT, csCalcLotInf);
            // DBに登録する
            HySStockData csStockData = new HySStockData(csCalcLotInf.GetSimKind(), csCalcLotInf.GetSimID());
            csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
            csStockData.SetData(csCalcLotInf);
            HySEventObject csEventObj = new HySEventObject(HySEventObject.OBJID_LIBMANAGER, HySEventObject.CMND_DB_REGISTER);
            // 送り元を業務に設定
            csEventObj.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
            // 送り元シミュレータ種別を設定
            csEventObj.SetFromSimKind(McDefine.SIMULATOR_KIND);
            csEventObj.SetSubEventNo(HySLibraryMngDefine.DB_REGISTER_DATA_NEW);
            csEventObj.SetToSimKind(HySDefine.SIMULATOR_KIND);
            csEventObj.SetData(csStockData);
            csEventObj.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO);
            csEventObj.SetResponseInfo((HySID)csContainer.GetID());
            //bRtn = PutEvent(csEventObj);
            bRtn = m_csLibraryCtl.EventCallback(csEventObj);
            if (!bRtn)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", 
                    Properties.HymcoCUIResources.STATEMENT_CALC_REGIST_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "演算ロット情報の登録失敗");
                return bRtn;
            }
            /* */

             Console.WriteLine("\n >>start of Calculation (" + DateTime.Now.ToString() + ")<<\n");
            // 計算開始
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "Run", "計算開始");
            csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            if (bRtn != true)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", 
                    Properties.HymcoCUIResources.STATEMENT_CALC_NG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "Run", "計算失敗");
                return bRtn;
            }

            if (bPauseFlg == true)
            {   // 一時中断有り
                Console.WriteLine("\n>> ? Continue (y or n) ?");
                string sReadStr = Console.ReadLine();
                if (sReadStr.Equals("y") == true || sReadStr.Equals("Y") == true)
                {
                    Console.WriteLine("   ===== Continue ======\n");
                    csContainer.SetGoalTime(m_csGtime);
                    csSimulator.SetSimuGoalTime(m_csGtime);
                    csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_RESTART_SIMULATION, csSimuID);
                    csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                    bRtn = m_csSimulatorCtl.EventCallback(csEvent);
                }
            }
            Console.WriteLine("\n <<End of Calculation (" + DateTime.Now.ToString() +")>>\n" );
            //Console.ReadLine();

            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "SimCalculation", "End");
            return bRtn;
        }
       
        /// <summary><para>method outline:</para>
        /// <para>モデルリストの出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ModelListOut( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : 正常、false : 異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected Boolean ModelListOut()
        {
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "ModelListOut", "start");
            bool bRtn = false;

            HySString csWorkDir = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");

            m_sModelListFileWithPath = csWorkDir.ToString() + m_sModelListFileWithPath;

            HySXmlWriter csOutXml = new HySXmlWriter(m_sModelListFileWithPath);
            csOutXml.CreateRoot("ModelList");

            HySDataLinkedList csCalMdlInfoList = m_csModelFactorySet.GetCalModelInfoList();
            McModelInfo csMdlInfo;
            HySXmlNode csXmlNode;

            long lModelListNum = csCalMdlInfoList.GetCount();
            csCalMdlInfoList.SetCursorFirst();
            for (long lLp = 0; lLp < lModelListNum; lLp++)
            {
                csMdlInfo = (McModelInfo)csCalMdlInfoList.GetCursorData();
                if (csMdlInfo.GetDivision() != null && csMdlInfo.GetDivision() == McModelLibraryDefine.DIVISION_CALCULATION_MODEL)
                {
                    csXmlNode = csMdlInfo.XmlOUT(ref csOutXml);
                    csOutXml.AppendChild(csXmlNode);
                }
                csCalMdlInfoList.MoveCursorNext();
            }

            csOutXml.Save();

            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "ModelListOut", "End");
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル解析処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DecipherPrjectFile() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:引数異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected Boolean DecipherPrjectFile()
        {
            bool bRtn = false;
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "DecipherPrjectFile", "start");

            // プロジェクトファイル
            HySString csWorkDir = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");
            m_sProjectFileWithPath = csWorkDir.ToString() + m_sProjectFileWithPath;

            HySFile csPrjFile = new HySFile(m_sProjectFileWithPath);
            if (csPrjFile.Exist() == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", 
                    Properties.HymcoCUIResources.STATEMENT_NOT_PROJ_CONF +  "(" + m_sProjectFileWithPath+")");
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", " not found Project Configuration File(" + m_sProjectFileWithPath + ")");
                return bRtn;
            }


            HySXmlReader csXmlRead = new HySXmlReader(m_sProjectFileWithPath);
            // ルート
            HySXmlNode csXmlRoot = csXmlRead.GetRootNode();
            string sPrjGrName = "";
            sPrjGrName = csXmlRoot.GetAttribute(McDefine.xml_PROJECT_GROUP);
            if( sPrjGrName != "")
            {
                m_sProjectGroupName = sPrjGrName;
                HySLog.LogOut(HySLog.SYSTEM_DEBUG, "HymcoCUIProgram", "DecipherPrjectFile", "ProjectGoupName=" + m_sProjectGroupName);
            }


            HySXmlNode csXmlNode;

            // 構造定義ファイル関連
            HySXmlNodeList csXmlLst = csXmlRoot.GetChildNodeListByTagName(HymcoCUIProgram.xml_SCFILE);
            if (csXmlLst.GetCount() < 1)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile",
                    Properties.HymcoCUIResources.STATEMENT_NOT_DEF_STRUCT_CONF);
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", " not define Structure Configuration File");
                return bRtn;
            }
            csXmlNode = csXmlLst.GetNode(0);
            m_sSCFNameWithPath = csXmlNode.GetAttribute(HymcoCUIProgram.xml_FILE_NAME);
            m_sSCFNameWithPath = csWorkDir.ToString() + m_sSCFNameWithPath;

            // シミュレーション関連
            csXmlLst = csXmlRoot.GetChildNodeListByTagName(HymcoCUIProgram.xml_SIMULATION);
            if (csXmlLst.GetCount() < 1)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", 
                    Properties.HymcoCUIResources.STATEMENT_NOT_DEF_SIM_ARG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", " not define Simulation Argument");
                return bRtn;
            }
            HySXmlNode csXmlSimNode;
            csXmlSimNode = csXmlLst.GetNode(0);

            // 時間設定
            csXmlLst = csXmlSimNode.GetChildNodeListByTagName(HymcoCUIProgram.xml_TIME);
            if (csXmlLst.GetCount() < 1)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", 
                    Properties.HymcoCUIResources.STATEMENT_NOT_DEF_SIM_TIME_ARG );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", " not define Simulation Time Argument");
                return bRtn;
            }
            csXmlNode = csXmlLst.GetNode(0);

            DateTime csDTBase = DateTime.Parse("1/1/1970 0:0:0");   // 基準時刻
            DateTime tm = new DateTime();
            
            // 時間設定（開始時刻）
            string sStartTime = csXmlNode.GetAttribute(HymcoCUIProgram.xml_START_TIME);
            if( sStartTime.Equals("") == true )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile",
                    Properties.HymcoCUIResources.STATEMENT_NOT_SET_SIM_START_TIME);
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", "Simulation Start Time is not set");
                return bRtn;
            }
            tm = DateTime.Parse(sStartTime);
            TimeSpan csTS = tm - csDTBase;
            m_csStime.SetTime((long)csTS.TotalSeconds);

            // 時間設定（目標時刻）
            string sGoalTime = csXmlNode.GetAttribute(HymcoCUIProgram.xml_GOAL_TIME);
            if( sGoalTime.Equals("") == true )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile",
                    Properties.HymcoCUIResources.STATEMENT_NOT_SET_SIM_GOAL_TIME);
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", "Simulation Goal Time is not set");
                return bRtn;
            }
            tm = DateTime.Parse(sGoalTime);
            csTS = tm - csDTBase;
            m_csGtime.SetTime((long)csTS.TotalSeconds);
            
            // 時間設定（時間刻み）
            string sDltTime = csXmlNode.GetAttribute(HymcoCUIProgram.xml_TIME_STEP);
            if( sDltTime.Equals("") == true )
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile",
                    Properties.HymcoCUIResources.STATEMENT_NOT_SET_SIM_DELTA_TIME );
               // HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "DecipherPrjectFile", "Simulation Delta Time is not set");
                return bRtn;
            }
            string sUnit = csXmlNode.GetAttribute(HymcoCUIProgram.xml_TIME_UNIT);
            double dDlt = double.Parse(sDltTime);
            if (sUnit.Equals(HymcoCUIProgram.xml_TIME_SEC) == true)
            {
                m_csDltT.SetTime(dDlt);
            }
            else if (sUnit.Equals(HymcoCUIProgram.xml_TIME_MIN) == true)
            {
                m_csDltT.SetTime(dDlt * (double)60.0);
            }
            else if (sUnit.Equals(HymcoCUIProgram.xml_TIME_HOUR) == true)
            {
                m_csDltT.SetTime(dDlt * (double)3600.0);
            }
            else if (sUnit.Equals(HymcoCUIProgram.xml_TIME_DAY) == true)
            {
                m_csDltT.SetTime(dDlt * (double)3600.0 * (double)24.0);
            }
            else if (sUnit.Equals(HymcoCUIProgram.xml_TIME_YEAR) == true)
            {
                m_csDltT.SetGeologicalYear(dDlt);
            }
            else if (sUnit.Equals("") == true)
            {
                m_csDltT.SetTime(dDlt);
            }
            // 時間設定（一時中断時刻）
            string sPauseTime = csXmlNode.GetAttribute(HymcoCUIProgram.xml_PAUSE_TIME);
            if (sPauseTime.Equals("") == true)
            {   // 一時中断無し
                // Do nothing
            }
            else
            {   // 一時中断有り
                bPauseFlg=true;
                tm = DateTime.Parse(sPauseTime);
                csTS = tm - csDTBase;
                m_csPause.SetTime((long)csTS.TotalSeconds);
            }

            HySXmlNode csXmlCtlNode;
            csXmlLst = csXmlSimNode.GetChildNodeListByTagName(HymcoCUIProgram.xml_CONTROL);
            csXmlCtlNode = csXmlLst.GetNode(0);
            if (csXmlCtlNode != null)
            {
                m_csCmndList.ClearCmnd();
                string sWork = csXmlCtlNode.GetAttribute(HymcoCUIProgram.xml_SEQUENCE_NUM);
                long lSqNum = Int32.Parse(sWork);
                csXmlLst = csXmlCtlNode.GetChildNodeListByTagName(HymcoCUIProgram.xml_COMMAND);
                HySXmlNode csXmlSqncNode;
                HymcoCUICmnd csCUICmnd;
                long lOdrNo;
                for (long llp = 0; llp < lSqNum; llp++)
                {
                    csXmlSqncNode = csXmlLst.GetNode(llp);
                    csCUICmnd = new HymcoCUICmnd();
                    sWork = csXmlSqncNode.GetAttribute(HymcoCUIProgram.xml_ORDER_NO);
                    lOdrNo = Int32.Parse(sWork);
                    sWork = csXmlSqncNode.GetAttribute(HymcoCUIProgram.xml_COMMAND_KIND);
                    csCUICmnd.m_sCmnd = sWork;
                    sWork = csXmlSqncNode.GetAttribute(HymcoCUIProgram.xml_PARA1);
                    csCUICmnd.m_sPara1 = sWork;
                    sWork = csXmlSqncNode.GetAttribute(HymcoCUIProgram.xml_PARA2);
                    csCUICmnd.m_sPara2 = sWork;
                    sWork = csXmlSqncNode.GetAttribute(HymcoCUIProgram.xml_PARA3);
                    csCUICmnd.m_sPara3 = sWork;
                    m_csCmndList.AddCmnd(lOdrNo, csCUICmnd);
                }
            }

            bRtn = true;
            HySLog.LogOut(HySLog.SYSTEM_DEBUG, "Main", "DecipherPrjectFile", "End");
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int errorCode = ImportLibrary(args) </para>
        /// </example>
        /// <param name="args">コマンドライン引数配列</param>
        /// <returns><para>CUIリターンコード</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected CuiResult ImportLibrary(string[] args)
        {

            CuiResult cuiResult = HymcoCUIProgram.CuiResult.NORMAL;

            try
            {
                // 環境情報ファイルの初期化を行う
                if (EnvInfInitialize() == false)
                {
                    return HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                }

                HySString archiveFilePath;
                // ライブラリ入力引数の変換を行う
                // 異常時はエラーメッセージを表示
                int result = McLibraryImportArgsConverter.ConvertLibraryImportArgs(args, out archiveFilePath);
                if (result != 0)
                {
                    switch (result)
                    {
                        case (-1):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_COMMAND_SYNTAX;
                            break;
                        case (-2):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_INPUT_FILE_PATH;
                            break;
                        default:
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                            break;
                    }

                    // エラーメッセージを表示する
                    HySString message = McLibraryImportArgsConverter.GetErrorMessage(result);
                    Console.Error.WriteLine(message.ToString());
                    return cuiResult;
                }
                // 入力実行を行う
                // 異常時はエラーメッセージを表示
                result = McLibraryImporter.Import(archiveFilePath);
                if (result != 0)
                {
                    switch (result)
                    {
                        case (-1):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_FILE_INPUT;
                            break;
                        case (-2):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_FILE_ACCESS;
                            break;
                        case (-3):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_NON_SUPPORT_ARCHIVE;
                            break;
                        default:
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                            break;
                    }

                    // エラーメッセージを表示する
                    HySString message = McLibraryImporter.GetErrorMessage(result);
                    Console.Error.WriteLine(message.ToString());
                    return cuiResult;
                }
            }
            catch
            {   // 想定外のエラー
                Console.Error.WriteLine(ERROR_MSG_INSTALL);
                return HymcoCUIProgram.CuiResult.ERROR_OTHERS;
            }

            Console.WriteLine(MSG_COMPLETE_INSTALL);
            return cuiResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>int errorCode = ExportLibrary(args) </para>
        /// </example>
        /// <param name="args">コマンドライン引数配列</param>
        /// <returns><para>CUIリターンコード</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected CuiResult ExportLibrary(string[] args)
        {

            CuiResult cuiResult = HymcoCUIProgram.CuiResult.NORMAL;

            try{
                // 環境情報ファイルの初期化を行う
                if (EnvInfInitialize() == false)
                {
                    Console.Error.WriteLine("環境情報の初期化で失敗");
                    return HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                }

                McLibraryExportInfo exportInfo;
                int result = McLibraryExportArgsConverter.ConvertLibraryExportArgs(args, out exportInfo);
                if (result != 0)
                {
                    switch (result)
                    {
                        case (-1):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_OPTION;
                            break;
                        case (-2):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_ARCHIVE_FILE_PATH;
                            break;
                        case (-3):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_COMMAND_SYNTAX;
                            break;
                        case (-4):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_NOT_BIN_FILE;
                            break;
                        case (-5):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_NOT_MODELICON_FILE;
                            break;
                        case (-6):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_PROJECT_FOLDER_PATH;
                            break;
                        case (-7):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_PROPERTY_PRJ_FOLDER_PATH;
                            break;
                        case (-8):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_NOT_PROPERTY_PRJ_BIN_FILE;
                            break;
                        default:
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                            break;
                    }

                    // エラーメッセージを表示する
                    HySString message = McLibraryExportArgsConverter.GetErrorMessage(result);
                    Console.Error.WriteLine(message.ToString());
                    return cuiResult;
                }
                // 出力実行を行う
                // 異常時はエラーメッセージを表示
                result = McLibraryExporter.Export(exportInfo);
                if (result != 0)
                {
                    switch (result)
                    {
                        case (-1):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_FILE_INPUT;
                            break;
                        case (-2):
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_FILE_ACCESS;
                            break;
                        default:
                            cuiResult = HymcoCUIProgram.CuiResult.ERROR_OTHERS;
                            break;
                    }
                    // エラーメッセージを表示する
                    HySString message = McLibraryExporter.GetErrorMessage(result);
                    Console.Error.WriteLine(message.ToString());
                    return cuiResult;
                }
            }
            catch
            {   // 想定外のエラー
                Console.Error.WriteLine("HymcoCUIProgram.ExportLibrary():ライブラリ出力で例外発生");
                return HymcoCUIProgram.CuiResult.ERROR_OTHERS;
            }

            Console.WriteLine(MSG_COMPLETE_ARCHIVE);
            return cuiResult;
        }

        /// <summary><para>method outline:</para>
        /// <para>環境情報初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>EnvInfInitialize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean EnvInfInitialize()
        {
            // 環境情報ファイルの初期化
            //HySString csEnvInfName = new HySString("HymcoCUI.cfg");
            HySString csEnvInfName = m_csEnvInfName;
            m_csEnvInf = new HySEnvInf(csEnvInfName);
            if (m_csEnvInf.Initialize() != 0)
            {
                Console.Error.WriteLine("HymcoCUIProgram.EnvInfInitialize():環境情報初期化失敗");
                return false;
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション状態保存ファイルの読み込み指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SqcCmdReadSimulator(csCmnd, csContainer, csSimuID) </para>
        /// </example>
        /// <param name="csCmnd">コマンド</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSimuID">シミュレーションID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean SqcCmdReadSimulator(HymcoCUICmnd csCmnd, HySSimulationDataContainer csContainer, HySID csSimuID)
        {
            bool bRtn = false;
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_SIMULATOR_RESTORE, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);

            HySString csWorkDir = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");
            HySString csFilePath = new HySString(csWorkDir.ToString() + csCmnd.m_sPara1);
            csEvent.SetData(csFilePath);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション状態をファイルへ保存する指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SqcCmdWriteSimulator(csCmnd, csContainer, csSimuID) </para>
        /// </example>
        /// <param name="csCmnd">コマンド</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSimuID">シミュレーションID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean SqcCmdWriteSimulator(HymcoCUICmnd csCmnd, HySSimulationDataContainer csContainer, HySID csSimuID)
        {
            bool bRtn = false;

            HySEventObject csPusEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_PAUSE_SIMULATION, csSimuID);
            csPusEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            bRtn = m_csSimulatorCtl.EventCallback(csPusEvent);


            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_SIMULATOR_SAVE, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);

            HySString csWorkDir = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");
            HySString csFilePath = new HySString(csWorkDir.ToString() + csCmnd.m_sPara1);
            csEvent.SetData(csFilePath);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーションパラメーター値修正指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SqcCmdRenewParameter(csCmnd, csContainer, csSimuID) </para>
        /// </example>
        /// <param name="csCmnd">コマンド</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSimuID">シミュレーションID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean SqcCmdRenewParameter(HymcoCUICmnd csCmnd, HySSimulationDataContainer csContainer, HySID csSimuID)
        {
            bool bRtn = false;
            // コンテナのStructureを更新する
            McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
            HySXmlReader csReader;
            HySString csWorkDir = HySEnvInf.GetEnvInf("CUI_WORK_DIRECTORY");

            csReader = new HySXmlReader(csWorkDir.ToString()+csCmnd.m_sPara1);
            bool bInitRtn = csStructInfo.ReadInitialConfiguration(csReader, m_csModelFactorySet);
            if (bInitRtn == false)
            {
                HySLog.LogOut(HySLog.ONLINE, "Main", "SqcCmdRenewParameter", "Error  in  csStructInfo.ReadInitialConfiguration()");
            }

            csReader = new HySXmlReader(csWorkDir.ToString()+csCmnd.m_sPara2);
            bool bPrptyRtn = csStructInfo.ReadPropertyConfiguration(csReader, m_csModelFactorySet);
            if (bPrptyRtn == false)
            {
                HySLog.LogOut(HySLog.ONLINE, "Main", "SqcCmdRenewParameter", "Error  in  csStructInfo.ReadPropertyConfiguration()");
            }
            // 
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_RENEW_INPUTDATA, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
            csEvent.SetData(csContainer);

            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算再開指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SqcCmdRestartSimulation(csCmnd, csContainer, csSimuID) </para>
        /// </example>
        /// <param name="csCmnd">コマンド</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSimuID">シミュレーションID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>CMND_SIMULATOR_RESTOREが行われた時にはここから再開する</para>
        /// </remarks>
        virtual protected Boolean SqcCmdRestartSimulation(HymcoCUICmnd csCmnd, HySSimulationDataContainer csContainer, HySID csSimuID)
        {
            bool bRtn = false;
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_RESTART_SIMULATION, csSimuID);
            //HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);

            csContainer.SetSimuTime(m_csStime);
            csContainer.SetStartTime(m_csStime);
            csContainer.SetGoalTime(m_csGtime);
            csContainer.SetDeltaTime(m_csDltT);

            csEvent.SetData(csContainer);

            bRtn = m_csSimulatorCtl.EventCallback(csEvent);
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーション計算開始指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SqcCmdStartSimulation(csCmnd, csContainer, csSimuID) </para>
        /// </example>
        /// <param name="csCmnd">コマンド</param>
        /// <param name="csContainer">データコンテナ</param>
        /// <param name="csSimuID">シミュレーションID</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>CMND_SIMULATOR_RESTOREが行われたなかった時にはここから再開する</para>
        /// </remarks>
        virtual protected Boolean SqcCmdStartSimulation(HymcoCUICmnd csCmnd, HySSimulationDataContainer csContainer, HySID csSimuID)
        {
            bool bRtn = false;
            HySEventObject csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION, csSimuID);
            csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);

            csContainer.SetSimuTime(m_csStime);
            csContainer.SetStartTime(m_csStime);
            csContainer.SetGoalTime(m_csGtime);
            csContainer.SetDeltaTime(m_csDltT);

            csEvent.SetData(csContainer);
            bRtn = m_csSimulatorCtl.EventCallback(csEvent);

            return bRtn;
        } 

        // start of Ver1.6.1
        /// <summary><para>method outline:</para>
        /// <para>引数 -zr -zc モードで起動されたときの動作メイン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.ZmodeRun( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual int ZmodeRun()
        {
            // ------------------------
            // 立ち上がり処理開始
            // ------------------------
            HySLog.LogOut(HySLog.TRIAL_RUN, "Main", "ZmodeRun", "start");
            int iRtn = -1; // リターン
            try
            {   // try ブロック
                // プロジェクトファイル解析
                bool bRtn = this.DecipherPrjectFile();

                // 構造定義ファイル存在チェック
                HySFile csSCFile = new HySFile(m_sSCFNameWithPath);
                if (csSCFile.Exist() == false)
                {
                    HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun",
                        Properties.HymcoCUIResources.STATEMENT_NOT_STRUCT_CONF);
                    return iRtn;
                }

                HySEventObject csEvent = null;
                // シミュレーター生成
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "ZmodeRun", "create simulator");
                HySID csSimuID = new HySID("Z-Hymco" + m_lProcessIDNo.ToString());
                csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE, csSimuID);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                bRtn = m_csSimulatorCtl.EventCallback(csEvent);
                if (bRtn != true)
                {
                    HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun",
                        Properties.HymcoCUIResources.STATEMENT_NOT_CREATE_SIM);
                    return iRtn;
                }

                //---------------------------------------------------------
                // ここから、いよいよ、プロジェクト（計算モデル）を構築する
                //---------------------------------------------------------
                // コンテナ取得
                HySSimulatorRoot csSimulator = m_csSimulatorCtl.GetSimulator(McDefine.SIMULATOR_KIND, csSimuID);
                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csSimulator.GetContainer();

                // プロジェクト情報設定
                McProjectInfData csPrjInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                csPrjInf.SetProjectGroupName(new HySString(this.m_sProjectGroupName));

                // 構造定義ファイル復元
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "ZmodeRun", "read struct_info");
                McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);

                HySXmlReader csReader = new HySXmlReader(m_sSCFNameWithPath);
                csStructInfo.ReadStructureConfiguration(csReader, m_csModelFactorySet, m_sProjectGroupName);
                HySID csID = csStructInfo.GetID() as HySID;
                csContainer.SetID(csID);
                csSimuID = csID;

                HySString csPrptyFileName = csStructInfo.GetPropertyXmlFileName();
                HySString csInitialFileName = csStructInfo.GetInitialXmlFileName();

                string sFileName = "";
                string sFileNameWithoutSfx = "";
                string sPath = "";
                //GetFileNameString(sSCFNameWithPath, ref sFileName, ref sFileNameWithoutSfx, ref sPath);
                csStructInfo.GetFileNameString(new HySString(m_sSCFNameWithPath), ref sFileName, ref sFileNameWithoutSfx, ref sPath);

                if ((object)csPrptyFileName != null)
                {   // プロパティ定義ファイル有りならば
                    csPrptyFileName.SetChar(sPath + "\\" + csPrptyFileName.ToString());
                    csReader = new HySXmlReader(csPrptyFileName);
                    csStructInfo.ReadPropertyConfiguration(csReader, m_csModelFactorySet);  // プロパティ情報設定
                }
                if ((object)csInitialFileName != null)
                {   // 初期設定ファイルありならば
                    csInitialFileName.SetChar(sPath + "\\" + csInitialFileName.ToString());
                    csReader = new HySXmlReader(csInitialFileName);
                    csStructInfo.ReadInitialConfiguration(csReader, m_csModelFactorySet);   // 初期化情報設定
                }

                // モデル生成
                McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                csSimuStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.CONSTRUCTED); // 構築済に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);  // 未計算に設定
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "ZmodeRun", "start of model construction");
                csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_MODEL_CONSTRUCTION, csSimuID);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                bRtn = m_csSimulatorCtl.EventCallback(csEvent);
                if (bRtn != true)
                {
                    HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun",
                        Properties.HymcoCUIResources.STATEMENT_MODEL_CREATE_NG);
                    return iRtn;
                }

                //------------------------------
                // 初回は必ず初期化が必要
                // -----------------------------
                // 初期化
                HySLog.LogOut(HySLog.TRIAL_RUN, "HymcoCUIProgram", "ZmodeRun", "initialization (1st)");

                csContainer.SetSimuTime(m_csStime);
                csContainer.SetStartTime(m_csStime);
                csContainer.SetGoalTime(m_csGtime);
                csContainer.SetDeltaTime(m_csDltT);

                csEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_INITIALIZE_SIMULATION, csSimuID);
                csEvent.SetToSimKind(McDefine.SIMULATOR_KIND);
                bRtn = m_csSimulatorCtl.EventCallback(csEvent);
                if (bRtn != true)
                {
                    HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun",
                        Properties.HymcoCUIResources.STATEMENT_INIT_NG);
                    return iRtn;
                }

                //////////////////////////////
                //-----------------------------------
                // ここから、繰り返し計算を開始する。
                // 終了は無い。（ＡＰＩからプロセスをKillするのみ）
                //-----------------------------------
                iRtn = 0;
                int iVeryFirstFlg = 0;
                HymcoCUICmnd csCmnd = new HymcoCUICmnd();
                // ★：常駐開始
                for (; ; )
                {
                    // 1) ここで、計算開始見張りを行う
                    for (; ; )
                    {
                        if (LockFileExist(m_lProcessIDNo) == false)
                        {   // ロックファイルが存在しなくなれば、計算を開始する
                            HySLog.LogOut(HySLog.DEBUG, "HymcoCUIProgram", "ZmodeRun", "restart calculation");
                            break;
                        }
                        System.Threading.Thread.Sleep(333); // 定周期監視のため
                    }   // end of for(;;) <--ロックファイル見張りループ

                    //  2)パラメータ設定
                    if (iVeryFirstFlg == 0)
                    {  // 一番最初は、ﾊﾟﾗﾒｰﾀ設定は既に行われているので、改めて行う必要がない。
                        iVeryFirstFlg = 1;
                    }
                    else
                    {  // 二回目以降はパラメータを再設定する。
                        // 2-1) プロジェクトファイル再読み込み
                        if (DecipherPrjectFile() != true)
                        {   // プロジェクトファイル解析異常
                            HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun DecipherPrjectFile",
                                Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG);
                            iRtn = -1;
                            break;
                        }
                        // 2-2) 内部でインスタンスが変更されている場合が考えられるので絶えず最新インスタンスを取得する
                        csSimulator = m_csSimulatorCtl.GetSimulator(McDefine.SIMULATOR_KIND, csSimuID);
                        //csContainer = null;
                        //csContainer = ((HySSimulationDataContainer)csSimulator.GetContainer()).DuplicateData() as HySSimulationDataContainer;
                        csContainer = (HySSimulationDataContainer)csSimulator.GetContainer();
                        // シミュレーション時刻設定
                        if (m_eMode == CUI_Mode.Z_mode_R)
                        {   // リセット必要ならば
                            csContainer.SetSimuTime(m_csStime);
                        }
                        csContainer.SetStartTime(m_csStime);
                        csContainer.SetGoalTime(m_csGtime);
                        csContainer.SetDeltaTime(m_csDltT);

                        // 2-3) コマンド生成し、パラメータの再設定を行う
                        csCmnd.m_sCmnd = HymcoCUIProgram.cmd_CMND_RENEW_PARAMETER;   // CUI制御コマンド：シミュレーションパラメーター値修正
                        csCmnd.m_sPara1 = (csStructInfo.GetInitialXmlFileName()).ToString();   // ﾊﾟﾗﾒｰﾀ設定
                        csCmnd.m_sPara2 = (csStructInfo.GetPropertyXmlFileName()).ToString();  // ﾊﾟﾗﾒｰﾀ設定

                        bRtn = SqcCmdRenewParameter(csCmnd, csContainer, csSimuID); // パラメータ再設定
                        if (bRtn != true)
                        {
                            HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun Renew_parameter",
                                Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG);
                            iRtn = -1;
                            break;
                        }

                        // 2-4) 不要メモリ破棄
                        McFigureUnity csFigUnity = csSimulator as McFigureUnity;
                        //McTranInfoDataPool.ClearInfo(csFigUnity.GetOwnerProjectID());   // プールクリア<-- クリアしてしまうと、データが生成されなくなる。：ダメ
// start of Ver1.7
//McTranInfoDataPool.ClearPooledData(csFigUnity.GetOwnerProjectID());  // プールされているデータをリストから外す
// end of Ver1.7
                        GC.Collect();
                        if (m_eMode == CUI_Mode.Z_mode_R)
                        {   // リセット必要ならば

                            csFigUnity.SetSimuTime(m_csStime);
                            csFigUnity.SetStartTime(m_csStime);
                            csFigUnity.ResetTranInfo();  // 接続線上のデータをすべて破棄

                            HySEventObject csRstEvent = new HySEventObject(HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_INITIALIZE_SIMULATION, csSimuID);   // リセットイベント生成
                            csRstEvent.SetToSimKind(McDefine.SIMULATOR_KIND);

                            csContainer.SetSimuTime(m_csStime);
                            csContainer.SetStartTime(m_csStime);
                            csContainer.SetGoalTime(m_csGtime);
                            csContainer.SetDeltaTime(m_csDltT);
                            csRstEvent.SetData(csContainer);

                            bRtn = m_csSimulatorCtl.EventCallback(csRstEvent);  // リセット指示

                            HySLog.LogOut(HySLog.DEBUG, "HymcoCUIProgram", "ZmodeRun", "initialization");
                        }

                    }  // end of if_else( 2回目以降 )

                    // 3)計算開始
                    if (m_eMode == CUI_Mode.Z_mode_R)
                    {   // リセット必要ならば
                        csCmnd.m_sCmnd = HymcoCUIProgram.cmd_CMND_START_SIMULATION;  // CUI制御コマンド：シミュレーション計算開始

                        bRtn = SqcCmdStartSimulation(csCmnd, csContainer, csSimuID); // 計算開始
                    }
                    else
                    {   // リセット不要ならば
                        csCmnd.m_sCmnd = HymcoCUIProgram.cmd_CMND_RESTART_SIMULATION;  // CUI制御コマンド：シミュレーション計算開始

                        bRtn = SqcCmdRestartSimulation(csCmnd, csContainer, csSimuID); // 計算開始
                    }
                    if (bRtn != true)
                    {
                        HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun start_calculation",
                            Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG);
                        iRtn = -1;
                        break;
                    }

                    // 4)計算が終了したのでロックファイルを生成する
                    CreateLockFile(m_lProcessIDNo);
                    HySLog.LogOut(HySLog.DEBUG, "HymcoCUIProgram", "ZmodeRun", "end of calculation");

#if DEBUG
                    if (m_iBreakFlg == 1)
                    {   // 常駐化ループを抜ける
                        break;
                    }
#endif
                }  // end of for(;;)
                //////////////////////////////
            }
            catch
            {
                HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun catch_exception",
                    Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG);
                iRtn = -1;
            }

            if (iRtn < 0)
            {
                HySLog.LogOut(HySLog.ONLINE, "HymcoCUIProgram", "ZmodeRun abend",
                    Properties.HymcoCUIResources.STATEMENT_SEQUENCE_NG);
            }
            else
            {
                HySLog.LogOut(HySLog.DEBUG, "HymcoCUIProgram", "end of ZmodeRun","");
            }

            System.Threading.Thread.Sleep(1333); // ログ掃出し時間確保の為
            return iRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算終了ロックファイル生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>hymcoAPIh28.CreateLockFile(lProcNo)</para>
        /// </example>
        /// <param name="iProcNo">プロセス識別番号</param>
        /// <returns>常に０</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public long CreateLockFile(long iProcNo)
        {
            string sFileName = m_sLockFileName + iProcNo.ToString();   // ロックファイル名
            if (HymcoCUIProgram.LockFileExist(iProcNo) == false)
            {   // ロックファイルが無ければ生成する
                // 指定ファイルをオープンする
                m_csFile = new FileStream(
                    sFileName,
                    FileMode.CreateNew,
                    FileAccess.Write,
                    FileShare.Write);
                m_csFile.Close();  // ファイルは生成した後すぐに閉じる
            }
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算終了ロックファイル削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>hymcoAPIh28.DeleteLockFile(lProcNo)</para>
        /// </example>
        /// <param name="iProcNo">プロセス識別番号</param>
        /// <returns>=0:正常、=-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public long DeleteLockFile(long iProcNo)
        {
            long lRtn = 0;

            if (LockFileExist(iProcNo) == true)
            {   // 指定プロセスのロックファイルが存在する
                try
                {
                    string sFileName = m_sLockFileName + iProcNo.ToString();    // ロックファイル名
                    File.Delete(sFileName); // ロックファイル削除
                }
                catch (IOException e)
                {
                    lRtn = -1;
                    Console.WriteLine("{0}:ファイル使用中", e.GetType().Name);
                }
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算終了ロックファイル存在有無確認</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>hymcoAPIh28.LockFileExist(lProcNo)</para>
        /// </example>
        /// <param name="iProcNo">プロセス識別番号</param>
        /// <returns>=true:存在する、=false:存在しない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para></para>
        /// </remarks>
        static public bool LockFileExist(long iProcNo)
        {
            string sFileName = m_sLockFileName + iProcNo.ToString();    // ロックファイル名
            return File.Exists(sFileName);
        }

        // end of Ver1.6.1

        // start of Ver1.7
        /* サーバーサイド CommonMP 製作時に復活させて実装する
        /// <summary><para>method outline:</para>
        /// <para>サーバーモード動作メイン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySControllerRoot.SVRun( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int =0;正常、 =-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Ver1.7 将来用</para>
        /// </remarks>
        public virtual int SVRun()
        {
            // Ver1.7 時に実装する
            // 将来用
            return -1; //　仮リターン値：
        }
        */
        // end of Ver1.7


        // ====================================
        //  XML 定義
        // ====================================
        /// <summary> 構造定義ファイル関連タグ </summary>
        protected static readonly string xml_SCFILE = "SCFile";
        /// <summary> ファイル名 </summary>
        protected static readonly string xml_FILE_NAME = "FileName";
        /// <summary> シミュレーション関連タグ </summary>
        protected static readonly string xml_SIMULATION = "Simulation";
        /// <summary> 時間設定関連タグ </summary>
        protected static readonly string xml_TIME = "Time";
        /// <summary> 開始時刻 </summary>
        protected static readonly string xml_START_TIME = "start";
        /// <summary> 目標時刻 </summary>
        protected static readonly string xml_GOAL_TIME = "goal";
        /// <summary> タイムステップ </summary>
        protected static readonly string xml_TIME_STEP = "delta";
        /// <summary> 単位ステップ </summary>
        protected static readonly string xml_TIME_UNIT = "Unit";
        /// <summary> 中間目標時刻 </summary>
        protected static readonly string xml_PAUSE_TIME = "pause";
        /// <summary> 時間単位：秒 </summary>
        protected static readonly string xml_TIME_SEC = "sec";
        /// <summary> 時間単位：分 </summary>
        protected static readonly string xml_TIME_MIN = "min";
        /// <summary> 時間単位：時 </summary>
        protected static readonly string xml_TIME_HOUR = "hour";
        /// <summary> 時間単位：日 </summary>
        protected static readonly string xml_TIME_DAY = "day";
        /// <summary> 時間単位：年 </summary>
        protected static readonly string xml_TIME_YEAR = "year";

        // -- Ver1.4 追加（CUI拡張）
        /// <summary>CUI制御</summary>
        protected static readonly string xml_CONTROL = "Control";
        /// <summary>CUI制御種類</summary>
        protected static readonly string xml_KIND = "kind";
        /// <summary>CUI制御の数</summary>
        protected static readonly string xml_SEQUENCE_NUM = "sequence_number";
        /// <summary>CUI制御：コマンド</summary>
        protected static readonly string xml_COMMAND = "Command";
        /// <summary>CUI制御：順番</summary>
        protected static readonly string xml_ORDER_NO = "OrderNo";
        /// <summary>CUI制御：コマンド種別</summary>
        protected static readonly string xml_COMMAND_KIND = "CommandKind";
        /// <summary>CUI制御：コマンドパラメーター１</summary>
        protected static readonly string xml_PARA1 = "para1";
        /// <summary>CUI制御：コマンドパラメーター２</summary>
        protected static readonly string xml_PARA2 = "para2";
        /// <summary>CUI制御：コマンドパラメーター３</summary>
        protected static readonly string xml_PARA3 = "para3";

        // ====================================
        //  コマンド 定義（－ｓオプション時）
        // ====================================
        /// <summary>CUI制御コマンド：シミュレーション状態保存ファイルの読み込み</summary>
        public static readonly string cmd_CMND_SIMULATOR_RESTORE = "CMND_SIMULATOR_RESTORE";
        /// <summary>CUI制御コマンド：シミュレーション状態をファイルへ保存する</summary>
        public static readonly string cmd_CMND_SIMULATOR_SAVE = "CMND_SIMULATOR_SAVE";
        /// <summary>CUI制御コマンド：シミュレーションパラメーター値修正</summary>
        public static readonly string cmd_CMND_RENEW_PARAMETER = "CMND_RENEW_PARAMETER";
        /// <summary>CUI制御コマンド：シミュレーション計算再開（CMND_SIMULATOR_RESTOREが発行された時にはここから計算を行う）</summary>
        public static readonly string cmd_CMND_RESTART_SIMULATION = "CMND_RESTART_SIMULATION";
        /// <summary>CUI制御コマンド：シミュレーション計算開始（CMND_SIMULATOR_RESTOREが発行されなかった時にはここから計算を行う）</summary>
        public static readonly string cmd_CMND_START_SIMULATION = "CMND_START_SIMULATION";

    }
}
