﻿// <summary>ソースコード：ライブラリ出力CUI　ライブラリ出力情報クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ出力CUI　ライブラリ出力情報クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/14][新規作成]</para>
    /// </remarks>
    public class McLibraryExportInfo
    {
        /// <summary>プロジェクトフォルダ名</summary>
        private HySString m_projectFolderFullPath = null;
        /// <summary>アーカイブ出力先パス</summary>
        private HySString m_archiveExportFullPath = null;
        /// <summary>開発コード出力要否</summary>
        private bool m_isOutputSourceCode = false;
        /// <summary>モデルプロジェクト実行形式ファイルパスリスト</summary>
        private HySDataLinkedList m_binaryFullPathList = null;
        /// <summary>プロパティ画面プロジェクト実行形式ファイルパスリスト</summary>
        private HySDataLinkedList m_propertyProjectBinaryFullPathList = null;
        /// <summary>モデルアイコンパスリスト</summary>
        private HySDataLinkedList m_modelIconFullPathList = null;
        /// <summary>要素モデル詳細情報ファイルパスリスト</summary>
        private HySDataLinkedList m_manualFullPathList = null;
        /// <summary>モデルプロジェクト開発コードファイルパスリスト</summary>
        private HySDataLinkedList m_devSrcFullPathList = null;
        /// <summary>プロパティ画面プロジェクトフォルダパス</summary>
        private HySString m_modelPropertyProjectFolderFullPath = null;
        /// <summary>プロパティ画面プロジェクト開発コードファイルパスリスト</summary>
        private HySDataLinkedList m_propertyProjectDevSourceFullPathList = null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLibraryExportInfo exportInfo = new McLibraryExportInfo(projectFolderFullpath, exportFullpath, binaryFullPathList, modelIconFullpathList)</para>
        /// </example>
        /// <param name="projectFolderFullpath">プロジェクトフォルダ名</param>
        /// <param name="exportFullpath">アーカイブ出力先パス</param>
        /// <param name="binaryFullPathList">実行形式ファイルパスリスト</param>
        /// <param name="modelIconFullpathList">モデルアイコンファイルパスリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibraryExportInfo(
            HySString projectFolderFullpath,
            HySString exportFullpath,
            HySDataLinkedList binaryFullPathList,
            HySDataLinkedList modelIconFullpathList
            )
        {
            m_projectFolderFullPath = projectFolderFullpath;

            m_archiveExportFullPath = exportFullpath;

            m_binaryFullPathList = binaryFullPathList;

            m_modelIconFullPathList = modelIconFullpathList;
           
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトフォルダ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString projectFolderFullpath = GetProjectFolderFullpath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>プロジェクトフォルダ名</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectFolderFullpath()
        {
            return m_projectFolderFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>アーカイブファイルパス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString exportFileFullpath = GetArchiveFileFullpath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>アーカイブ出力先パス</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetArchiveFileFullpath()
        {
            return m_archiveExportFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>開発コード出力要否設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputSourceCode(isOutputSource)</para>
        /// </example>
        /// <param name="isOutputSource">開発コード出力要否</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetOutputSourceCode(bool isOutputSource)
        {
            m_isOutputSourceCode = isOutputSource;
        }

        /// <summary><para>method outline:</para>
        /// <para>開発コード出力要否取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool isOutputSource = GetOutputSourceCode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>開発コード出力要否</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetOutputSourceCode()
        {
            return m_isOutputSourceCode;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロジェクト実行形式ファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList binaryPathList = GetBinaryFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>実行形式ファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetBinaryFullpathList()
        {
            return m_binaryFullPathList;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルアイコンパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList modelIconPathList = GetModelIconFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>モデルアイコンパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetModelIconFullpathList()
        {
            return m_modelIconFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクト実行形式ファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyProjectBinaryFullpathList(propertyProjectBinaryFullPathList)</para>
        /// </example>
        /// <param name="propertyProjectBinaryFullPathList">モデルプロジェクト開発コードファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyProjectBinaryFullpathList(HySDataLinkedList propertyProjectBinaryFullPathList)
        {
            m_propertyProjectBinaryFullPathList = propertyProjectBinaryFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクト実行形式ファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList propertyProjectBinaryFullPathList = GetPropertyProjectBinaryFullpathList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>モデルプロジェクト開発コードファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetPropertyProjectBinaryFullpathList()
        {
            return m_propertyProjectBinaryFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素モデル詳細情報ファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetManualFullpathList(manualPathList)</para>
        /// </example>
        /// <param name="manualPathList">要素モデル詳細情報ファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetManualFullpathList(HySDataLinkedList manualPathList)
        {
            m_manualFullPathList = manualPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素モデル詳細情報ファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList manualFullpathList = GetManualFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>要素モデル詳細情報ファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetManualFullPathList()
        {
            return m_manualFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロジェクト開発コードファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDevelopmentSourceFullPathList(devSrcFullParhList)</para>
        /// </example>
        /// <param name="devSrcFullParhList">モデルプロジェクト開発コードファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDevelopmentSourceFullPathList(HySDataLinkedList devSrcFullParhList)
        {
            m_devSrcFullPathList = devSrcFullParhList;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロジェクト開発コードファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList devSrcFullpathList = GetDevelopmentSourceFullPathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>モデルプロジェクト開発コードファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetDevelopmentSourceFullPathList()
        {
            return m_devSrcFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクトフォルダパス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyProjectFolderFullPath(modelPropertyProjectFolderFullPath)</para>
        /// </example>
        /// <param name="modelPropertyProjectFolderFullPath">プロパティ画面プロジェクトフォルダパス</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyProjectFolderFullPath(HySString modelPropertyProjectFolderFullPath)
        {
            m_modelPropertyProjectFolderFullPath = modelPropertyProjectFolderFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクトフォルダパス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyProjectFolderFullPath(modelPropertyProjectFolderFullPath)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>プロパティ画面プロジェクトフォルダパス</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetPropertyProjectFolderFullPath()
        {
            return m_modelPropertyProjectFolderFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクト開発コードファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyProjectDevSourceFullPathList(devSrcFullPathList)</para>
        /// </example>
        /// <param name="devSrcFullPathList">プロパティ画面プロジェクト開発コードファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyProjectDevSourceFullPathList(HySDataLinkedList devSrcFullPathList)
        {
            m_propertyProjectDevSourceFullPathList = devSrcFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ画面プロジェクト開発コードファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList devSrcFullPathList = GetPropertyProjectDevSourceFullPathList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>プロパティ画面プロジェクト開発コードファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetPropertyProjectDevSourceFullPathList()
        {
            return m_propertyProjectDevSourceFullPathList;
        }
    }
}
