﻿// <summary>ソースコード：ライブラリ入力CUI　ライブラリ入力引数変換クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Security;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ入力CUI　ライブラリ入力引数変換クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/22][新規作成]</para>
    /// </remarks>
    public class McLibraryImportArgsConverter
    {
        /// <summary><para>method outline:</para>
        /// <para>ライブラリ入力引数変換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int code = ConvertLibraryImportArgs(args,out archiveFilePath) </para>
        /// </example>
        /// <param name="args">入力配列</param>
        /// <param name="archiveFilePath">アーカイブファイルパス</param>
        /// <returns><para>0:正常 -1:コマンド構文不正 -2:入力ファイルパス不正 </para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public int ConvertLibraryImportArgs(
            string[] args,
            out HySString archiveFilePath
            )
        {
            archiveFilePath = null;

            if (args.Length != 2)
            {   // 引数の数が2以外の場合
               // ver1.5 エラートレース日本語対応
                LogOut("ConvertLibraryImportArgs", Properties.HymcoCUIResources.STATEMENT_ARG_NUM_ELEMENT_NG + args.Length.ToString());
               // LogOut("ConvertLibraryImportArgs", "引数の要素数異常 args.Length:" + args.Length.ToString());
                return (-1);
            }

            if (args[0] != "-e")
            {   // オプションが"-e"でない場合
               // ver1.5 エラートレース日本語対応
                LogOut("ConvertLibraryImportArgs", Properties.HymcoCUIResources.STATEMENT_SYNTAX_NG + args[0]);
               // LogOut("ConvertLibraryImportArgs", "構文不正 args[0]:" + args[0]);
                return (-1);
            }

            HySString archiveFilePath_work = new HySString(args[1]);
            try{
                
                // パスが相対パスなのか絶対パスなのかをチェックする
                bool result = System.IO.Path.IsPathRooted(archiveFilePath_work.ToString());

                // 相対パスの場合は絶対パスに変換する
                if (result == false)
                {
                    System.Environment.CurrentDirectory = System.IO.Directory.GetCurrentDirectory();

                    archiveFilePath_work = new HySString(System.IO.Path.GetFullPath(archiveFilePath_work.ToString()));
                }

                // アーカイブファイルパスの存在有無をチェックする
                result = HySFileUtility.ExistFile(archiveFilePath_work);
                if (result == false)
                {
                   // ver1.5 エラートレース日本語対応
                    LogOut("ConvertLibraryImportArgs", Properties.HymcoCUIResources.STATEMENT_ARCHIVE_FILE_NO + archiveFilePath_work.ToString());
                   // LogOut("ConvertLibraryImportArgs", "アーカイブファイルが存在しませんでした。 archiveFilePath_work:" + archiveFilePath_work.ToString());
                    return (-2);
                }
            }
            // アーカイブファイルパスに無効なものが含まれている例外が発生した場合
            catch (ArgumentException ex)
            {
                LogOut("ConvertLibraryImportArgs", "archiveFilePath_work:" + archiveFilePath_work.ToString()
                    + Environment.NewLine + ex.ToString());
                return (-2);
            }
            // 呼び出されたメソッドがサポートされていない例外が発生した場合
            catch (NotSupportedException ex)
            {
                LogOut("ConvertLibraryImportArgs", "archiveFilePath_work:" + archiveFilePath_work.ToString()
                    + Environment.NewLine + ex.ToString());
                return (-2);
            }
            // セキュリティエラーが発生した場合
            catch (SecurityException ex)
            {
                LogOut("ConvertLibraryImportArgs", "archiveFilePath_work:" + archiveFilePath_work.ToString()
                    + Environment.NewLine + ex.ToString());
                return (-2);
            }
            // プロジェクトフォルダ名が最大長を超える例外が発生した場合
            catch (PathTooLongException ex)
            {
                LogOut("ConvertLibraryImportArgs", "archiveFilePath_work:" + archiveFilePath_work.ToString()
                    + Environment.NewLine + ex.ToString());
                return (-2);
            }

            archiveFilePath = archiveFilePath_work;
            return 0;
        }
           
        /// <summary><para>method outline:</para>
        /// <para>エラーメッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString message = GetErrorMessage(errorCode) </para>
        /// </example>
        /// <param name="errorCode">エラーコード</param>
        /// <returns><para>エラーメッセージ</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public HySString GetErrorMessage(
            int errorCode
            )
        {
            string errorComment = "";
            switch (errorCode)
            {
                case (-1):
                    errorComment = "コマンドラインの構文が不正です。\r\nコマンドラインが規定された形式であることを確認して下さい。";
                    break;
                case (-2):
                    errorComment = "指定された入力ファイルパスは存在しません。\r\n入力ファイルパスを確認して、再度操作を行って下さい。";
                    break;
                case (-999):
                    errorComment = "ライブラリ入力に失敗しました。";
                    break;
                default:
                    break;
            }
            HySString message = new HySString(errorComment);
            return message;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>ログ出力処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> LogOut(methodName, message) </para>
        /// </example>
        /// <param name="methodName">メソッド名称</param>
        /// <param name="message">出力メッセージ</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void LogOut(string methodName, string message)
        {
            HySLog.LogOut(HySLog.ONLINE, "McLibraryImportArgsConverter", methodName, message);
        }

    }
}
