﻿// <summary>ソースコード：ライブラリ入力CUI　ライブラリインポータークラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CUI.HymcoCUI
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ入力CUI　ライブラリインポータークラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/23][新規作成]</para>
    /// </remarks>
    public class McLibraryImporter
    {
        /// <summary><para>method outline:</para>
        /// <para>入力実行</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int result = Import(archiveFileFullPath) </para>
        /// </example>
        /// <param name="archiveFileFullPath">アーカイブファイルパス</param>
        /// <returns><para>0: 正常終了 -1:ZIP形式変換エラー</para>
        /// <para>-2:入出力エラー -3:サポート対象外データ</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        static public int Import(
            HySString archiveFileFullPath
            )
        {
            try
            {
                HySExpander zipExpander = new HySDotNetZipExpander(archiveFileFullPath);

                // エントリ名取得
                List<HySStringRoot> entryList = zipExpander.GetAllEntryName();

                // 指定されたアーカイブがサポート対象か判定する
                bool result = IsSupportArchive(
                    archiveFileFullPath,
                    entryList
                    );
                if (result == false)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(
                        HySLog.ONLINE,
                        "McLibraryImporter",
                        "Import",
                        Properties.HymcoCUIResources.STATEMENT_ARCHIVEFILE_PATH + archiveFileFullPath.ToString()
                        );
                   // HySLog.LogOut(
                   //     HySLog.ONLINE,
                   //     "McLibraryImporter",
                   //     "Import",
                   //     "archiveFileFullPath:" + archiveFileFullPath.ToString()
                   //     );
                    return (-3);
                }
                // 展開対象パスを作成
                entryList = CreateTargetEntry(entryList);

                // 作成したパスを展開対象エントリに指定
                zipExpander.AddTargetEntry(entryList);

                // ホームディレクトリパス取得
                HySString homeDirectory = HySEnvInf.GetHomeDirectory();
                zipExpander.Expand(homeDirectory);
            }
            // Zipファイル形式エラー
            catch (Ionic.Zip.ZipException exp)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McLibraryImporter",
                    "Import",
                    Properties.HymcoCUIResources.STATEMENT_ARCHIVE_DEPLOYMENT_ERR + exp.ToString() +
                    "archiveFileFullPath:" + archiveFileFullPath.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
               //     "McLibraryImporter",
               //     "Import",
               //     "アーカイブ展開処理で例外発生:" + exp.ToString() +
               //     "archiveFileFullPath:" + archiveFileFullPath.ToString()
               //     );
                return -1;
            }
            catch (System.IO.FileNotFoundException exp)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McLibraryImporter", "Import",
                    Properties.HymcoCUIResources.STATEMENT_ARCHIVE_DEPLOYMENT_ERR + exp.ToString() + " " +
                    "archiveFileFullPath:" + archiveFileFullPath.ToString()
                    );
               // HySLog.LogOut(HySLog.ONLINE, "McLibraryImporter", "Import",
               //     "アーカイブ展開処理で例外発生:" + exp.ToString() + " " +
               //     "archiveFileFullPath:" + archiveFileFullPath.ToString()
               //     );
                return -2;
            }
            return 0;
        }

        # region J# 固有処理
        ///// <summary><para>method outline:</para>
        ///// <para>入力実行</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> int result = Import(archiveFileFullPath) </para>
        ///// </example>
        ///// <param name="archiveFileFullPath">アーカイブファイルパス</param>
        ///// <returns><para>0: 正常終了 -1:ZIP形式変換エラー</para>
        ///// <para>-2:入出力エラー -3:サポート対象外データ</para></returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks> 
        //static public int Import(
        //    HySString archiveFileFullPath
        //    )
        //{
        //    try
        //    {
        //        HySExpander zipExpander = new HySDotNetZipExpander(archiveFileFullPath);

        //        // エントリ名取得
        //        List<HySStringRoot> entryList = zipExpander.GetAllEntryName();

        //        // 指定されたアーカイブがサポート対象か判定する
        //        bool result = IsSupportArchive(
        //            archiveFileFullPath,
        //            entryList
        //            );
        //        if (result == false)
        //        {
        //            HySLog.LogOut(
        //                HySLog.ONLINE,
        //                "McLibraryImporter",
        //                "Import",
        //                "archiveFileFullPath:" + archiveFileFullPath.ToString()
        //                );
        //            return (-3);
        //        }
        //        // 展開対象パスを作成
        //        entryList = CreateTargetEntry(entryList);

        //        // 作成したパスを展開対象エントリに指定
        //        zipExpander.AddTargetEntry(entryList);

        //        // ホームディレクトリパス取得
        //        HySString homeDirectory = HySEnvInf.GetHomeDirectory();
        //        zipExpander.Expand(homeDirectory);
        //    }
        //    // Zipファイル形式エラー
        //    catch (java.util.zip.ZipException exp)
        //    {
        //        HySLog.LogOut(
        //            HySLog.ONLINE,
        //            "McLibraryImporter",
        //            "Import",
        //            "アーカイブ展開処理で例外発生:" + exp.ToString() +
        //            "archiveFileFullPath:" + archiveFileFullPath.ToString()
        //            );
        //        return -1;
        //    }
        //    // 入出力エラー
        //    catch (java.io.IOException exp)
        //    {
        //        HySLog.LogOut(
        //            HySLog.ONLINE,
        //            "McLibraryImporter",
        //            "Import",
        //            "アーカイブ展開処理で例外発生:" + exp.ToString() + "" +
        //            "archiveFileFullPath:" + archiveFileFullPath.ToString()
        //            );
        //        return -1;
        //    }
        //    catch (System.IO.FileNotFoundException exp)
        //    {
        //        HySLog.LogOut(HySLog.ONLINE, "McLibraryImporter", "Import",
        //            "アーカイブ展開処理で例外発生:" + exp.ToString() + " " +
        //            "archiveFileFullPath:" + archiveFileFullPath.ToString()
        //            );
        //        return -2;
        //    }
        //    return 0;
        //}
        # endregion

        /// <summary><para>method outline:</para>
        /// <para>エラーメッセージ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString message = GetErrorMessage(errorCode) </para>
        /// </example>
        /// <param name="errorCode">エラーコード</param>
        /// <returns><para>エラーメッセージ</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public HySString GetErrorMessage(
            int errorCode
            )
        {
            string errorComment = "";
            switch (errorCode)
            {
                case (-1):
                    errorComment = "ファイルにアクセスしようとして異常が発生しました。";
                    break;
                case (-2):
                    errorComment = "ディスク上に存在しないファイルにアクセスしようとして失敗しました。";
                    break;
                case (-3):
                    errorComment = "指定されたアーカイブはサポート対象外のファイルです。";
                    break;
                default:
                    break;
            }
            HySString message = new HySString(errorComment);
            return message;
        }

        /// <summary><para>method outline:</para>
        /// <para>サポートするアーカイブかチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool result = IsSupportArchive(archiveFileFullPath, entryList) </para>
        /// </example>
        /// <param name="archiveFileFullPath">アーカイブファイルパス</param>
        /// <param name="entryList">エントリ名リスト</param>
        /// <returns><para>true:サポート対象 false:サポート対象外</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>アーカイブのエントリ内に実行形式ファイルが存在する場合はtrueを返却し、
        /// 存在しない場合はfalseを返却する</para>
        /// </remarks>
        static private bool IsSupportArchive(
            HySString archiveFileFullPath,
            List<HySStringRoot> entryList
            )
        {
            bool isSupport = false;
            // エントリ名に実行形式ファイルが存在するか確認する
            for (int i = 0; i < entryList.Count; i++)
            {
                HySString fileName = (HySString)entryList[i];
                if ((fileName.ToString().StartsWith("bin\\")) && (fileName.ToString().EndsWith(".dll")))
                {
                    isSupport = true;
                    break;
                }
            }
            if (isSupport == false)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(
                    HySLog.ONLINE,
                    "McLibraryImporter",
                    "IsSupportArchive",
                    Properties.HymcoCUIResources.STATEMENT_ARCHIVE_NOT_EXECUTA 
                    + Properties.HymcoCUIResources. STATEMENT_ARCHIVEFILE_PATH + archiveFileFullPath.ToString()
                    );
               // HySLog.LogOut(
               //     HySLog.ONLINE,
                //     "McLibraryImporter", STATEMENT_ARCHIVE_NOT_EXECUTA STATEMENT_ARCHIVEFILE_PATH          
               //     "IsSupportArchive",
               //     "アーカイブに実行形式ファイルが含まれていません。 archiveFileFullPath:" + archiveFileFullPath.ToString()
               //     );
                return false;
            }

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>展開対象エントリ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> List entryList = CreateTargetEntry(entryList) </para>
        /// </example>
        /// <param name="entryList">エントリ名リスト</param>
        /// <returns><para>展開対象エントリ名リスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static private List<HySStringRoot> CreateTargetEntry(List<HySStringRoot> entryList)
        {
            List<HySStringRoot> targetEntryList = new List<HySStringRoot>();

            for (int i = 0; i < entryList.Count; i++)
            {
                // エントリ名の要素を確認する
                // 展開対象エントリ名ならば展開対象エントリリストに追加する
                HySString entry = (HySString)entryList[i];
                bool binResult = entry.ToString().StartsWith("bin\\");
                bool modelIconResult = entry.ToString().StartsWith("ModelIcon\\");
                bool modelManualResult = entry.ToString().StartsWith("ModelManual\\");

                if (binResult == true ||
                    modelIconResult == true ||
                    modelManualResult == true
                    )
                {
                    targetEntryList.Add(entry);
                }
            }

            return targetEntryList;
        }
    }
}
