﻿// <summary>ソースコード：プロジェクトデータ変換用業務処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;

namespace CommonMP.HYMCO.CoreImpl.BusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>プロジェクトデータ変換用業務処理クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/1/7][新規作成]</para>
    /// </remarks>
    public class McDBCnvSubBusiProcedure : HySRoot
    {

        /// <summary>変換フォルダ名</summary>
        private static readonly string CNV_DIR = "CmpProject.Ver1.0";

        /// <summary>ＨＹＭＣＯ業務処理クラス</summary>
        private McBusiProcedure m_csBusiProcedure ;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDBCnvSubBusiProcedure cdBusiProc = new McDBCnvSubBusiProcedure( csBusiProcedure )</para>
        /// </example>
        /// <param name="csBusiProcedure">業務処理クラス</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDBCnvSubBusiProcedure(McBusiProcedure csBusiProcedure)
        {
            m_csBusiProcedure = csBusiProcedure;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>=true:正常, =false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csEventObj = (HySEventObject)csEvent;
            long lEventNo = csEventObj.GetEventNo();
            long lSubEventNo = csEventObj.GetSubEventNo();
            
            if(lEventNo == HySEventObject.CMND_DB_COMMON)
            {// DB関連処理
                if (lSubEventNo == McDefine.HYM_PRJDATA_CONVERT_SET_ID)
                {// インポート情報取得成功
                    // ファイル格納
                    bRtn = PrjectOut(csEvent);
                }
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        public Boolean PutEvent(HySSysEvent csEvent)
        {
            Boolean bRtn = false;
            
            bRtn = m_csBusiProcedure.PutEvent(csEvent);

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = PrjectOut(csEvent) </para>
        /// </example>
        /// <param name="csEvent">イベント情報</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected Boolean PrjectOut(HySSysEvent csEvent)
        {
            Boolean bRtn = true;

            HySEventObject csEventObj = (HySEventObject)csEvent;
            HySDataLinkedList csContainerList = (HySDataLinkedList)csEventObj.GetData();
            HySDataLinkedList csCmpImportDataList = new HySDataLinkedList();

            csContainerList.SetCursorFirst();
            // リスト内部の全てのデータコンテナを処理する
            for (int i = 0; i < csContainerList.GetCount(); i++)
            {
                HySSimulationDataContainer csSimuDataContainer = (HySSimulationDataContainer)csContainerList.GetCursorData();
                // ここで、ファイルを書き出す
                if (csSimuDataContainer != null)
                {
                    if (SaveProject(csSimuDataContainer) == true)
                    {// ファイル作成成功
                        // インポート成功リストに追加
                        csCmpImportDataList.AddLast(csSimuDataContainer);
                    }
                    else
                    {// ファイル作成失敗
                        bRtn = false;
                    }
                }
                else
                {// 情報無し
                    bRtn = false;
                }
                csContainerList.MoveCursorNext();
            }

            // インポート完了イベントの送信
            csEventObj.SetTo(HySSysEvent.OBJID_VIEWER);
            csEventObj.SetToSimKind(McDefine.SIMULATOR_KIND);
            if (csContainerList.GetCount() == csCmpImportDataList.GetCount())
            {// 全て処理完了
                csEventObj.SetEventNo(HySEventObject.NOTICE_DB_OK);
            }
            else
            {// 異常有り
                csEventObj.SetEventNo(HySEventObject.NOTICE_DB_NG);
            }
            csEventObj.SetSubEventNo(McDefine.HYM_PRJDATA_IMPORT);
            csEventObj.SetSubData((HySDataRoot)csCmpImportDataList);
            if (!PutEvent(csEventObj))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "PrjectOut",
                    Properties.HymcoImplResources.STATEMENT_SEND_FAILURE + "(" + Properties.HymcoImplResources.STATEMENT_NORM_ABROM_REPORT
                        + ":" + Properties.HymcoImplResources.STATEMENT_PROJ_INPORT + ")");
               // HySLog.LogOut(HySLog.ONLINE, "PrjectOut", "イベント送信失敗(正常異常報告：プロジェクトインポート) ");
                return false;
            }

            return bRtn;
        }
                     
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報ファイル作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SaveProject(csContainer) </para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected Boolean SaveProject(HySSimulationDataContainer csContainer)
        {
            bool bRtn = false;
            McProjectInfData csPrjctInf = csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO) as McProjectInfData;
            if ((object)csPrjctInf.GetProjectGroupName() == null)
            {// グループ情報がない場合
                csPrjctInf.SetProjectGroupName(new HySString(CNV_DIR));
            }

            // フォルダ作成
            this.MakeProjectGroupFolder(csPrjctInf);

            string sPrjName = csPrjctInf.GetProjectName().ToString();

            string sPrjFileName = HySEnvInf.GetDataHomeDirectory().ToString() + "\\"
                   + csPrjctInf.GetProjectGroupName().ToString() + "\\"
                   + sPrjName + ".cmprj";
            HySFile csPrjFile = new HySFile(sPrjFileName);
            if (csPrjFile.Exist() == true)
            {
                HySString csNewPrjName = new HySString(sPrjName + "_" + csPrjctInf.GetProjectID().ToString());

                // ファイル名変更
                sPrjFileName = HySEnvInf.GetDataHomeDirectory().ToString() + "\\"
                   + csPrjctInf.GetProjectGroupName().ToString() + "\\"
                   + csNewPrjName.ToString() + ".cmprj";

                // プロジェクト名変更
                csPrjctInf.SetProjectName(csNewPrjName);

               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", 
                    Properties.HymcoImplResources.STATEMENT_FILE_SAME_NAME + Properties.HymcoImplResources.STATEMENT_GRANT_PROJ_ID );
               // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "同名のﾌｧｲﾙが存在するため、ﾌｧｲﾙ名にﾌﾟﾛｼﾞｪｸﾄIDを付与します。");
                csPrjFile = new HySFile(sPrjFileName);
            }

            if (csPrjFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
            {
                try
                {
                    if (csPrjFile.DataWrite(csContainer) == true)
                    {
                        // ver1.5 エラートレース日本語対応
                        string DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_SAVE + Properties.HymcoImplResources.STATEMENT_PROJ_NAME
                            + "[" +  csPrjctInf.GetProjectName().ToString() + "]" 
                            + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME + "[" + sPrjFileName + "]";
                        HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                       // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄを保存しました。 ﾌﾟﾛｼﾞｪｸﾄ名[" + csPrjctInf.GetProjectName().ToString() + "] ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "]");
                        bRtn = true;
                    }
                    else
                    {
                        // エラー
                       // ver1.5 エラートレース日本語対応
                        string DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_WRT_ERR + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME
                            + "[" + sPrjFileName + "]";
                        HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                       // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ書き込みに失敗しました：ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "]");
                    }
                }
                catch (Exception ex)
                {
                    // エラー
                   // ver1.5 エラートレース日本語対応
                    string DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_WRT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME
                        + "[" + sPrjFileName + "]" + Properties.HymcoImplResources.STATEMENT_EXCEPTION_MSG  +  ex.Message ;
                    HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                   // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ書き込みに時に例外を検出しました：ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "] 例外メッセージ=" + ex.Message);

                }
                csPrjFile.Close();
            }
            else
            {
                sPrjFileName = HySEnvInf.GetDataHomeDirectory().ToString() + "\\"
                   + csPrjctInf.GetProjectGroupName().ToString() + "\\"
                   + csPrjctInf.GetProjectID().ToString() + ".cmprj";

                csPrjctInf.SetProjectName(new HySString(csPrjctInf.GetProjectID().ToString()));

               // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.HymcoImplResources.STATEMENT_FILE_NOCREAT_RENAME + Properties.HymcoImplResources.STATEMENT_NEW_FILE_NEME
                    + "[" + sPrjFileName + "]";
                HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
               // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌｧｲﾙが生成できないので名称を自動的に変更します : 新ﾌｧｲﾙ名[" + sPrjFileName + "]");
                csPrjFile = new HySFile(sPrjFileName);
                if (csPrjFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR) == 0)
                {
                    try
                    {
                        if (csPrjFile.DataWrite(csContainer) == true)
                        {
                           // ver1.5 エラートレース日本語対応
                            DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_SAVE + Properties.HymcoImplResources.STATEMENT_PROJ_NAME
                                + "[" + csPrjctInf.GetProjectName().ToString() + "]" + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME 
                                + "[" + sPrjFileName + "]";
                            HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                           // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄを保存しました。 ﾌﾟﾛｼﾞｪｸﾄ名[" + csPrjctInf.GetProjectName().ToString() + "] ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "]");
                            bRtn = true;
                        }
                        else
                        {
                            // エラー
                            // ver1.5 エラートレース日本語対応
                            DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_WRT_ERR + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME
                                +"[" + sPrjFileName + "]";
                            HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                           // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ書き込みに失敗しました：ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "]");
                        }
                    }
                    catch (Exception ex)
                    {
                        // エラー
                       // ver1.5 エラートレース日本語対応
                        DispStatement = Properties.HymcoImplResources.STATEMENT_PROJ_WRT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_PROJ_FILE_NEME
                            + "[" +  sPrjFileName + "]" + Properties.HymcoImplResources.STATEMENT_EXCEPTION_MSG + ex.Message;
                        HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", DispStatement );
                       // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ書き込みに時に例外を検出しました：ﾌﾟﾛｼﾞｪｸﾄﾌｧｲﾙ名[" + sPrjFileName + "] 例外メッセージ=" + ex.Message);
                    }
                    csPrjFile.Close();
                }
                else
                {
                    // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", Properties.HymcoImplResources.STATEMENT_FILE_NOT_CREATE );
                   // HySLog.LogOut(HySLog.ONLINE, "McDBCnvSubBusiProcedure::SaveProject", "ﾌｧｲﾙが生成できませんでした。");
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトグループフォルダーの作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeProjectGroupFolder(csPrjctInf) </para>
        /// </example>
        /// <param name="csPrjctInf">プロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void MakeProjectGroupFolder(McProjectInfData csPrjctInf)
        {
            HySString csDataHomeDir = HySEnvInf.GetDataHomeDirectory() + new HySString("\\");
            HySString csPrjGrName = csPrjctInf.GetProjectGroupName() + new HySString("\\");

            HySString csReadData = new HySString("InputData\\");
            HySString csParameterData = new HySString("ParameterData\\");
            HySString csOutputData = new HySString("OutputData\\");
            HySString csRefInfo = new HySString("RefInfo\\");
            HySString csSCF = new HySString("SCF\\");
            HySString csSupp = new HySString("Supp\\");
            HySString mkDirFile = new HySString("ReadMe.txt");

            HySFile csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csReadData + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("入力データ等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csParameterData + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("パラメーターデータ等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csOutputData + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("計算結果等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csRefInfo + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("本プロジェクトグループに関する解説等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csSCF + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("構造定義ファイル等格納場所");
                csPrjGrFlder.Close();
            }
            csPrjGrFlder = new HySFile(csDataHomeDir + csPrjGrName + csSupp + mkDirFile);
            if (csPrjGrFlder.Exist() == false)
            {// ファイル無し、作成
                csPrjGrFlder.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
                csPrjGrFlder.WriteText("その他の補足情報格納場所");
                csPrjGrFlder.Close();
            }
        }

    }
}
