﻿// <summary>ソースコード：ＨＹＭＣＯ業務処理クラス</summary>
// <author>CommonMP</author>
using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.IO;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSSimulator;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.ProjectCtl;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.FigureUnity;

namespace CommonMP.HYMCO.CoreImpl.BusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ業務処理クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McBusiProcedure : HySBusiProcedure
    {
        /// <summary>業務動作中フラグ</summary>
        protected bool m_bWorkFlg = false;

        /// <summary>シミュレータカウンタ</summary>
        protected ulong m_ulSimCounter = 1;

        /// <summary>シミュレータ識別子</summary>
        protected HySKind m_csSimKindID;

        /// <summary>業務管理制御クラス</summary>
        protected HySControllerRoot m_csController = null;

        /// <summary>データコンテナ管理テーブル</summary>
        protected HySDataHashTable m_csDataContainerTbl = new HySDataHashTable();

        /// <summary>ファイルパス管理テーブル</summary>
        protected HySDataHashTable m_csFilePathTbl = new HySDataHashTable();

        /// <summary>プロジェクトデータコピー登録用プロジェクトID管理テーブル</summary>
        protected HySDataHashTable m_csProjectIDTbl = new HySDataHashTable();

        /// <summary>シミュレーションファクトリークラス</summary>
        protected McFigureUnityFactory m_csSimFactory = null;

        /// <summary>モデルジェネレータークラス</summary>
        protected McModelGeneratorController m_csModelGenerator = null;
        /// <summary>モデルジェネレーターへの送信イベント </summary>
        protected HySSysEvent                m_csMdlGenerationEvent=null;
        /// <summary>モデルジェネレーター動作中 </summary>
        protected bool bMdlGenerationBusyFlg = false;

        /// <summary>プロジェクトデータ変換用業務処理クラス</summary>
        private McDBCnvSubBusiProcedure m_csSubBusiProcedure = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McBusiProcedure cdBusiProc = new McBusiProcedure( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McBusiProcedure 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McBusiProcedure()
        {
            m_csSubBusiProcedure = new McDBCnvSubBusiProcedure(this);
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McBusiProcedure cdBusiProc = new McBusiProcedure(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>McBusiProcedure 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McBusiProcedure(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
            m_csSubBusiProcedure = new McDBCnvSubBusiProcedure(this);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKindID = csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bVar = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Initialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Initialize()
        {
            m_bWorkFlg = true;
            McLog.Reset(); // ログファイルのリセット
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Terminate( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean Terminate()
        {
            // セーブしていないファイル等セーブ問い合わせ等を行う。

            // 非セーブ情報あれば　セーブ等を行う

            m_bWorkFlg = false;
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>制御クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetController( csCtl ) </para>
        /// </example>
        /// <param name="csCtl">制御クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetController(HySControllerRoot csCtl)
        {
            m_csController = csCtl;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを受け取った時に動作するメソッド</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EventCallback( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>各実装クラスは受け取ったイベント毎に処理を行う</para>
        /// </remarks>
        virtual public Boolean EventCallback(HySSysEvent csEvent)
        {
            Boolean bRtn = true;
            HySEventObject csHySEvent = (HySEventObject)csEvent;
            long lEventNo = csHySEvent.GetEventNo();
            long lSubEventNo = csHySEvent.GetSubEventNo();
            HySKind csSimKind = csHySEvent.GetToSimKind();

            if (lEventNo == HySEventObject.NOTICE_MAINVIWER_RUN_COMPLETE)  // メイン画面起動完了
            {
                // ライブラリ検索要求
                bRtn = this.NoticeQueryLibraryReqest(csHySEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_DISPLY_OK)
            {
                // スクリーン表示完了報告
                bRtn = this.NoticeScreenDisp(csHySEvent);
            }
            else if (lEventNo == HySEventObject.CMND_NEW_SIMULATOR_CREATE)
            {
                // シミュレーター（演算単位系）新規作成指示（プロジェクト新規作成）
                bRtn = this.CmndMakeNewSimulator(csHySEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATOR_CREATE_SUCCESS)
            {
                // シミュレーター（演算単位系）新規作成完了報告
                bRtn = this.NoticeSimulatorMakeEnd(csHySEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_RESTORE)
            {
                // シミュレーター復元完了報告
                bRtn = this.NoticeEndSimulatorRestore(csHySEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE ||
                    lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE_NG)
            {
                // シミュレーター保存完了報告
                bRtn = this.NoticeEndSimulatorSave(csHySEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_DELETE)
            {
                // シミュレーター破棄完了報告
                this.NoticeEndSimulatorDelete(csHySEvent);
            }
            // ☆☆☆演算制御部指示は素通りさせる（）
            else if (lEventNo == HySEventObject.CMND_SIMULATION_COMMON)
            {   //シミュレーション関連一般指示
                //素通りさせる
                if (lSubEventNo == HySSimulatorDefine.SIMULATION_DATA_CREATE)
                {   // シミュレーションモデル生成指示の場合
                    //if (csEvent.From() == HySSysEvent.OBJID_SIMULATOR)
                    //{   // 演算モデル側からのメッセージの場合　　＜－－このイベントは有り得ない
                    //    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                    //    csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                    //    bRtn = this.PutEvent(csEvent);
                    //}
                    //else
                    {   // 画面からのメッセージの場合
                        if (bMdlGenerationBusyFlg != true)
                        {   // シミュレーションモデル生成中でないならば
                            bMdlGenerationBusyFlg = true;
                            m_csMdlGenerationEvent = csEvent;

                            // シミュレーション生成スレッド処理スタート
                            ThreadStart ThSt = new ThreadStart(this.CreateSimulationInfo);
                            Thread t = new Thread(ThSt);
                            // UIのカルチャ設定が引き継がれないため、設定する。
                            t.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;
                            t.Start();
                        }
                        else
                        {   // シミュレーションモデル生成中ならば
                            csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                            csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                            McMdlDtGenAckInfo csSubDt =
                                new McMdlDtGenAckInfo(false, new HySString("他のモデル生成中です。"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                            ((HySEventObject)csEvent).SetSubData(csSubDt);
                            bRtn = this.PutEvent(csEvent);
                        }
                    }
                }
                else if (lSubEventNo == HySSimulatorDefine.SIMULATION_DATA_CREATE_BREAK)
                {   // シミュレーションモデル生成中断指示の場合
                    if (this.m_csModelGenerator != null)
                    {
                        this.m_csModelGenerator.BreakCreation(ref csEvent);
                    }
                }
                else
                {
                    csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR); // 宛先をシミュレーターに変更
                    bRtn = this.PutEvent(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.CMND_REPORT_SIMU_PROGRESS)
            {
                csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR); // 宛先をシミュレーターに変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_START_SIMULATION)
            {
                bRtn = SetCalcLotInfo(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_INITIALIZE_SIMULATION ||
                        lEventNo == HySEventObject.CMND_PAUSE_SIMULATION ||
                        lEventNo == HySEventObject.CMND_RESTART_SIMULATION ||
                        lEventNo == HySEventObject.CMND_STOP_SIMULATION ||
                        lEventNo == HySEventObject.CMND_RENEW_INPUTDATA ||
                        lEventNo == HySEventObject.CMND_MODEL_CONSTRUCTION //||
                        //lEventNo == HySEventObject.CMND_SIMULATION_COMMON
                      )
            {
                //シミュレーション初期化指示
                //シミュレーション開始指示
                //シミュレーション中断指示
                //シミュレーション再開指示
                //シミュレーション強制終了指示
                //シミュレーション入力情報取り込み指示(入力情報が更新された場合等)
                //シミュレーションモデル作成開始指示


                // コンテナに必要情報設定
                HySString csPrcID = (HySString)((HySEventObject)csEvent).GetSuppID().GetString();
                HySString csPrcKind = (HySString)((HySEventObject)csEvent).GetToSimKind().GetString();
                HySString csPrcKey = csPrcKind + csPrcID;
                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];

                McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
                McFigUnityPropertyInfo csFigUPrpty = csStructInfo.GetModelInfo().GetPropertyInfo() as McFigUnityPropertyInfo;

                if (lEventNo == HySEventObject.CMND_INITIALIZE_SIMULATION ||
                    lEventNo == HySEventObject.CMND_MODEL_CONSTRUCTION)
                {   // 計算パラメータ設定（非再開）
                    SetContainerTimeParameter(csContainer, false);

                }
                else if (lEventNo == HySEventObject.CMND_RESTART_SIMULATION)
                {   // 計算パラメータ設定（再開）
                    SetContainerTimeParameter(csContainer, true);
                }

                // モデル保存状態の変更
                McSimulationStatus csSimulationStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                if (csSimulationStatus.GetModelSaveStatus() == McSimulationStatus.ModelSaveStatus.SAVED)
                {
                    // 開く実行直後・保存直後等の状態時、計算処理が行われた場合に保存状態を変更する
                    csSimulationStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.UNSAVED);
                }
                csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR); // 宛先をシミュレーターに変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_SIMULATOR_RESTORE)
            {
                // シミュレータ復元指示
                csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR); // 宛先をシミュレーターに変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_SIMULATOR_SAVE)
            {
                // シミュレーター保存指示報告
                bRtn = this.CmndSimulatorSave(csHySEvent);
            }
            // ☆☆☆演算制御部応答は素通りさせる（）
            else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_START_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_CANNOT_START_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_STOP_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_REPORT_SIMU_PROGRESS ||
                        lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND ||
                        lEventNo == HySEventObject.NOTICE_RENEW_SIMULATION ||
                        lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION ||
                        lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION ||
                        lEventNo == HySEventObject.NOTICE_SIMULATION_OK /* || */
                        //lEventNo == HySEventObject.NOTICE_SIMULATION_NG
                     )
            {
                //シミュレーション初期化完了報告
                //シミュレーション計算開始報告
                //シミュレーション計算中断報告
                //シミュレーション再開報告
                //シミュレーション計算終了指示応答
                //シミュレーション計算完了報告
                //シミュレーション中間結果変更報告
                //シミュレーションモデル作成終了報告（正常）
                //シミュレーションモデル作成終了報告（異常）


                HySString csPrcID = (HySString)((HySEventObject)csEvent).GetSuppID().GetString();
                HySString csPrcKind = (HySString)((HySEventObject)csEvent).GetToSimKind().GetString();
                HySString csPrcKey = csPrcKind + csPrcID;

                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];
                McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);

                // 中断時刻指定有時の完了報告は中断報告に修正する
                if ((lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION) && (csProjectInf.GetSuspendTime() != null))
                {
                    lEventNo = HySEventObject.NOTICE_PAUSE_SIMULATION;
                    ((HySEventObject)csEvent).SetEventNo(HySEventObject.NOTICE_PAUSE_SIMULATION);
                }
                // 計算状態ステータス更新
                //UpdateSimulationStatus(csPrcKey, lEventNo);
                UpdateSimulationStatus(csPrcKey, csEvent);

                if (lSubEventNo == McDefine.HYM_NOTICE_STRUCT_FILE_READ_REQUEST ||
                    lSubEventNo == McDefine.HYM_NOTICE_STRUCT_FILE_WRITE_REQUEST)
                {
                    ((HySEventObject)csEvent).SetEventNo(HySEventObject.CMND_DISPLY_COMMON);
                }

                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATION_NG)
            {
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER);    // 宛先を画面に変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_DB_REGISTER)
            {
                bRtn = RegisterProject((HySEventObject)csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_DB_DELETE ||
                    lEventNo == HySEventObject.CMND_DB_QUERY ||
                    lEventNo == HySEventObject.CMND_DB_COMMON)
            {
                if (lSubEventNo == McDefine.HYM_PRJDATA_CONVERT_SET_ID)
                {// プロジェクトデータ取込要求であればサブ業務に処理を委譲
                    SetIDToImportProject(csEvent);
                    bRtn = m_csSubBusiProcedure.EventCallback(csEvent);
                }
                else
                {
                    csEvent.SetTo(HySSysEvent.OBJID_LIBMANAGER); // 宛先をライブラリ管理に変更

                    // サブイベント番号がインポートプロジェクトID設定の場合はID再設定処理を実行
                    if (lSubEventNo == McDefine.HYM_PRJDATA_IMPORT_SET_ID)
                    {
                        SetIDToImportProject(csEvent);
                    }

                    bRtn = this.PutEvent(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.NOTICE_DB_OK ||
                     lEventNo == HySEventObject.NOTICE_DB_NG)
            {
                // DB種別情報の取得
                //HySID csDBID = csHySEvent.GetSubData() as HySID;
                HySID csDBID = csHySEvent.GetSuppID();
                // 演算ロット情報登録の報告ならばここで処理する
                if ((HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO.Equals(csDBID)) && 
                    (lSubEventNo == HySLibraryMngDefine.DB_REGISTER_DATA_NEW))
                {
                    bRtn = this.NoticeRegistCalcLotInfo(csHySEvent);
                }

                if (lSubEventNo == McDefine.QUERY_LIBRARY_LIST)
                {
                    // メイン画面起動完了報告
                    bRtn = this.NoticeMainViewrRunComplete(csHySEvent);
                }
                else if (IsNoticeRegisterProject(csHySEvent))
                {
                    // プロジェクトデータ登録報告
                    bRtn = NoticeRegisterProject(csHySEvent);
                }
                else
                {
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先をビューア管理に変更
                    bRtn = this.PutEvent(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.CMND_DISPLY_COMMON)
            {
                if (lSubEventNo == McDefine.HYM_ACTIVE_PROJECT_NAME_SETUP_INFORMATION ||
                    lSubEventNo == McDefine.HYMCO_FILE_NEW ||
                    lSubEventNo == McDefine.HYMCO_PROJECT_NEW ||    // Ver1.1 追加
                    lSubEventNo == McDefine.HYMCO_MODEL_LOAD_PROJECT)
                {
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                    bRtn = this.PutEvent(csEvent);
                }
                else if (lSubEventNo == McDefine.HYM_APPEND_PROJECTINF_END)
                {
                    // プロジェクト情報作成完了を受けて、モデル管理画面表示要求を行う。
                    HySID csDataID = ((HySEventObject)csEvent).GetSuppID();
                    bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, 0, csDataID, McDefine.HYM_MODELCTL_SCREEN);
                }
                else if (lSubEventNo == McDefine.HYMCO_FILE_CLOSE)
                {
                    // シミュレータ破棄指示
                    bRtn = PutEvent(csEvent, HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_SIMULATOR_DELETE, 0, csHySEvent.GetSuppID());
                }
                else if (lSubEventNo == McDefine.HYM_ELEMENT_MODEL_SET ||
                        lSubEventNo == McDefine.HYM_INPUT_DATA_SET ||
                        lSubEventNo == McDefine.HYM_OUTPUT_DATA_SET ||
                        lSubEventNo == McDefine.HYM_TRANSMISSION_INFORMATION_TYPE_SET ||
                        lSubEventNo == McDefine.HYM_LIBRARY_DATA_CANCEL)
                {   // ライブラリ設定：演算要素、入力方式、出力方式、伝送情報型
                    // ライブラリ解除
                    bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON, lSubEventNo,
                        csHySEvent.GetSuppID(), csHySEvent.GetData());
                }
                else if (lSubEventNo == McDefine.HYM_INCORPORATE_PROJECT)
                {
                    // プロジェクト取り込み
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                    bRtn = this.PutEvent(csEvent);
                }
            }
            else if (lEventNo == HySEventObject.ARBITRARY_EVENT)
            {
                // モデル管理画面が表示され、データコンテナの設定完了が報告された時
                if (lSubEventNo == McDefine.HYM_NOTICE_DATACONTAINER_SET)
                {
                    HySString csPrcID = (HySString)((HySEventObject)csEvent).GetSuppID().GetString();
                    HySString csPrcKind = (HySString)((HySEventObject)csEvent).GetToSimKind().GetString();
                    HySString csPrcKey = csPrcKind + csPrcID;
                    HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];
                    McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                    // プロジェクト（モデル管理画面）を開いた時、計算状態を確認して、
                    // 中断・計算完了・計算強制終了であれば、演算ログ表示を指示する
                    if (csSimuStatus.GetCalcStatus() == McSimulationStatus.CalculationStatus.INTERRUPTED ||
                        csSimuStatus.GetCalcStatus() == McSimulationStatus.CalculationStatus.FINISHED ||
                        csSimuStatus.GetCalcStatus() == McSimulationStatus.CalculationStatus.FINISHED_STOP)
                    {
                        bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT, McDefine.HYM_MODELLOG_DISP_REQUEST, ((HySEventObject)csEvent).GetSuppID());
                    }
                }
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_BROADCAST_SCREEN)
            {   // 全画面への通知
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_DISP_SCREEN)
            {   // 画面表示指示

                if (lSubEventNo == HySGISDefine.GIS_COTS_WAKEUP)
                {// GIS起動
                    // 画面制御へ
                    ((HySEventObject)csEvent).SetToSimKind(HySDefine.COMMON_DISP_BUSIPROCEDURE);
                }
                else
                {
                    HySObjectKind csScreenKind = ((HySEventObject)csEvent).GetData() as HySObjectKind;
                    if (HySDefine.SIMULATION_DATA_GENERATOR.Equals(csScreenKind) == true)
                    {   // モデルジェネレーター表示
                        McMdlDtGenScreenReqInfo csReqInf = new McMdlDtGenScreenReqInfo();
                        csReqInf.SetModelGeneratorList(this.m_csModelGenerator.GetModelNetworkGeneratorList());
                        csReqInf.SetModelGeneratorScreenList(this.m_csModelGenerator.GetModelGeneratorScreenList());
                        ((HySEventObject)csEvent).SetSubData(csReqInf);
                    }
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                }
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_RESTORE_NG)
            {   
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                ((HySEventObject)csEvent).SetEventNo(HySEventObject.CMND_DISPLY_MESSAGE);
                if (((HySEventObject)csEvent).GetData() != null)
                {
                    // 開く対象のシミュレータがすでに存在する場合
                    ((HySEventObject)csEvent).SetSubEventNo(McDefine.HYM_PROJECT_OPEN_NG);
                }
                else
                {
                    // 復元異常の場合
                    ((HySEventObject)csEvent).SetSubEventNo(McDefine.HYMCO_FILE_OPEN);
                }
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.NOTICE_SIMULATOR_CREATE_FAIL)
            {
                // シミュレータの生成が失敗したとき
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                ((HySEventObject)csEvent).SetEventNo(HySEventObject.CMND_DISPLY_MESSAGE);
                ((HySEventObject)csEvent).SetSubEventNo(McDefine.HYM_SIMU_CREATE_NG);
                bRtn = this.PutEvent(csEvent);
            }
            else if (lEventNo == HySEventObject.CMND_SHUTDOWN_SYSTEM)
            {
            }
            else if (lEventNo == HySEventObject.CMND_EXIT_SYSTEM)
            {
            }
            else if (lEventNo == HySEventObject.CMND_GIS_COMMON)
            {   // GIS 関連オブジェクト
                if (lSubEventNo == HySGISDefine.GET_GIS_INFO)
                {
                    if (csEvent.From() != HySSysEvent.OBJID_GISCONTROLLER)
                    {   // GIS 側からの応答でなければ
                        csEvent.SetTo(HySSysEvent.OBJID_GISCONTROLLER); // 宛先をＧＩＳに変更
                        csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                        ((HySEventObject)csEvent).SetFromSimKind(McDefine.SIMULATOR_KIND);
                        ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND); // 応答を返す業務を設定
                        bRtn = this.PutEvent(csEvent);
                    }
                    else
                    {   // GIS 側の応答ならば
                        // Do Nothing
                    }
                }
                else if (lSubEventNo == HySGISDefine.GET_GIS_INFO_OK || lSubEventNo == HySGISDefine.GET_GIS_INFO_NG)
                {
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                    csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                    ((HySEventObject)csEvent).SetFromSimKind(McDefine.SIMULATOR_KIND);
                    ((HySEventObject)csEvent).SetToSimKind(McDefine.SIMULATOR_KIND);
                    bRtn = this.PutEvent(csEvent);
                }
            }
// Ver1.1 追加 >>>
            // プロジェクト保存
            else if (lEventNo == HySEventObject.CMND_PROJECT_SAVE_ACT)
            {
                bRtn = this.CheckProjectFile(csHySEvent);
            }
            else if (lEventNo == HySEventObject.CMND_PROJECT_SAVE)
            {
                bRtn = this.SaveProjectFile(csHySEvent);
            }
// Ver1.1 追加 <<<
            else if (lEventNo == HySEventObject.CMND_CLOSE_SCREEN)
            {
                //lSubEventNo
                HySDataRoot csMainDt = csHySEvent.GetData();
                HySDataRoot csSubDt = csHySEvent.GetSubData();
                HySID csID = csHySEvent.GetSuppID();
                // Ver1.2 で此処で行う処理はなし
            }
            else
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.TRIAL_RUN, "McBusiProcedure::EventCallback", 
                    Properties.HymcoImplResources.STATEMENT_UNKNOWN_EVENT + "(" + lEventNo.ToString() + ")");
               // HySLog.LogOut(HySLog.TRIAL_RUN, "McBusiProcedure::EventCallback", "Unknown Event(" + lEventNo.ToString() + ")");
                bRtn = false;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>イベントを送る</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分からイベントを送信する時に使用する</para>
        /// </remarks>
        virtual public Boolean PutEvent(HySSysEvent csEvent)
        {
            String csMethod = "McBusiProcedure.PutEvent";
            Boolean bRtn = false;
            //((HySEventObject)csEvent).SetSimKind(McDefine.SIMULATOR_KIND);
            ((HySEventObject)csEvent).SetFromSimKind(this.GetSimKind());
            bRtn = m_csController.PutEvent(csEvent);
            if (!bRtn)
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, csMethod, Properties.HymcoImplResources.STATEMENT_SEND_FAILURE );
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "イベント送信失敗");
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>システム終了準備完了判別</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = ExitOK( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true : システムExit準備OK　、false : システムExit準備NG</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean ExitOK()
        {
            if (m_bWorkFlg == true)
            { return false; }
            else
            { return true; }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリー管理クラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetFactoryMng( csFactoryMng ) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリー管理クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetFactoryMng(HySFactoryMng csFactoryMng)
        {
            m_csSimFactory = csFactoryMng.GetFactory(McDefine.FACTORY_ID_SIMULATION) as McFigureUnityFactory;
            if( m_csSimFactory != null )
            {
                m_csModelGenerator = m_csSimFactory.CreateSimulationDataGenerator(this.GetSimKind(), McDefine.FACTORY_ID_SIMULATION) as McModelGeneratorController;
                m_csModelGenerator.SetBusiProcedure(this);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>メイン画面起動完了報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeMainViewrRunComplete( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeMainViewrRunComplete(HySEventObject csEvent)
        {
            // プロジェクト管理画面表示要求を行う。
            HySString csKind = new HySString("");
            HySString csGroup = new HySString("");
            HySString csKey = new HySString(McDefine.PROJECTSCREEN_ID);
            //HySID csID = new HySID(csKind, csGroup, csKey);
            HySID csID = new HySID(csKind + csGroup + csKey);
            if (!PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, 0, csID, McDefine.HYM_PROJECTCTL_SCREEN))
            {
                return false;
            }

            // ライブラリ管理画面の表示要求を行う。
            csKey = new HySString(McDefine.LIBRARYSCREEN_ID);
            //csID = new HySID(csKind, csGroup, csKey);
            csID = new HySID(csKind + csGroup + csKey);
            if (!PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISP_SCREEN, 0, csID, McDefine.HYM_LIBRARYCTL_SCREEN,
                csEvent.GetSubData()))
            {
                return false;
            }

            try
            {
                string sHistoryFolderPath = HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf(new HySString("MCMODEL_HISTORY_FOLDER")).ToString();
                HySFile csFile = new HySFile(sHistoryFolderPath);
                csFile.AllFileDelleteInDirectory(new HySString("*.rpstdat"));
                csFile.AllFileDelleteInDirectory(new HySString("*.rpsidat"));
            }
            catch
            {
                return false;
            }
            // モデル管理画面の初期表示
            if (!this.CmndMakeNewSimulator(csEvent))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McBusiProcedure", "Create", 
                    Properties.HymcoImplResources.STATEMENT_INIT_DISP_MSG );
               // HySLog.LogOut(HySLog.ONLINE, "McBusiProcedure", "Create", "PutEvent CMND_NEW_SIMULATOR_CREATE is failed.");
                return false;
            }
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ検索要求</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeQueryLibraryReqest( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeQueryLibraryReqest(HySEventObject csEvent)
        {
            csEvent.SetToSimKind(m_csSimKindID);
            return PutEvent(csEvent, HySSysEvent.OBJID_LIBMANAGER, HySEventObject.CMND_DB_QUERY, McDefine.QUERY_LIBRARY_LIST, csEvent.GetSuppID());
        }

        /// <summary><para>method outline:</para>
        /// <para>スクリーン表示報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeScreenDisp( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeScreenDisp(HySEventObject csEvent)
        {
            Boolean bRtn = false;
            long lEventNo = csEvent.GetEventNo();
            long lSubEventNo = csEvent.GetSubEventNo();
            HySID csDataID = csEvent.GetSuppID();
            HySObjectKind csScreenKind = csEvent.GetData() as HySObjectKind;
            HySObjectKind csSimKind = (HySObjectKind)csEvent.GetToSimKind();
            if (McDefine.HYM_MODELCTL_SCREEN.Equals(csScreenKind) == true)
            {
                // モデル管理画面表示完了を受けて、データコンテナ（要素間接続情報、チェック情報）の設定を行う。
                HySString csPrcID = (HySString)csDataID.GetString();
                HySString csPrcKind = (HySString)csSimKind.GetString();
                HySString csPrcKey = csPrcKind + csPrcID;
                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];

                // 要素間接続情報、チェック情報が必要なのでデータコンテナを渡す
                bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.ARBITRARY_EVENT, McDefine.HYM_DATACONTAINER_SEND, csDataID, csContainer);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレータ復元完了報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeEndSimulatorRestore( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeEndSimulatorRestore(HySEventObject csEvent)
        {
            // データコンテナ管理テーブルに追加
            HySSimulationDataContainer csDataCnt = (HySSimulationDataContainer)csEvent.GetData();
            AddToDataContainerTbl(csDataCnt);

            // ファイルパス管理テーブルに追加
            HySID csPrjID = (HySID)csDataCnt.GetID();
            HySString csFilepath = (HySString)csEvent.GetSubData();
            m_csFilePathTbl.AddObject((HySString)csPrjID.GetString(), csFilepath);

            // ビューアに画面管理一般指示（ブロードキャスト）-プロジェクト情報追加を送信
            return PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_BROADCAST_SCREEN, McDefine.HYM_APPEND_PROJECTINF, csPrjID, csDataCnt);
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレータ保存完了報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeEndSimulatorSave( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeEndSimulatorSave(HySEventObject csEvent)
        {
            long lEventNo = csEvent.GetEventNo();
            long lSubEventNo = csEvent.GetSubEventNo();

            if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE)
            {
                // 正常終了した場合
                //名前をつけて保存の場合
                if (lSubEventNo == McDefine.HYMCO_FILE_SAVE_NEW)
                {
                    // ファイルパス管理テーブルに追加
                    HySID csPrjID = csEvent.GetSuppID();
                    HySString csFilepath = (HySString)csEvent.GetData();
                    m_csFilePathTbl.AddObject((HySString)csPrjID.GetString(), csFilepath);
                }
                HySString csPrcID = (HySString)csEvent.GetSuppID().GetString();
                HySString csPrcKind = (HySString)csEvent.GetToSimKind().GetString();
                HySString csPrcKey = csPrcKind + csPrcID;
                //UpdateSimulationStatus(csPrcKey, csEvent.GetEventNo());
                UpdateSimulationStatus(csPrcKey, csEvent);
            }

            csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先をビューアに変更
            return this.PutEvent(csEvent);
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター破棄完了報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeEndSimulatorDelete( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeEndSimulatorDelete(HySEventObject csEvent)
        {
            // イベントからプロジェクトID取得
            HySID csPrjID = csEvent.GetSuppID();
            HySKind csSimKind = csEvent.GetToSimKind();

            // データコンテナ管理テーブルから削除
            DeleteFromDataContainerTbl(csSimKind, csPrjID);

            // ファイルパス管理テーブルからデータ削除
            m_csFilePathTbl.DeleteData((HySString)csPrjID.GetString());

            // ビューアに画面管理一般指示-モデル管理画面閉じるを送信
            //return PutEvent(HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON2, McDefine.HYM_MODEL_SCREEN_CLOSE, csEvent.GetSuppID());
            return PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON, McDefine.HYM_MODEL_SCREEN_CLOSE, csEvent.GetSuppID());
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレータ保存指示受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndSimulatorSave( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean CmndSimulatorSave(HySEventObject csEvent)
        {
            Boolean bRtn = false;
            long lSubEventNo = csEvent.GetSubEventNo();
            HySString csPrcID = (HySString)((HySEventObject)csEvent).GetSuppID().GetString();
            HySString csPrcKind = (HySString)((HySEventObject)csEvent).GetToSimKind().GetString();
            HySString csPrcKey = csPrcKind + csPrcID;

            if (lSubEventNo == McDefine.HYMCO_FILE_SAVE)
            {
                HySString csPath = (HySString)m_csFilePathTbl[(HySString)csEvent.GetSuppID().GetString()];
                if ((object)csPath == null)
                {
                    // 上書き保存用のファイルが無い場合はその旨画面に報告する
                    bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.NOTICE_SIMULATION_NG, McDefine.HYMCO_FILE_SAVE,
                        null, McDefine.ERR_SAVE_NO_FILE_PATH, csEvent.GetSubData());
                }
                else
                {
                    //// データコンテナの取り出し
                    //HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];
                    //McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                    //// モデル保存状態を保存済に設定
                    //csSimuStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);

                    csEvent.SetData(csPath);
                    csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR);
                    bRtn = this.PutEvent(csEvent);
                }
            }
            else if (lSubEventNo == McDefine.HYMCO_FILE_SAVE_NEW)
            {
                //// データコンテナの取り出し
                //HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];
                //McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                //// モデル保存状態を保存済に設定
                //csSimuStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);

                csEvent.SetTo(HySSysEvent.OBJID_SIMULATOR);
                bRtn = this.PutEvent(csEvent);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレータ新規作成指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CmndMakeNewSimulator( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean CmndMakeNewSimulator(HySEventObject csEvent)
        {
            // シミュレーター（演算単位系）新規作成要求（新規プロジェクト作成）
            // シミュレーター（演算系単位系）のデータ識別子をユニーク付番する必要あり。
            Boolean bRtn = false;
            if (csEvent.GetData() != null)
            {
                // 付属データ(データコンテナ)がある場合は、このデータコンテナでシミュレータを作成する
                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)csEvent.GetData();
                HySID csID = (HySID)csContainer.GetID();
                bRtn = PutEvent(csEvent, HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE, 0, csID, csContainer);
            }
            else
            {
                // 付属データ(データコンテナ)が無い場合は、シミュレータ作成時にデータコンテナを作成する
                HySID csID = CreateID();
                bRtn = PutEvent(csEvent, HySSysEvent.OBJID_SIMULATOR, HySEventObject.CMND_NEW_SIMULATOR_CREATE,
                    McDefine.HYM_CREATE_NEW_DATACONTAINER, csID);

/*// ★★★
                if (csEvent.GetSubEventNo() == McDefine.HYMCO_FILE_NEW)
                {   // ＤＢベースの新規作成ならば
                    // Do Nothing
                }
                else if (csEvent.GetSubEventNo() == McDefine.HYMCO_PROJECT_NEW)
                {   // ファイルベースの新規作成ならば
                    // フォルダー等を作成する
                }
                else
                {
                }
// ★★★*/
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレータ新規作成終了報告受付</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeSimulatorMakeEnd( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected Boolean NoticeSimulatorMakeEnd(HySEventObject csEvent)
        {
            // シミュレーター（演算単位系）新規作成完了を受けて、プロジェクト情報設定要求を行う。
            HySID csDataID = csEvent.GetSuppID();
            HySObjectKind csSimKind = (HySObjectKind)csEvent.GetToSimKind();

            // データコンテナ管理テーブルに追加
            HySSimulationDataContainer csDataContainer = (HySSimulationDataContainer)csEvent.GetData();
            AddToDataContainerTbl(csDataContainer);

            // サブイベント番号のみ替えてイベントを送る
            Boolean bRtn = false;
            if (csEvent.GetSubEventNo() == McDefine.HYM_CREATE_NEW_DATACONTAINER)
            {
                bRtn = PutEvent(csEvent,HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_BROADCAST_SCREEN,
                      McDefine.HYM_APPEND_EMPTY_PROJECTINF, csDataID, csDataContainer);
            }
            else
            {
                // プロジェクト検索時のモデル保存状態を保存済に設定
                McSimulationStatus csStatus = (McSimulationStatus)csDataContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                csStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);

                bRtn = PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_BROADCAST_SCREEN,
                      McDefine.HYM_APPEND_PROJECTINF, csDataID, csDataContainer);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算状態ステータス更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> UpdateSimulationStatus(csPrcKey,lEventNo)</para>
        /// </example>
        /// <param name="csPrcKey">ユニークキー</param>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        //protected void UpdateSimulationStatus(HySString csPrcKey, long lEventNo)
        virtual protected void UpdateSimulationStatus(HySString csPrcKey, HySSysEvent csEvent)
        {
            long lEventNo = ((HySEventObject)csEvent).GetEventNo();
            long lSubEvent = ((HySEventObject)csEvent).GetSubEventNo();
            // 計算状態ステータス更新
            // データコンテナの取り出し
            HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];
            McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            // 計算開始
            if (lEventNo == HySEventObject.NOTICE_START_SIMULATION)
            {
                // 計算中に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.CALCULATING);
            }
            // 計算中断
            else if (lEventNo == HySEventObject.NOTICE_PAUSE_SIMULATION)
            {
                // 中断に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INTERRUPTED);
            }
            // 強制終了
            else if (lEventNo == HySEventObject.NOTICE_STOP_SIMULATION)
            {
                // 強制終了に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.FINISHED_STOP);
            }
            // 計算完了
            else if (lEventNo == HySEventObject.NOTICE_COMPLETE_SIMULATION)
            {
                // 計算終了に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.FINISHED);
            }
            // 計算異常終了
            else if (lEventNo == HySEventObject.NOTICE_SIMULATION_ABEND)
            {
                // 強制終了に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.FINISHED_STOP);
            }
            // 初期化
            else if (lEventNo == HySEventObject.NOTICE_INITIALIZE_SIMULATION)
            {
                if (lSubEvent == McDefine.HYM_NG_SUBEVENT)
                {   // 初期化失敗時には
                    // ステータスを変更してはならない
                }
                else
                {
                    csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);
                }
                // 未計算に設定
            }
            // モデル構築完了
            else if (lEventNo == HySEventObject.NOTICE_OK_MODEL_CONSTRUCTION)
            {
                // 構築済に設定
                csSimuStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.CONSTRUCTED);
                // 未計算に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);
            }
            // モデル構築失敗
            else if (lEventNo == HySEventObject.NOTICE_NG_MODEL_CONSTRUCTION)
            {
                // 未構築に設定
                csSimuStatus.SetModelConStatus(McSimulationStatus.ModelConstructionStatus.NOT_CONSTRUCTED);
                // 未計算に設定
                csSimuStatus.SetCalcStatus(McSimulationStatus.CalculationStatus.INITIAL);
            }
            // シミュレータ保存通知
            else if (lEventNo == HySEventObject.NOTICE_END_SIMULATOR_SAVE)
            {
                // 保存済に設定
                csSimuStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.SAVED);
            }
            // 上記以外は更新無し
            else
            {
                return;
            }

            // モデル管理画面ヒストリー更新要求
            if (false == PutEvent(csEvent, HySSysEvent.OBJID_VIEWER, HySEventObject.CMND_DISPLY_COMMON,
                                McDefine.HYM_HISTORY_FILE_UPDATE_REQUEST, (HySID)csContainer.GetID()))
            {
               // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, "McBusiProcedure::UpdateSimulationStatus", 
                    Properties.HymcoImplResources.STATEMENT_HIS_UPDATE_NG );
               // HySLog.LogOut(HySLog.ONLINE, "McBusiProcedure::UpdateSimulationStatus", "モデル管理画面ヒストリー更新失敗");
            }

        }

        /// <summary><para>method outline:</para>
        /// <para>ID作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = CreateID()</para>
        /// </example>
        /// <returns>ユニークID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected HySID CreateID()
        {
            HySString csKind = new HySString(McDefine.FIGUREUNITY_COMMON_ID);
            HySString csGroup = new HySString(DateTime.Now.Minute.ToString() + DateTime.Now.Hour.ToString() + DateTime.Now.Second.ToString() + "-");
            HySString csKey = new HySString((m_ulSimCounter++).ToString() +
                 ((DateTime.Now.ToString() + DateTime.Now.Millisecond.ToString()).GetHashCode()).ToString());
            //return new HySID(csKind, csGroup, csKey);
            return new HySID(csKind+ csGroup+ csKey);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent(lTo, lNo, lSubNo, csID)</para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
         /// <param name="lTo">送信先</param>
       /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean PutEvent(HySSysEvent csEvent, long lTo, long lNo, long lSubNo, HySID csID)
        {
            return PutEvent(csEvent, lTo, lNo, lSubNo, csID, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent(lTo, lNo, lSubNo, csID, csData)</para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <param name="lTo">送信先</param>
        /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <param name="csData">付属データ1</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean PutEvent(HySSysEvent csEvent, long lTo, long lNo, long lSubNo, HySID csID, HySDataRoot csData)
        {
            return PutEvent(csEvent, lTo, lNo, lSubNo, csID, csData, null);
        }

        /// <summary><para>method outline:</para>
        /// <para>イベント送信</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = PutEvent(lTo, lNo, lSubNo, csID, csData, csData2)</para>
        /// </example>
        /// <param name="csEvent">送るイベント</param>
        /// <param name="lTo">送信先</param>
        /// <param name="lNo">イベント番号</param>
        /// <param name="lSubNo">サブイベント番号</param>
        /// <param name="csID">付属識別子</param>
        /// <param name="csData">付属データ1</param>
        /// <param name="csData2">付属データ2</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Boolean PutEvent(HySSysEvent csEvent, long lTo, long lNo, long lSubNo, HySID csID, HySDataRoot csData, HySDataRoot csData2)
        {
            HySEventObject csEventObj = new HySEventObject(lTo, lNo);
            csEventObj.SetSubEventNo(lSubNo);
            csEventObj.SetSuppID(csID);
            csEventObj.SetData(csData);
            csEventObj.SetSubData(csData2);
            csEventObj.SetToSimKind(((HySEventObject)csEvent).GetToSimKind());
            // シミュレータ種別は下記PutEvent()メソッドで設定される
            return PutEvent(csEventObj);
        }

        /// <summary><para>method outline:</para>
        /// <para>データコンテナ管理テーブルへ追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddToDataContainerTbl(csDataContainer)</para>
        /// </example>
        /// <param name="csDataContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual protected void AddToDataContainerTbl(HySSimulationDataContainer csDataContainer)
        {
            HySID csDataID = (HySID)csDataContainer.GetID();
            HySKind csSimKind = csDataContainer.GetSimKind();
            HySString csPrcID = (HySString)csDataID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            m_csDataContainerTbl.AddObject(csPrcKey, csDataContainer);
        }

        /// <summary><para>method outline:</para>
        /// <para>データコンテナ管理テーブルから削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> DeleteFromDataContainerTbl(csSimKind, csPrjID)</para>
        /// </example>
        /// <param name="csSimKind">シミュレータ種別</param>
        /// <param name="csPrjID">プロジェクトID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DeleteFromDataContainerTbl(HySKind csSimKind, HySID csPrjID)
        {
            HySString csPrcID = (HySString)csPrjID.GetString();
            HySString csPrcKind = (HySString)csSimKind.GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            m_csDataContainerTbl.DeleteData(csPrcKey);
            GC.Collect(); // 強制　ガベージコレクション
        }

        /// <summary><para>method outline:</para>
        /// <para>インポートプロジェクトID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetIDToImportProject(csSimKind, csPrjID)</para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// イベントオブジェクト内部の付属データに格納されている各データコンテナのIDを再設定する。
        /// このメソッドはプロジェクトのインポートの際にコールされる。
        /// </para>
        /// </remarks>
//        private void SetIDToImportProject(HySSysEvent csEvent)
        protected void SetIDToImportProject(HySSysEvent csEvent)
        {
            HySEventObject csEventObj = (HySEventObject)csEvent;
            HySDataLinkedList csContainerList = (HySDataLinkedList)csEventObj.GetData();

            csContainerList.SetCursorFirst();
            // リスト内部の全てのデータコンテナにIDを振りなおす
            for (int i = 0; i < csContainerList.GetCount(); i++)
            {
                HySSimulationDataContainer csDataCont = (HySSimulationDataContainer)csContainerList.GetCursorData();
                SetNewID(csDataCont);
                csContainerList.MoveCursorNext();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>新規ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNewID(csDataCont)</para>
        /// </example>
        /// <param name="csContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定されたプロジェクトデータ格納コンテナのIDを振りなおす</para>
        /// </remarks>
        private void SetNewID(HySSimulationDataContainer csContainer)
        {
            // 新規IDを作成
            HySID csID = CreateID();

            // データコンテナ及び内部データにIDを設定する
            csContainer.SetID(csID);
            McProjectInfData csPrjInfData = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            csPrjInfData.SetProjectID(csID);
            McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
            csStructInfo.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = SetCalcLotInfo( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>イベントにて指定されたプロジェクトのロットIDを新規に設定し、DBに登録する</para>
        /// </remarks>
        virtual protected Boolean SetCalcLotInfo(HySSysEvent csEvent)
        {
            bool bRtn = true;
            String csMethod = "McBusiProcedure.SetCalcLotInfo";
            
            // イベント情報より設定するコンテナを設定
            HySString csPrcID = (HySString)((HySEventObject)csEvent).GetSuppID().GetString();
            HySString csPrcKind = (HySString)((HySEventObject)csEvent).GetToSimKind().GetString();
            HySString csPrcKey = csPrcKind + csPrcID;
            HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];

            McSimulationStatus csSimuStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
            if (McSimulationStatus.CalculationStatus.INITIAL == csSimuStatus.GetCalcStatus())
            {

                // 演算ロット情報の生成
                HySCalcLotInfo csCalcLotInf = new HySCalcLotInfo(csContainer.GetSimKind(), csContainer.GetID());
                csCalcLotInf.SetRCalcExecDate(HySCalendar.CreateNowTime());

                // コンテナに設定
                csContainer.SetData(HySCalcLotInfo.DATA_KEY_CALC_LOT, csCalcLotInf);

                // DBに登録する
                HySStockData csStockData = new HySStockData(csCalcLotInf.GetSimKind(), csCalcLotInf.GetSimID());
                csStockData.SetPeservedPeriod(HySStockData.PeservedPeriod.Temporary);
                csStockData.SetData(csCalcLotInf);
                HySEventObject csEventObj = new HySEventObject(HySEventObject.OBJID_LIBMANAGER, HySEventObject.CMND_DB_REGISTER);
                csEventObj.SetSubEventNo(HySLibraryMngDefine.DB_REGISTER_DATA_NEW);
                csEventObj.SetToSimKind(HySDefine.SIMULATOR_KIND);
                csEventObj.SetData(csStockData);
                csEventObj.SetSuppID(HySLibraryMngDefine.DB_KIND_CALC_LOT_INFO);
                csEventObj.SetResponseInfo((HySID)csContainer.GetID());
                bRtn = PutEvent(csEventObj);
                if (!bRtn)
                {
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, csMethod, 
                        Properties.HymcoImplResources.STATEMENT_CALC_REGIST_NG );
                   // HySLog.LogOut(HySLog.ONLINE, csMethod, "演算ロット情報の登録に失敗しました。");
                }
            }
            else
            {
                bRtn = false;
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算ロット情報登録報告後処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = NoticeRegistCalcLotInfo( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 演算ロット情報登録の報告を受けて正常ならばシミュレーション開始イベントを送信する。
        /// 異常ならば画面にエラー通知を行う。
        /// </para>
        /// </remarks>
        virtual protected Boolean NoticeRegistCalcLotInfo(HySEventObject csEvent)
        {
            HySID csID = csEvent.GetResponseInfo();
            HySEventObject csRtnEvent = null;
            if (csEvent.GetEventNo() == HySEventObject.NOTICE_DB_OK)
            {
                // 対応するデータコンテナの取得
                HySString csPrcKey = (HySString)GetSimKind().GetString() + (HySString)csID.GetString();
                HySSimulationDataContainer csContainer = (HySSimulationDataContainer)m_csDataContainerTbl[csPrcKey];

                // 時刻設定の更新処理
                SetContainerTimeParameter(csContainer, false);

                // モデル保存状態の変更
                McSimulationStatus csSimulationStatus = (McSimulationStatus)csContainer.GetData(McDefine.HYM_DATA_SIMULATION_INFO);
                csSimulationStatus.SetModelSaveStatus(McSimulationStatus.ModelSaveStatus.UNSAVED);

                csRtnEvent = new HySEventObject(HySEventObject.OBJID_SIMULATOR, HySEventObject.CMND_START_SIMULATION);

                //★サーバー／クライアント化で追加
                csRtnEvent.SetData(csContainer);
                //★サーバー／クライアント化で追加 

            }
            else
            {
                // 画面にエラー送信
                csRtnEvent = new HySEventObject(HySEventObject.OBJID_VIEWER, HySEventObject.NOTICE_CANNOT_START_SIMULATION);
            }

            csRtnEvent.SetToSimKind(GetSimKind());
            csRtnEvent.SetSuppID(csID);
            return PutEvent(csRtnEvent);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンテナ時刻パラメタ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetContainerTimeParameter( csContainer, bReStart ) </para>
        /// </example>
        /// <param name="csContainer">シミュレーションコンテナ</param>
        /// <param name="bReStart">演算再開フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンテナの時刻パラメタを設定する。</para>
        /// </remarks>
        virtual protected void SetContainerTimeParameter(HySSimulationDataContainer csContainer, bool bReStart)
        {
            McProjectInfData csProjectInf = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
            McStructInfo csStructInfo = (McStructInfo)csContainer.GetData(McDefine.HYM_DATA_STRUCT_INFO);
            McFigUnityPropertyInfo csFigUPrpty = csStructInfo.GetModelInfo().GetPropertyInfo() as McFigUnityPropertyInfo;

            // 再開でない場合はは開始時刻、演算時刻を設定
            if (!bReStart)
            {
                csContainer.SetStartTime(csProjectInf.GetStartSimuTime());
                csContainer.SetSimuTime(csContainer.GetStartTime());
            }

            // 目標時刻の設定･･･中断時刻ありの場合は中断時刻、そうでない場合は終了時刻を設定
            if (csProjectInf.GetSuspendTime() != null)
            {
                csContainer.SetGoalTime(csProjectInf.GetSuspendTime());
            }
            else
            {
                csContainer.SetGoalTime(csProjectInf.GetEndSimuTime());
            }
            if (csFigUPrpty.GetDataFusionTiming() == McDefine.DataFusionTiming.SYNCHRONOUS)
                // 同期演算の場合は、演算系のタイムステップは推奨値を設定する。
            {
                csFigUPrpty.SetTimeStep(csStructInfo.RecommendDeltaTime());
            }
            // タイムステップの設定
            csContainer.SetDeltaTime(csFigUPrpty.GetTimeStep());
        }



        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RegisterProject( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクトの登録処理を行う。</para>
        /// </remarks>
        private bool RegisterProject(HySEventObject csEvent)
        {
            String csMethod = "McBusiProcedure.RegisterProject";
            bool bRtn = true;
            long lSubEventNo = csEvent.GetSubEventNo();

            //データコンテナを取り出す
            HySSimulationDataContainer csContainer = GetDataContainer(csEvent);
            if (csContainer != null)
            {
                HySID csOrigID = (HySID)csContainer.GetID();
                // 登録用複製データ作成
                //csContainer = csContainer.Clone();
                csContainer = csContainer.DuplicateData();
                // コピー登録時
                if (lSubEventNo == McDefine.HYM_LIBRARY_COPY_REGISTER)
                {
                    // プロジェクト情報の差し替え
                    McProjectInfData csPrjInfData = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    McProjectInfData csUpdatePrjData = (McProjectInfData)((HySEventObject)csEvent).GetData();
                    UpdateProjectInf(csPrjInfData, csUpdatePrjData);

                    // 新規IDを設定
                    SetNewID(csContainer);
                    m_csProjectIDTbl.AddObject((HySString)csContainer.GetID().GetString(), csOrigID);
                    csEvent.SetResponseInfo((HySID)csContainer.GetID());
                    csEvent.SetSubEventNo(HySLibraryMngDefine.DB_REGISTER_DATA_NEW);
                }
                else
                {
                    csEvent.SetSubEventNo(HySLibraryMngDefine.DB_REGISTER_DATA_UPDATE_OR_NEW);
                }
                // シミュレーション計算ステータスを初期化
                csContainer.SetData(McDefine.HYM_DATA_SIMULATION_INFO, new McSimulationStatus());
                HySStockData csStockData = new HySStockData((HySObjectKind)csContainer.GetSimKind(), (HySID)csContainer.GetID());
                csStockData.SetData(csContainer);
                csEvent.SetData(csStockData);
                csEvent.SetTo(HySSysEvent.OBJID_LIBMANAGER); // 宛先をライブラリ管理に変更
                csEvent.SetSuppID(HySLibraryMngDefine.DB_KIND_PROJECT_DATA);
                bRtn = this.PutEvent(csEvent);
            }
            else
            {
               // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.HymcoImplResources.STATEMENT_NOT_PROJECT + Properties.HymcoImplResources.STATEMENT_SIMU_TYPE
                    + csEvent.GetToSimKind().ToString() + Properties.HymcoImplResources.STATEMENT_PROJ_ID + csEvent.GetSuppID().ToString();
                HySLog.LogOut(HySLog.ONLINE, csMethod, DispStatement );
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "対応プロジェクトデータが存在しない: " + "シミュレータ種別: " +
               //     csEvent.GetToSimKind().ToString() + " プロジェクトID: " + csEvent.GetSuppID().ToString());
                bRtn = false;
            }

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト情報の更新</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> UpdateProjectInf( csDst, csSrc ) </para>
        /// </example>
        /// <param name="csDst">更新先のプロジェクト情報</param>
        /// <param name="csSrc">更新元のプロジェクト情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>更新元プロジェクト情報の属性を更新先プロジェクト情報に複写する。</para>
        /// </remarks>
        private void UpdateProjectInf(McProjectInfData csDst, McProjectInfData csSrc)
        {
            csDst.SetProjectGroupName(csSrc.GetProjectGroupName());  // プロジェクトグループ名 Ver1.1 追加
            csDst.SetProjectName(csSrc.GetProjectName());  // プロジェクト名
            csDst.SetAdminName(csSrc.GetAdminName());      // 管理者名
            csDst.SetModelType(csSrc.GetModelType());       // 種別
            csDst.SetModelTarget(csSrc.GetModelTarget());  // 対象
            csDst.SetModelCalcType(csSrc.GetModelCalcType());     // モデル
            csDst.SetModelSubject(csSrc.GetModelSubject());       // 件名
            csDst.SetModelSituation(csSrc.GetModelSituation());   // ケース名
            csDst.SetModelPeriodType(csSrc.GetModelPeriodType()); // 期間種別
            csDst.SetModelPeriod(csSrc.GetModelPeriod());         // 期間
            csDst.SetThresholdCondition1(csSrc.GetThresholdCondition1());  // 境界条件１
            csDst.SetThresholdCondition2(csSrc.GetThresholdCondition2());  // 境界条件２
            csDst.SetThresholdCondition3(csSrc.GetThresholdCondition3());  // 境界条件３
            csDst.SetThresholdCondition4(csSrc.GetThresholdCondition4());  // 境界条件４
            csDst.SetThresholdCondition5(csSrc.GetThresholdCondition5());  // 境界条件５
            csDst.SetCondition1(csSrc.GetCondition1());    // 条件１
            csDst.SetCondition2(csSrc.GetCondition2());    // 条件２
            csDst.SetCondition3(csSrc.GetCondition3());    // 条件３
            csDst.SetCondition4(csSrc.GetCondition4());    // 条件４
            csDst.SetCondition5(csSrc.GetCondition5());    // 条件５
            csDst.SetCreateDate(csSrc.GetCreateDate());    // 作成日
            csDst.SetComment(csSrc.GetComment());          // 備考

            // 登録日、更新日のリセット
            csDst.SetRegistDate(null);
            csDst.SetUpdateDate(null);
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録応答判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IsNoticeRegisterProject( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">ライブラリ管理から送られたDB通知イベント</param>
        /// <returns>true:=プロジェクト登録に対する応答, false:=それ以外</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信したDB応答イベントが、プロジェクト登録に対する応答か否かを調べる。</para>
        /// </remarks>
        private bool IsNoticeRegisterProject(HySEventObject csEvent)
        {
            long lSubEventNo = csEvent.GetSubEventNo();
            return ((HySID)csEvent.GetSuppID() == HySLibraryMngDefine.DB_KIND_PROJECT_DATA) &&
                    ((lSubEventNo == HySLibraryMngDefine.DB_REGISTER_DATA_NEW) || (lSubEventNo == HySLibraryMngDefine.DB_REGISTER_DATA_UPDATE_OR_NEW));
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRegisterProject( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">ビューアに送信するイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ビューアにプロジェクト登録応答通知を送信する。</para>
        /// </remarks>
        private bool NoticeRegisterProject(HySEventObject csEvent)
        {
            string csMethod = "McBusiProcedure.NoticeRegisterProject";
            try
            {
                long lSubEventNo = csEvent.GetSubEventNo();
                if (lSubEventNo == HySLibraryMngDefine.DB_REGISTER_DATA_UPDATE_OR_NEW)
                {
                    // 登録
                    csEvent.SetSubEventNo(McDefine.HYM_DB_REGISTER);
                }
                else
                {
                    // コピー登録
                    HySID csNewProjectID = csEvent.GetResponseInfo();
                    HySID csProjectID = (HySID)m_csProjectIDTbl[(HySString)csNewProjectID.GetString()];
                    if (csProjectID == null)
                    {
                        // 異常
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, csMethod, 
                            Properties.HymcoImplResources.STATEMENT_NOT_PROJECT_ID + csNewProjectID.ToString());
                       // HySLog.LogOut(HySLog.ONLINE, csMethod, "対応プロジェクトデータIDが存在しない: " + csNewProjectID.ToString());
                        return false;
                    }
                    csEvent.SetSubEventNo(McDefine.HYM_LIBRARY_COPY_REGISTER);
                    csEvent.SetSuppID(csProjectID);
                }
                HySStockData csStockData = (HySStockData)csEvent.GetData();
                if (csStockData == null)
                {
                    // 異常
                   // ver1.5 エラートレース日本語対応
                    HySLog.LogOut(HySLog.ONLINE, csMethod, Properties.HymcoImplResources.STATEMENT_NOT_DATA_EVENT );
                   // HySLog.LogOut(HySLog.ONLINE, csMethod, "イベントにデータコンテナがセットされていない: ");
                    return false;
                }
                csEvent.SetData(csStockData.GetData());
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER);
                return PutEvent(csEvent);
            }
            finally
            {
                HySID csNewProjectID = csEvent.GetResponseInfo();
                if (csNewProjectID != null)
                {
                    m_csProjectIDTbl.DeleteData((HySString)csNewProjectID.GetString());
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>データコンテナ取得（イベントオブジェクト指定）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRegisterProject( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">イベントオブジェクト</param>
        /// <returns>データコンテナオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>イベントオブジェクトに含まれる情報をキーとして、データコンテナ管理テーブルからデータコンテナオブジェクトを取得する</para>
        /// </remarks>
        private HySSimulationDataContainer GetDataContainer(HySEventObject csEvent)
        {
            HySKind csSimKind = csEvent.GetToSimKind();
            HySID csID = csEvent.GetSuppID();
            return GetDataContainer(csSimKind, csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>データコンテナ取得（シミュレータ種別、データ識別子指定）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeRegisterProject( csEvent ) </para>
        /// </example>
        /// <param name="csSimKind">シミュレータ種別</param>
        /// <param name="csID">データ識別子</param>
        /// <returns>データコンテナオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シミュレータ種別とデータ識別子をキーとして、データコンテナ管理テーブルからデータコンテナオブジェクトを取得する</para>
        /// </remarks>
        private HySSimulationDataContainer GetDataContainer(HySKind csSimKind, HySID csID)
        {
            return (HySSimulationDataContainer)m_csDataContainerTbl[(HySString)csSimKind.GetString() + (HySString)csID.GetString()];
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateSimulationInfo()</para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報を生成する処理を開始する
        /// </para>
        /// </remarks>
        protected virtual void CreateSimulationInfo()
        {
            bMdlGenerationBusyFlg = true;// 動作中フラグON
            HySSysEvent csEvent =null;
            if (this.m_csModelGenerator != null && m_csMdlGenerationEvent != null)
            {
                csEvent = m_csMdlGenerationEvent;
                this.m_csModelGenerator.CreateSimulationInfo(ref csEvent);
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                csEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                this.PutEvent(csEvent);
            }
            else
            {   // 通常このルートは通らない
                m_csMdlGenerationEvent.SetTo(HySSysEvent.OBJID_VIEWER); // 宛先を画面に変更
                m_csMdlGenerationEvent.SetFrom(HySSysEvent.OBJID_BUSIPROCEDURE);
                McMdlDtGenAckInfo csSubDt =
                    new McMdlDtGenAckInfo(false, new HySString("モデルジェネレーターが存在しません"), McMdlDtGenAckInfo.MODEL_GENERATION_ACK);
                ((HySEventObject)m_csMdlGenerationEvent).SetSubData(csSubDt);
                this.PutEvent(m_csMdlGenerationEvent);
            }
            m_csMdlGenerationEvent = null; // null にしても delte している訳ではない
            bMdlGenerationBusyFlg = false;// 動作中フラグOFF
        }
// Ver1.1 追加 >>>
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録(ファイル)情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CheckProjectFile( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクトの登録処理を行う。</para>
        /// </remarks>
        private bool CheckProjectFile(HySEventObject csEvent)
        {
            String csMethod = "McBusiProcedure.CheckProjectFile";
            bool bRtn = true;
            long lSubEventNo = csEvent.GetSubEventNo();

            //データコンテナを取り出す
            HySSimulationDataContainer csContainer = GetDataContainer(csEvent);
            if (csContainer != null)
            {
                McProjectInfData csPrjInfData = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                HySString csProjectGroupName = csPrjInfData.GetProjectGroupName();
                HySString csProjectName = csPrjInfData.GetProjectName();

                HySString csFileName = HySEnvInf.GetDataHomeDirectory() + "\\" + csProjectGroupName + "\\" + csProjectName + ".cmprj";
                HySFile csFile = new HySFile(csFileName);
                if (csFile.Exist() == true)
                {
                    csEvent.SetEventNo(HySEventObject.CMND_PROJECT_SAVE);
                    bRtn = SaveProjectFile(csEvent);
                }
                else
                {
                    csEvent.SetTo(HySSysEvent.OBJID_VIEWER);// 宛先を画面に変更
                    csEvent.SetSubEventNo(McDefine.HYMCO_PROJECT_SAVE_NEW);
                    bRtn = this.PutEvent(csEvent);
                }
            }
            else
            {
               // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.HymcoImplResources.STATEMENT_NOT_PROJECT + Properties.HymcoImplResources.STATEMENT_SIMU_TYPE
                    + csEvent.GetToSimKind().ToString() + Properties.HymcoImplResources.STATEMENT_PROJ_ID + csEvent.GetSuppID().ToString();
                HySLog.LogOut(HySLog.ONLINE, csMethod, DispStatement);
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "対応プロジェクトデータが存在しない: " + "シミュレータ種別: " +
               //     csEvent.GetToSimKind().ToString() + " プロジェクトID: " + csEvent.GetSuppID().ToString());
                bRtn = false;
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>プロジェクト登録(ファイル)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveProjectFile( csEvent ) </para>
        /// </example>
        /// <param name="csEvent">送られたイベント</param>
        /// <returns>true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロジェクトの登録処理を行う。</para>
        /// </remarks>
        private bool SaveProjectFile(HySEventObject csEvent)
        {
            String csMethod = "McBusiProcedure.SaveProjectFile";
            bool bRtn = true;
            long lSubEventNo = csEvent.GetSubEventNo();

            //データコンテナを取り出す
            HySSimulationDataContainer csContainer = GetDataContainer(csEvent);
            if (csContainer != null)
            {
                HySID csOrigID = (HySID)csContainer.GetID();
                // 登録用複製データ作成
                //csContainer = csContainer.Clone();
                csContainer = csContainer.DuplicateData();
                // コピー登録時
                if (lSubEventNo == McDefine.HYMCO_PROJECT_SAVE_NEW)
                {
                    // プロジェクト情報の差し替え
                    McProjectInfData csPrjInfData = (McProjectInfData)csContainer.GetData(McDefine.HYM_DATA_PROJECT_INFO);
                    McProjectInfData csUpdatePrjData = (McProjectInfData)((HySEventObject)csEvent).GetData();
                    UpdateProjectInf(csPrjInfData, csUpdatePrjData);

                    // 新規IDを設定
                    SetNewID(csContainer);
                    m_csProjectIDTbl.AddObject((HySString)csContainer.GetID().GetString(), csOrigID);
                    csEvent.SetResponseInfo((HySID)csContainer.GetID());
                }

                // シミュレーション計算ステータスを初期化
                csContainer.SetData(McDefine.HYM_DATA_SIMULATION_INFO, new McSimulationStatus());
                csEvent.SetData(csContainer);
                csEvent.SetTo(HySSysEvent.OBJID_VIEWER);// 宛先を画面に変更
                bRtn = this.PutEvent(csEvent);

            }
            else
            {
                // ver1.5 エラートレース日本語対応
                string DispStatement = Properties.HymcoImplResources.STATEMENT_NOT_PROJECT + Properties.HymcoImplResources.STATEMENT_SIMU_TYPE
                    + csEvent.GetToSimKind().ToString() + Properties.HymcoImplResources.STATEMENT_PROJ_ID  + csEvent.GetSuppID().ToString();
                HySLog.LogOut(HySLog.ONLINE, csMethod, DispStatement );
               // HySLog.LogOut(HySLog.ONLINE, csMethod, "対応プロジェクトデータが存在しない: " + "シミュレータ種別: " +
               //     csEvent.GetToSimKind().ToString() + " プロジェクトID: " + csEvent.GetSuppID().ToString());
                bRtn = false;
            }

            return bRtn;
        }
// Ver1.1 追加 <<<
    }
}
