﻿// <summary>ソースコード：ＨＹＭＣＯ業務ファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;

namespace CommonMP.HYMCO.CoreImpl.BusiProc
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ業務ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McBusiProcedureFactory : HySFactoryMono , HySBusiProcFactory 
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySObjectKind m_csKindID = McDefine.SIMULATOR_KIND;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McBusiProcedureFactory csFactory = new McBusiProcedureFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McBusiProcedureFactory()
        {
            SetFactoryID(McDefine.FACTORY_ID_BUSIPROCEDURE);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bVar = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// true  : 同じ
        /// false : 異なる
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public bool EqualSimKind(HySKind csSimKindID)
        {
            return m_csKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>業務クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySBusiProcedure csBusiProc = CreateBusiProcedure( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySBusiProcedure CreateBusiProcedure()
        {
            HySBusiProcedure csBusiProc = (HySBusiProcedure)new McBusiProcedure();
            csBusiProc.SetSimKind(this.GetSimKind());
            return csBusiProc;
        }
    }
}
