﻿// <summary>ソースコード：ＨＹＭＣＯ定義データ作成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Reflection;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;


using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.FigureUnity;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO.CoreImpl.Controller.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ定義データ作成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McConfigDataMaker : HySConfigDataMaker
    {
        /// <summary>スクリーンファクトリ集合体</summary>
        HySScreenFactorySet m_csScreenFactorySet = null;

        /// <summary>プロパティスクリーンファクトリ集合体</summary>
        McPropertyScreenFactorySet m_csPropertyScreenFactorySet = null;

        /// <summary>モデルファクトリクラス集合体</summary>
        McModelFactorySet m_csModelFactorySet = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McConfigDataMaker()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McConfigDataMaker csMaker = new McConfigDataMaker(csFactoryMng,csModelFactorySet)</para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <param name="csModelFactorySet">モデルファクトリ集合体</param>
        /// <param name="csPrptyScreenSet">プロパティ画面ファクトリ集合体</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McConfigDataMaker(HySFactoryManager csFactoryMng, McModelFactorySet csModelFactorySet , McPropertyScreenFactorySet csPrptyScreenSet )
        {
            m_csFactoryMng = csFactoryMng;
            m_csModelFactorySet = csModelFactorySet;

            m_csScreenFactorySet = csFactoryMng.GetScreenFactorySet();

            m_csPropertyScreenFactorySet = csPrptyScreenSet;

            m_csScreenFactorySet.AddFactory(m_csPropertyScreenFactorySet);

            McMdlLibInfoMng.SetModelFactorySet(m_csModelFactorySet);    // Ver1.5 追加（プロジェクトプロパティ画面）
        }


        /// <summary><para>method outline:</para>
        /// <para>ファクトリ作成処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeFactoryClass(csConfigData) </para>
        /// </example>
        /// <param name="csConfigData">定義データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void MakeFactoryClass(HySConfigData csConfigData)
        {
            Assembly csAssembly = null; // アセンブリ
            Module csModule = null;     // モジュール
            Type csType = null;         // モジュールタイプ
            String csKey;               // データ取り込み用キー
            String csDllName;           // ＤＬＬ名称
            String csKindName;          // クラス種別
            String csPackageName;       // パッケージ名称
            String csClassName;         // クラス名称
            long lLoop;                 // ループカウンタ
            HySID csID;                 // データ識別子
            HySString csKind;           // 種別
            HySString csGroup;          // グループ
            HySString csUniqueKey;      // ユニークキー
            HySFactory csFactory = null;       // ファクトリクラス

            Boolean bAutoFlg = true;
            if (csConfigData != null && csConfigData.Count > 0)
            {
                bAutoFlg = false;
            }

            csPackageName = McDefine.HYMCO_FACTORY_CREATOR_PACKAGE_NAME.ToString();
            if (bAutoFlg == true)
            {   // HYMCO.dicon定義なし（自動生成）
                //string sPath = HySEnvInf.GetHomeDirectory().ToString() + HySEnvInf.GetEnvInf("COMMONMP_EXE_PATH").ToString();
                // 実行パスを取得する
                Assembly csEntryAssembly = Assembly.GetEntryAssembly();
                if (csEntryAssembly == null) { return; }

                string sPathName = csEntryAssembly.Location;
                DirectoryInfo csInfo = Directory.GetParent(sPathName);
                string sPath = csInfo.ToString();
                string[] sFiles = Directory.GetFiles(sPath);
                for (int iLoop = 0; iLoop < sFiles.Length; iLoop++)
                {
                    string sFile = sFiles[iLoop];
                    string sCut = sFile.Substring(sFile.Length - 3);
                    if (sCut.Equals("exe") == true || sCut.Equals("dll") == true)
                    {
                        int iIndex = sFile.LastIndexOf("\\");
                        csDllName = sFile.Substring(iIndex + 1, sFile.Length - (iIndex + 1));
                        try
                        {
                            csAssembly = Assembly.LoadFrom(@csDllName);         // アセンブリ取り込み
                        }
                        catch (Exception e)
                        {
                            HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "catch Exception Assembly.LoadFrom(" + csDllName + ")" + "  DLL_NAME=" + csDllName + ":: "+e.Message);
                            continue;
                        }
                        csModule = csAssembly.GetModule(csDllName);         // モジュール取得
                        if (csModule != null)
                        {
                            // モデルファクトリー
                            csClassName = McDefine.HYMCO_MODEL_FACTORY_CREATOR_CLASS_NAME.ToString();
                            csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                            if (csType != null)
                            {   // 該当クラス有無
                                HYMCO_MODEL_FACTORY_CREATOR csFctCreator = null;
                                try
                                {
                                    // ファクトリクリエータクラス生成
                                    csFctCreator = Activator.CreateInstance(csType) as HYMCO_MODEL_FACTORY_CREATOR;
                                }
                                catch
                                {
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                                        Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_CREATE_INSTANC
                                        + "(" + csType.FullName + ")" + Properties.HymcoImplResources.STATEMENT_DLL_NAME + csDllName);
                                   // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csType.FullName + ")" + "  DLL_NAME=" + csDllName);
                                    continue;
                                }
                                try
                                {
                                    if (csFctCreator != null)
                                    {
                                        csFactory = csFctCreator.CreateFactory();
                                        if (csFactory != null)
                                        {
                                            // データ識別子格納
                                            csKind = new HySString(McDefine.HYMCO_DICN_MODEL);
                                            csGroup = new HySString(csType.FullName);
                                            csUniqueKey = new HySString(csType.Name);
                                            if (csFactory.GetFactoryID() == null)
                                            {
                                                //csID = new HySID(csKind, csGroup, csUniqueKey);
                                                csID = new HySID(csKind + csGroup + csUniqueKey);
                                                csFactory.SetFactoryID((HySIdentifier)csID);
                                            }
                                            // DLL名称設定
                                            m_csModelFactorySet.SetDllName(csDllName);
                                            m_csModelFactorySet.AddFactory(csFactory);
                                            // ファクトリ初期処理実行
                                            csFactory.Init(m_csFactoryMng);

                                            HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** CreateModelFactoryInstance(" + csFactory.GetFactoryID().ToString() + ")");
                                            McMdlLibInfoMng.AddModelDLLInfo(csDllName, csFactory);  // Ver1.5 追加（プロジェクトプロパティ画面）
                                        }
                                        else
                                        {
                                           // ver1.5 エラートレース日本語対応
                                            HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                                                Properties.HymcoImplResources.STATEMENT_FAILED_CREATE +"(" + csType.FullName + ")"); // ログへ書き込む
                                           // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot CreateInstance(" + csType.FullName + ")"); // ログへ書き込む
                                        }
                                    }
                                }
                                catch (Exception e)
                                {
                                   // ver1.5 エラートレース日本語対応
                                    string DispStatement = Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_CREATE_INSTANC 
                                         + "(" + csType.FullName + ")" + Properties.HymcoImplResources.STATEMENT_DLL_NAME + csDllName + ", " + e.Message ;
                                    HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", DispStatement );
                                   // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csType.FullName + ")" + "  DLL_NAME=" + csDllName + ", " + e.Message);
                                }
                            }
                            // スクリーンファクトリー
                            csClassName = McDefine.HYMCO_SCREEN_FACTORY_CREATOR_CLASS_NAME.ToString();
                            csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                            if (csType != null)
                            {   // 該当クラス有無
                                PROPERTY_SCREEN_FACTORY_CREATOR csFctCreator = null;
                                try
                                {
                                    // ファクトリクリエータクラス生成
                                    csFctCreator = Activator.CreateInstance(csType) as PROPERTY_SCREEN_FACTORY_CREATOR;
                                }
                                catch
                                {
                                   // ver1.5 エラートレース日本語対応
                                    string DispStatement = Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_CREATE_INSTANC
                                        + "(" + csType.FullName + ")" + Properties.HymcoImplResources.STATEMENT_DLL_NAME + csDllName;
                                    HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", DispStatement);
                                   // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csType.FullName + ")" + "  DLL_NAME=" + csDllName);
                                    continue;
                                }
                                if (csFctCreator != null)
                                {
                                    csFactory = csFctCreator.CreateFactory();
                                    if (csFactory != null)
                                    {
                                        // データ識別子格納
                                        csKind = new HySString(McDefine.HYMCO_DICN_PROPERTY_SCREEN);
                                        csGroup = new HySString(csType.FullName);
                                        csUniqueKey = new HySString(csType.Name);
                                        if (csFactory.GetFactoryID() == null)
                                        {
                                            //csID = new HySID(csKind, csGroup, csUniqueKey);
                                            csID = new HySID(csKind + csGroup + csUniqueKey);
                                            csFactory.SetFactoryID((HySIdentifier)csID);
                                        }
                                        m_csPropertyScreenFactorySet.AddFactory(csFactory);
                                        // ファクトリ初期処理実行
                                        csFactory.Init(m_csFactoryMng);

                                        HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** CreateScreenFactoryInstance(" + csFactory.GetFactoryID().ToString() + ")");
                                    }
                                    else
                                    {
                                        // ver1.5 エラートレース日本語対応
                                        HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                                            Properties.HymcoImplResources.STATEMENT_FAILED_CREATE + "(" + csType.FullName + ")"); // ログへ書き込む
                                       // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot CreateInstance(" + csType.FullName + ")"); // ログへ書き込む
                                    }
                                }
                            }
                        }
                        /*
                        // 将来用論理（HYMCO.dicon 無くても登録出来る様にする為の処理）　
                        {
                            csAssembly = Assembly.LoadFrom(@csDllName);         // アセンブリ取り込み
                            csModule = csAssembly.GetModule(csDllName);         // モジュール取得

                            csPackageName = "CommonMP.HYMCO._SYSTEM_";
                            // モデルファクトリー
                            csClassName = "HYMCO_MODEL_FACTORY_CREATOR_IMPLE";
                            csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                            if (csType != null)                                 // 該当クラス有無
                            {
                                HYMCO_MODEL_FACTORY_CREATOR fctCreator = (HYMCO_MODEL_FACTORY_CREATOR)Activator.CreateInstance(csType);
                                if (fctCreator != null)
                                {
                                    csFactory = fctCreator.CreateFactory();
                                    if (csFactory != null)
                                    {
                                        m_csModelFactorySet.AddFactory(csFactory);
                                        csFactory.Init(m_csFactoryMng);  // ファクトリ初期処理実行
                                        HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** Create ModelFactoryInstance(" + csDllName + ")");
                                    }
                                    else
                                    {
                                        HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** Cannot Create ModelFactoryInstance(" + csDllName + ")");
                                    }
                                }
                            }
                            // プロパティ画面ファクトリー
                            // 
                            csClassName = "HYMCO_SCREEN_FACTORY_CREATOR_IMPLE";
                            csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                            if (csType != null)                                 // 該当クラス有無
                            {
                                PROPERTY_SCREEN_FACTORY_CREATOR fctCreator = (PROPERTY_SCREEN_FACTORY_CREATOR)Activator.CreateInstance(csType);
                                if (fctCreator != null)
                                {
                                    csFactory = fctCreator.CreateFactory();
                                    if (csFactory != null)
                                    {
                                        m_csPropertyScreenFactorySet.AddFactory(csFactory);
                                        csFactory.Init(m_csFactoryMng); // ファクトリ初期処理実行
                                        HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** Create PropertyScreenFactoryInstance(" + csDllName + ")");
                                    }
                                    else
                                    {
                                        HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** Cannot Create PropertyScreenFactoryInstance(" + csDllName + ")");
                                    }
                                }
                            }
                        }
                        // end of 将来用論理
                        */
                    }
                }
            }
            else
            {   // HYMCO.dicon定義あり
                for (lLoop = 0; lLoop < csConfigData.Count; lLoop++)
                {
                    csKey = csConfigData.GetKeyName((int)lLoop);            // 取り込みキー作成
                    csKindName = csConfigData.GetFactoryKind(csKey);        // 種別取得
                    csDllName = csConfigData.GetFactoryDll(csKey);          // ＤＬＬ名称
                    if (File.Exists(csDllName))                             // ＤＬＬ有無
                    {
                        csAssembly = Assembly.LoadFrom(@csDllName);         // アセンブリ取り込み
                        csModule = csAssembly.GetModule(csDllName);         // モジュール取得
                        // モデルファクトリー
                        csClassName = McDefine.HYMCO_MODEL_FACTORY_CREATOR_CLASS_NAME.ToString();
                        csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                        if (csType != null)
                        {   // 該当クラス有無
                            HYMCO_MODEL_FACTORY_CREATOR csFctCreator = null;
                            try
                            {
                                // ファクトリクリエータクラス生成
                                csFctCreator = (HYMCO_MODEL_FACTORY_CREATOR)Activator.CreateInstance(csType);
                            }
                            catch
                            {
                               // ver1.5 エラートレース日本語対応
                                string DispStatement = Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_CREATE_INSTANC
                                    + "(" + csType.FullName + ")" + Properties.HymcoImplResources.STATEMENT_DLL_NAME + csDllName;
                                HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", DispStatement );
                               // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csType.FullName + ")" + "  DLL_NAME=" + csDllName);
                                continue;
                            }
                            if (csFctCreator != null)
                            {
                                csFactory = csFctCreator.CreateFactory();
                                if (csFactory != null)
                                {
                                    HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** CreateInstance(" + csType.FullName + ")");

                                    // データ識別子格納
                                    csKind = new HySString(McDefine.HYMCO_DICN_MODEL);
                                    csGroup = new HySString(csType.FullName);
                                    csUniqueKey = new HySString(csType.Name);
                                    if (csFactory.GetFactoryID() == null)
                                    {
                                        //csID = new HySID(csKind, csGroup, csUniqueKey);
                                        csID = new HySID(csKind + csGroup + csUniqueKey);
                                        csFactory.SetFactoryID((HySIdentifier)csID);
                                    }
                                    // DLL名称設定
                                    m_csModelFactorySet.SetDllName(csDllName);
                                    m_csModelFactorySet.AddFactory(csFactory);
                                    // ファクトリ初期処理実行
                                    csFactory.Init(m_csFactoryMng);
                                }
                                else
                                {
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                                        Properties.HymcoImplResources.STATEMENT_FAILED_CREATE + "(" + csType.FullName + ")"); // ログへ書き込む
                                   // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot CreateInstance(" + csType.FullName + ")"); // ログへ書き込む
                                }
                            }
                        }
                        // スクリーンファクトリー
                        csClassName = McDefine.HYMCO_SCREEN_FACTORY_CREATOR_CLASS_NAME.ToString();
                        csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
                        if (csType != null)
                        {   // 該当クラス有無
                            PROPERTY_SCREEN_FACTORY_CREATOR csFctCreator = null;
                            try
                            {
                                // ファクトリクリエータクラス生成
                                csFctCreator = (PROPERTY_SCREEN_FACTORY_CREATOR)Activator.CreateInstance(csType);
                            }
                            catch
                            {
                                // ver1.5 エラートレース日本語対応
                                string DispStatement = Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION + Properties.HymcoImplResources.STATEMENT_CREATE_INSTANC
                                    + "(" + csType.FullName + ")" + Properties.HymcoImplResources.STATEMENT_DLL_NAME + csDllName;
                                HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", DispStatement );
                               // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csType.FullName + ")" + "  DLL_NAME=" + csDllName);
                                continue;
                            }
                            if (csFctCreator != null)
                            {
                                csFactory = csFctCreator.CreateFactory();
                                if (csFactory != null)
                                {
                                    HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** CreateInstance(" + csType.FullName + ")");

                                    // データ識別子格納
                                    csKind = new HySString(McDefine.HYMCO_DICN_PROPERTY_SCREEN);
                                    csGroup = new HySString(csType.FullName);
                                    csUniqueKey = new HySString(csType.Name);
                                    if (csFactory.GetFactoryID() == null)
                                    {
                                        //csID = new HySID(csKind , csGroup, csUniqueKey);
                                        csID = new HySID(csKind + csGroup + csUniqueKey);
                                        csFactory.SetFactoryID((HySIdentifier)csID);
                                    }
                                    m_csPropertyScreenFactorySet.AddFactory(csFactory);
                                    // ファクトリ初期処理実行
                                    csFactory.Init(m_csFactoryMng);
                                }
                                else
                                {
                                   // ver1.5 エラートレース日本語対応
                                    HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                                        Properties.HymcoImplResources.STATEMENT_FAILED_CREATE + "(" + csType.FullName + ")"); // ログへ書き込む
                                   // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot CreateInstance(" + csType.FullName + ")"); // ログへ書き込む
                                }
                            }
                        }
                    }
                    else
                    {
                       // ver1.5 エラートレース日本語対応
                        HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", 
                            Properties.HymcoImplResources.STATEMENT_MISSIGN + csDllName); // ログへ書き込む
                       // HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot be found " + csDllName); // ログへ書き込む
                    }
                }
            }

            //for (lLoop = 0; lLoop < csConfigData.Count; lLoop++)
            //{
            //    csKey = csConfigData.GetKeyName((int)lLoop);            // 取り込みキー作成
            //    csKindName = csConfigData.GetFactoryKind(csKey);        // 種別取得
            //    csDllName = csConfigData.GetFactoryDll(csKey);          // ＤＬＬ名称
            //    csPackageName = csConfigData.GetFactoryPackage(csKey);  // パッケージ名称
            //    csClassName = csConfigData.GetFactoryClass(csKey);      // クラス名称
            //    if (File.Exists(csDllName))                             // ＤＬＬ有無
            //    {
            //        csAssembly = Assembly.LoadFrom(@csDllName);         // アセンブリ取り込み
            //        csModule = csAssembly.GetModule(csDllName);         // モジュール取得
            //        csType = csModule.GetType(csPackageName + "." + csClassName);// モジュールタイプ取得
            //        if (csType != null)                                 // 該当クラス有無
            //        {
            //            csFactory = null;
            //            try
            //            {
            //                // ファクトリクラス生成
            //                csFactory = (HySFactory)Activator.CreateInstance(csType);
            //            }
            //            catch
            //            {
            //                HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "catch Exception CreateInstance(" + csPackageName + "." + csClassName + ")" + "  DLL_NAME=" + csDllName);
            //                continue;
            //            }

            //            HySLog.LogOut(HySLog.DEBUG, "McConfigDataMaker::MakeFactoryClass", "*** CreateInstance(" + csPackageName + "." + csClassName + ")");

            //            // データ識別子格納
            //            csKind = new HySString(csKindName);
            //            csGroup = new HySString(csPackageName);
            //            csUniqueKey = new HySString(csClassName);
            //            if (csFactory.GetFactoryID() == null)
            //            {
            //                csID = new HySID(csKind, csGroup, csUniqueKey);
            //                csFactory.SetFactoryID((HySIdentifier)csID);
            //            }

            //            if (csKind == McDefine.HYMCO_DICN_MODEL)                  // モデルファクトリ
            //            {
            //                m_csModelFactorySet.AddFactory(csFactory);
            //                //if (m_csModelFactory != null)m_csModelFactory.AddFactory(csFactory);
            //            }
            //            else if (csKind == McDefine.HYMCO_DICN_PROPERTY_SCREEN)                      // プロパティ画面ファクトリ
            //            {
            //                m_csPropertyScreenFactorySet.AddFactory(csFactory);
            //            }
            //            else if (csKind == McDefine.HYMCO_DICN_SCREEN)                      // スクリーンファクトリ
            //            {
            //                m_csScreenFactorySet.AddFactory(csFactory);
            //            }
            //            else
            //            {
            //                HySLog.LogOut(HySLog.TRIAL_RUN, "McConfigDataMaker::MakeFactoryClass", "Unknown Class " + csPackageName + "." + csClassName + ":" + csKind); // ログへ書き込む
            //            }
            //            // ファクトリ初期処理実行
            //            csFactory.Init(m_csFactoryMng);
            //        }
            //        else
            //        {
            //            HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot be found " + csPackageName + "." + csClassName); // ログへ書き込む
            //        }
            //    }
            //    else
            //    {
            //        HySLog.LogOut(HySLog.ONLINE, "McConfigDataMaker::MakeFactoryClass", "Cannot be found " + csDllName); // ログへ書き込む
            //    }
            //} // end fo for();
        }

        //
    }
}
