﻿// <summary>ソースコード：ＨＹＭＣＯＤＩコンテナクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController.DIContainer;

using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.FigureUnity;

namespace CommonMP.HYMCO.CoreImpl.Controller.DIContainer
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯ ＤＩコンテナクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSystemDIContainer : HySDIContainerImpl
    {
        /// <summary>定義データファイル名称</summary>
        HySString m_csFileName;

        McFigureUnityFactory m_csFigUnityFactory = null;

        /// <summary><para>method outline:</para>
        /// <para>定義データ管理クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySConfigDataManager csManager = GetConfigDataManager(csFactoryMng)</para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理クラス</param>
        /// <returns>定義データ管理クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySConfigDataManager GetConfigDataManager(HySFactoryManager csFactoryMng)
        {
            // 環境ファイルより取得
            m_csFileName = HySEnvInf.GetEnvInf(new HySString("MCSYSTEMDICON"));

            HySConfigDataReader csDataReader = HySConfigDataReaderFactory.CreateInstanse(m_csFileName);

            McConfigDataMaker csDataMaker = new McConfigDataMaker(csFactoryMng, m_csFigUnityFactory.GetModelFactorySet(), m_csFigUnityFactory.GetPropertyScreenFactorySet());

            HySConfigDataManager csManager = new HySConfigDataManager(csDataReader, csDataMaker);

            return csManager;
        }

        //=== 固有メソッド ====
        /// <summary><para>method outline:</para>
        /// <para>シミュレーターファクトリクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFigureUnityFactory(csFigUnityFactory)</para>
        /// </example>
        /// <param name="csFigUnityFactory">HYMCOシミュレーターファクトリクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetFigureUnityFactory(McFigureUnityFactory csFigUnityFactory)
        { m_csFigUnityFactory = csFigUnityFactory; }
    }
}
