﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Data.FileIO;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Tool;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>演算要素クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McCalElement : McCmnElement
    {  
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElement csElm = new McCmnElement()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        public McCalElement() : base ()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElement csElm = new McCmnElement( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalElement(HySIdentifier csID) : base(csID)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetProperty( ref csErrorInfo)</para>
        /// </example>
        /// <param name="csElmID">変更対象要素識別子</param>
        /// <param name="csMdlInfo">変更情報</param>
        /// <param name="csErrorInfo">接続エラー情報</param>
        /// <returns>=true:変更対象であった、!=true:変更対象ではない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>モデル生成時にモデル内部情報を設定する</para>
        /// </remarks>
        internal override bool SetProperty(HySID csElmID, McModelInfo csMdlInfo, ref McStructErrorInfo csErrorInfo)
        {
            bool bRtn = false;
            if (this.m_csID.Equals(csElmID) == true)
            {   // 対象ならば
                bRtn = true;   // 自身が対象だったならば true を返す
                if (m_csCalModel != null)
                {   // モデル有り
                    McPropertyInfoRoot csRroptyInfo = csMdlInfo.GetPropertyInfo();
                    if (csRroptyInfo != null)
                    {
                        try
                        {
                            m_csCalModel.SetProperty(csRroptyInfo);
                        }
                        catch (Exception ex)
                        {
                            // ログ出力
                           // ver1.5 エラートレース日本語対応
                            HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetProperty", 
                                "SetProperty " + Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION 
                                 + Properties.HymcoImplResources.STATEMENT_IN_CLASS  +"(" + m_csCalModel.ToString() + ") :: " + ex.Message);
                           // HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetProperty", "SetProperty Exception Catch" + " in Class(" + m_csCalModel.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " SetProperty Exception Catch", 
                                Properties.HymcoImplResources.STATEMENT_IN_CLASS +  " (" + m_csCalModel.ToString() + ") :: " + ex.Message);
                           // McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " SetProperty Exception Catch", " in (" + m_csCalModel.ToString() + ") :: " + ex.Message);
                            // 異常通知
                            bRtn = false;
                        }
                    }
                    McPropertyInfoRoot csInitInfo = csMdlInfo.GetInitialInfo();
                    if (csInitInfo != null)
                    {
                        this.PresetInitializeData(csInitInfo);
                        this.SimInitialize();
                    }
                }
                else
                {
                    ((McStructCheckData)csErrorInfo).AddCheckData((HySID)this.m_csID, new HySObjectKind(""), McDefine.MessageLevel.HYM_MODELCHECK_ERROR,
                        new HySString("Element have not model"));
                }
            }
            return bRtn;
        }   
        /// <summary><para>method outline:</para>
        /// <para>演算実行中断中のプロパティ等情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = SetOnlineProperty( csElmID, csMdlInfo, ref csErrorInfo)</para>
        /// </example>
        /// <param name="csElmID">変更対象要素識別子</param>
        /// <param name="csMdlInfo">変更情報</param>
        /// <param name="csErrorInfo">接続エラー情報</param>
        /// <returns>=true:変更対象であった、!=true:変更対象ではない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>演算中断中にプロパティ、初期値等を変更して動作させ場合等に使用する</para>
        /// </remarks>
        internal override bool SetOnlineProperty(HySID csElmID, McModelInfo csMdlInfo, ref McStructErrorInfo csErrorInfo)
        {
            bool bRtn = false;
            if (this.m_csID.Equals(csElmID) == true)
            {   // 対象ならば
                bRtn = true;   // 自身が対象だったならば true を返す
                if (m_csCalModel != null)
                {   // モデル有り
                    McPropertyInfoRoot csRroptyInfo = csMdlInfo.GetPropertyInfo();
                    if (csRroptyInfo != null)
                    {
                        try
                        {
                            m_csCalModel.SetOnlineProperty(csRroptyInfo);
                        }
                        catch (Exception ex)
                        {
                            // ログ出力
                           // ver1.5 エラートレース日本語対応
                            HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetOnlineProperty",
                                "SetOnlineProperty"  + Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION
                                + Properties.HymcoImplResources.STATEMENT_IN_CLASS + "(" + m_csCalModel.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                           // HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetOnlineProperty", "SetOnlineProperty Exception Catch" + " in Class(" + m_csCalModel.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " SetOnlineProperty Exception Catch",
                               Properties.HymcoImplResources.STATEMENT_IN_CLASS +  "(" + m_csCalModel.ToString() + ") :: " + ex.Message);
                           // McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " SetOnlineProperty Exception Catch", " in (" + m_csCalModel.ToString() + ") :: " + ex.Message);
                            // 異常通知
                            bRtn = false;
                        }
                    }
                    McPropertyInfoRoot csInitInfo = csMdlInfo.GetInitialInfo();
                    if (csInitInfo != null)
                    {
                        try
                        {
                            m_csCalModel.OnlineInitialize(ref csInitInfo, ref m_csReceiveInfoList, ref m_csSendInfoList);
                        }
                        catch (Exception ex)
                        {
                            // ログ出力
                           // ver1.5 エラートレース日本語対応
                            HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetOnlineProperty", 
                                "OnlineInitialize " + Properties.HymcoImplResources.STATEMENT_CATCH_EXCEPTION 
                                + Properties.HymcoImplResources.STATEMENT_IN_CLASS + "(" + m_csCalModel.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                           // HySLog.LogOut(HySLog.ONLINE, "McCalElement::SetOnlineProperty", "OnlineInitialize Exception Catch" + " in Class(" + m_csCalModel.ToString() + ") :: " + ex.Message); //ex.StackTrace);
                           // ver1.5 エラートレース日本語対応
                            McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " OnlineInitialize Exception Catch",
                               Properties.HymcoImplResources.STATEMENT_IN_CLASS + "(" + m_csCalModel.ToString() + ") :: " + ex.Message);
                           // McLog.DebugOut(m_csCalModel.GetSimulationTime(), GetID(), McLog.SYSTEM, " OnlineInitialize Exception Catch", " in (" + m_csCalModel.ToString() + ") :: " + ex.Message);
                            // 異常通知
                            bRtn = false;
                        }
                    }
                }
                else
                {
                    ((McStructCheckData)csErrorInfo).AddCheckData((HySID)this.m_csID, new HySObjectKind(""), McDefine.MessageLevel.HYM_MODELCHECK_ERROR,
                        new HySString("Element have not model"));
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算状態復元のためのデータクラスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCmnElementOutData csElementOutData = CreateOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCmnElementOutData CreateOutData()
        {
            if (m_csCalModel as McIOCtlModlBase != null)
            {
                return (m_csCalModel.CreateOutData());
            }
            return new McCalElementOutData();
        }
    }
}
