﻿// <summary>ソースコード：ＨＹＭＣＯグループ化要素内部向け受信端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCOグループ化要素内部向け受信端子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    internal class McInnerRcvPort : McReceivePort
    {
        /// <summary>自分を保持するHYMCOグループ化要素外部送信端子クラス</summary>
        protected McSendTrnsPort m_csSndTrnPort = null;

        /// <summary>グループ外へ情報を素通りさせるか否かを設定 =true:素通り,=false:素通りせず
        /// falseの場合、Ｇｒ化要素外への伝送データは、一時的にm_csSndTrnPortへ蓄えられてから、Ｇｒ化要素のδＴのタイミングで外部に吐き出される
        /// </summary>
        protected bool m_bDataThroughFlg = false;    // false になる場合には、別マシン間で伝送データをやり取りする場合など、
        /// <summary>グループ外へ送信情報 m_bDataThroughFlg=falseの時有効</summary>
        protected McTranInfo m_csCopyTranInfo;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McInnerRcvPort csPrt = new McInnerRcvPort(csTrnsPort)</para>
        /// </example>
        /// <param name="csTrnsPort">自分を持つグループ化要素外部送信端子クラス</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McInnerRcvPort(McSendTrnsPort csTrnsPort)
        {
            m_csSndTrnPort = csTrnsPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetTranInfo(McTranInfo csInfo)
        {
            m_csCopyTranInfo = csInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McTranInfo GetTranInfo()
        {
            if (m_bDataThroughFlg == true)
            {   // 素通りの場合
                return base.GetTranInfo(); 
            }
            else
            {   // 素通りでない場合 
                return m_csCopyTranInfo;
            }

        }

        // 固有メソッド
        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報素通り設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataThroughFlg(bSW) </para>
        /// </example>
        /// <param name="bSW">=true:素通り、=false:素通りせず</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>将来用：現在使用禁止</para>
        /// </remarks>
        internal virtual void SetDataThroughFlg(bool bSW)
        {
            m_bDataThroughFlg = bSW;
        }
        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>MakeContinuity( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void MakeContinuity()
        {
            if (m_bDataThroughFlg == false)
            {   // 素通りでない場合
                if (m_csCopyTranInfo != null)
                {
                    if (m_csSendPort != null)
                    {
                        m_csCopyTranInfo.MakeRelayPortDataTransContinuity(m_csSendPort.GetTranInfo());
                    }
                }
            }
            else
            {
                // 素通りの場合には何もしない
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報素通り設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataTrans()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void DataTrans()
        {
            if (m_bDataThroughFlg == false)
            {   // 素通りでない場合
                //m_csSendPort.GetTranInfo().CopyInfo(m_csCopyTranInfo); // データをコピーする
                // 此処は、全コピーではなく、差分コピーが必要：TranInfo にＩ／Ｆが必要
                //(m_csSndTrnPort.GetHoldTranInfo()).LastDataCopy(m_csSendPort.GetTranInfo());
                if (m_csCopyTranInfo != null)
                {
                    m_csCopyTranInfo.LastDataCopy(m_csSendPort.GetTranInfo());
                }
            }
            else
            {
                // 素通りの場合には何もしない
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>中継端子の導通のチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = TransCheck()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true:正常、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual bool TransCheck()
        {
            if (m_csSendPort == null)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
    }
}
