﻿// <summary>ソースコード：ＨＹＭＣＯグループ化要素内部向け送信端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCOグループ化要素内部向け送信端子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    internal class McInnerSndPort : McSendPort
    {
        /// <summary>自分を保持するHYMCOグループ化要素外部受信端子クラス</summary>
        McReceiveTrnsPort m_csRevTrnPort=null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McInnerSndPort csPrt = new McInnerSndPort(csTrnsPort)</para>
        /// </example>
        /// <param name="csTrnsPort">自分を持つグループ化要素外部受信端子クラス</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McInnerSndPort(McReceiveTrnsPort csTrnsPort)
        {
            m_csRevTrnPort = csTrnsPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetTranInfo(McTranInfo csInfo)
        {
            // 何もしない
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McTranInfo GetTranInfo()
        {
            // 外部から伝送データを取得する
            return m_csRevTrnPort.GetTranInfo();
        }
    }
}
