﻿// <summary>ソースコード：ＨＹＭＣＯ受信端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCO受信端子クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McReceivePort : McPort
    {
        /// <summary>インスタンス識別ＩＤ</summary>
        protected HySID m_csID=null;
        /// <summary>自分を保持しているエレメント</summary>
        protected McElement m_csElement=null;

        /// <summary>接続相手（送信端子）</summary>
        protected McSendPort m_csSendPort=null;

        /// <summary>接続</summary>
        protected McConnection m_csConnection = null;


        /// <summary>ユニーク識別子を作る為の一貫番号</summary>
        protected static long m_slRcvPortNo = 0;

        /// <summary><para>method outline:</para>
        /// <para>ユニーク識別子自動付与用の一貫番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetPrimNo(lNo)</para>
        /// </example>
        /// <param name="lNo">設定番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static void SetPrimNo(long lNo)
        {
            m_slRcvPortNo = lNo;

        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceivePort csPrt = new McReceivePort()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        public McReceivePort()
        {
            m_slRcvPortNo += 1;
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceivePort csPrt = new McReceivePort(csID)</para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McReceivePort(HySIdentifier csID)
        {
            m_slRcvPortNo += 1; 
            this.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>接続設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnection(csCnnction) </para>
        /// </example>
        /// <param name="csCnnction">接続情報クラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnection(McConnection csCnnction)
        {
            m_csConnection = csCnnction; // コネクション設定
        }

        /// <summary><para>method outline:</para>
        /// <para>接続先端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPartnerPort(csPort) </para>
        /// </example>
        /// <param name="csPort">接続先</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetPartnerPort(McPort csPort)
        {
            m_csSendPort = (McSendPort)csPort;
        }
        /// <summary><para>method outline:</para>
        /// <para>接続先端子端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendPort csPort = GetPartnerPort() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendPort 接続相手先の送信ポート</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual McSendPort GetPartnerPort()
        {
            return m_csSendPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTranInfo(McTranInfo csInfo)
        {
            // 何もしないこと
            return; 
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo GetTranInfo()
        {
            McTranInfo csRtnInf = null;
            if (m_csSendPort != null)
            {
                csRtnInf = m_csSendPort.GetTranInfo();
            }
            return csRtnInf;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csIdentifier = GetID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal( sID ) </para>
        /// </example>
        /// <param name="sID">比較する種別識別子</param>
        /// <returns>  true :＝ , false:≠</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier sID)
        {
            return m_csID.Equals(sID);
        }

        /// <summary><para>method outline:</para>
        /// <para>端子を保持している要素の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McElement csElm = GetElement( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>端子を保持している要素</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McElement GetElement()
        {
            return m_csElement;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElement(csElm) </para>
        /// </example>
        /// <param name="csElm">自分を保持する要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetElement(McElement csElm)
        {
            m_csElement = csElm;
        }

        /// <summary><para>method outline:</para>
        /// <para>接続情報の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McConnection csCnct = GetConnection( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>接続情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual McConnection GetConnection()
        {
            return m_csConnection;
        }
    }
}
