﻿// <summary>ソースコード：ＨＹＭＣＯグループ化要素外部受信端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>中継受信端子（グループ化要素外部受信端子）クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    public class McReceiveTrnsPort : McReceivePort
    {
        /// <summary>グループ内向け送信端子</summary>
        private McInnerSndPort m_csInnerSndPort=null;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceiveTrnsPort csPrt = new McReceiveTrnsPort()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        public McReceiveTrnsPort()
        {
            this.Init();
            //m_csInnerSndPort.SetID( m_csID );
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McReceiveTrnsPort csPrt = new McReceiveTrnsPort(csID)</para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McReceiveTrnsPort(HySIdentifier csID)
            : base(csID)
        {
            this.Init();
            m_csInnerSndPort.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected void Init()
        {
            m_csInnerSndPort = new McInnerSndPort(this);
        }


        /// <summary><para>method outline:</para>
        /// <para>接続内を流れるデータの整合性チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DataCheck(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>  true :正常　 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool DataCheck()
        {
            bool bRtn = false;

            McTranInfo csInfo = this.GetTranInfo();   // 外部からの入力情報を取得
            if (csInfo != null)
            {   // 外部データがあれば
                if( m_csInnerSndPort != null )
                {   // 内部に接続されているか
                    bRtn = csInfo.SameKind(m_csInnerSndPort.GetTranInfo()); // 外部から流れ込む情報と内部に流れる情報の型が同じか
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定情報はチェック用に使用する</para>
        /// </remarks>
        public override void SetTranInfo(McTranInfo csInfo)
        {
            m_csInnerSndPort.SetTranInfo(csInfo);
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetID(HySIdentifier csID)
        {
            if (m_csInnerSndPort != null)
            {
                m_csInnerSndPort.SetID(csID);
            }
            base.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElement(csElm) </para>
        /// </example>
        /// <param name="csElm">自分を保持する要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override void SetElement(McElement csElm)
        {
            m_csInnerSndPort.SetElement(csElm);
            base.SetElement(csElm);
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ内向け送信端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McInnerSndPort csPort = GetInnerSndPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>グループ内向け送信端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual McInnerSndPort GetInnerSndPort()
        {
            return m_csInnerSndPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>Gr内向け接続先端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInternalPartnerPort(csPort) </para>
        /// </example>
        /// <param name="csPort">接続先</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetInternalPartnerPort(McPort csPort)
        {
            this.m_csInnerSndPort.SetPartnerPort(csPort);
        }

    }
}
