﻿// <summary>ソースコード：ＨＹＭＣＯグループ化要素外部送信端子クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Controller
{
    /// <summary><para>class outline:</para>
    /// <para>中継送信端子（グループ化要素外部送信端子）クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    public class McSendTrnsPort : McSendPort
    {
        /// <summary>グループ内向け受信端子</summary>
        private McInnerRcvPort m_csInnerRcvPort=null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSendTrnsPort csPrt = new McSendTrnsPort()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        public McSendTrnsPort()
        {
            this.Init();
            //m_csInnerRcvPort.SetID(m_csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSendTrnsPort csPrt = new McSendTrnsPort(csID)</para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSendTrnsPort(HySIdentifier csID)
            : base(csID)
        {
            this.Init();
            m_csInnerRcvPort.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected void Init()
        {
            m_csInnerRcvPort = new McInnerRcvPort(this);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTranInfo(csInfo) </para>
        /// </example>
        /// <param name="csInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>本設定情報はチェック用に使用する</para>
        /// </remarks>
        public override void SetTranInfo(McTranInfo csInfo)
        {
            m_csInnerRcvPort.SetTranInfo(csInfo);   // 内部向け　受信端子側にデータを設定しておく
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McTranInfo GetTranInfo()
        {
            // 内部接続先から伝送データを読み出してくる
            return m_csInnerRcvPort.GetTranInfo();
        }
        /// <summary><para>method outline:</para>
        /// <para>中継端子自身が保持している伝送データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csInf = GetHoldTranInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>GetTranInfo()で取得したインスタンスとは異なることに注意</para>
        /// </remarks>
        internal virtual McTranInfo GetHoldTranInfo()
        {
            return base.GetTranInfo();
        }

        /// <summary><para>method outline:</para>
        /// <para>接続内を流れるデータの整合性チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DataCheck(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>  true :正常　 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool DataCheck()
        {
            bool bRtn = false;

            if (m_csInfo != null)
            {   // データの型があれば
                // Gr内から流れてくるデータの型と一致しているか
                bRtn = m_csInfo.SameKind(m_csInnerRcvPort.GetTranInfo());
                if (bRtn == true)
                {   // Gr内からのデータがOKの場合
                    if (m_csConnection != null)
                    {   // 外部に対して接続が既にあれば　データの型をチェック
                        bRtn = m_csConnection.DataCheck();
                    }
                }
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetID( csID ) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetID(HySIdentifier csID)
        {
            if (m_csInnerRcvPort != null)
            {
                m_csInnerRcvPort.SetID(csID);
            }
            base.SetID(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>要素設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetElement(csElm) </para>
        /// </example>
        /// <param name="csElm">自分を保持する要素</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal override void SetElement(McElement csElm)
        {
            m_csInnerRcvPort.SetElement(csElm);
            base.SetElement(csElm);
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ内向け受信端子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McInnerRcvPort csPort = GetInnerRcvPort( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>グループ内向け受信端子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual McInnerRcvPort GetInnerRcvPort()
        {
            return m_csInnerRcvPort;
        }

        /// <summary><para>method outline:</para>
        /// <para>Gr内向け接続先端子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInternalPartnerPort(csPort) </para>
        /// </example>
        /// <param name="csPort">接続先</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal virtual void SetInternalPartnerPort(McPort csPort)
        {
            this.m_csInnerRcvPort.SetPartnerPort(csPort);
        }
    }
}
