﻿// <summary>ソースコード：>データ検索条件クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSDBA;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CoreImpl.DBA
{
    /// <summary><para>class outline:</para>
    /// <para>HYMCOプロジェクトデータ検索条件フィールド名定義</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>HySQueryEntryData.FieldNameに指定できる名前を定義する。</para>
    /// <para>本クラスに含まれる名前は、HYMCOプロジェクトデータ固有のフィールドである。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/22][新規作成]</para>
    /// </remarks>
    public class McProjectQueryFieldNames: HySQueryFieldNames
    {
        /// <summary>
        /// プロジェクト名
        /// </summary>
        public static readonly HySString PROJECT_NAME = new HySString("PROJECT_NAME");

        /// <summary>
        /// 管理者名
        /// </summary>
        public static readonly HySString MANAGER_NAME = new HySString("MANAGER_NAME");

        /// <summary>
        /// 登録日付
        /// </summary>
        public static readonly HySString REGISTRATION_DATE = new HySString("REGISTRATION_DATE");

        /// <summary>
        /// 更新日付
        /// </summary>
        public static readonly HySString UPDATE_DATE = new HySString("UPDATE_DATE");

        /// <summary>
        /// 種別
        /// </summary>
        public static readonly HySString MODEL_TYPE = new HySString("MODEL_TYPE");

        /// <summary>
        /// 対象
        /// </summary>
        public static readonly HySString MODEL_TARGET = new HySString("MODEL_TARGET");

        /// <summary>
        /// モデル
        /// </summary>
        public static readonly HySString MODEL_CALC_TYPE = new HySString("MODEL_CALC_TYPE");

        /// <summary>
        /// 件名
        /// </summary>
        public static readonly HySString MODEL_SUBJECT = new HySString("MODEL_SUBJECT");

        /// <summary>
        /// ケース名
        /// </summary>
        public static readonly HySString MODEL_SITUATION = new HySString("MODEL_SITUATION");

        /// <summary>
        /// 期間種別
        /// </summary>
        public static readonly HySString MODEL_PERIOD_TYPE = new HySString("MODEL_PERIOD_TYPE");

        /// <summary>
        /// 期間
        /// </summary>
        public static readonly HySString MODEL_PERIOD = new HySString("MODEL_PERIOD");

        /// <summary>
        /// 境界条件１
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION1 = new HySString("THRESHOLD_CONDITION1");

        /// <summary>
        /// 境界条件２
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION2 = new HySString("THRESHOLD_CONDITION2");

        /// <summary>
        /// 境界条件３
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION3 = new HySString("THRESHOLD_CONDITION3");

        /// <summary>
        /// 境界条件４
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION4 = new HySString("THRESHOLD_CONDITION4");

        /// <summary>
        /// 境界条件５
        /// </summary>
        public static readonly HySString THRESHOLD_CONDITION5 = new HySString("THRESHOLD_CONDITION5");

        /// <summary>
        /// 条件１
        /// </summary>
        public static readonly HySString CONDITION1 = new HySString("CONDITION1");

        /// <summary>
        /// 条件２
        /// </summary>
        public static readonly HySString CONDITION2 = new HySString("CONDITION2");

        /// <summary>
        /// 条件３
        /// </summary>
        public static readonly HySString CONDITION3 = new HySString("CONDITION3");

        /// <summary>
        /// 条件４
        /// </summary>
        public static readonly HySString CONDITION4 = new HySString("CONDITION4");

        /// <summary>
        /// 条件５
        /// </summary>
        public static readonly HySString CONDITION5 = new HySString("CONDITION5");

    }

}
