﻿// <summary>ソースコード：ＨＹＭＣＯ収束判別情報格納クラスＩ／Ｆ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>収束判別情報等を格納する</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public class McCnvrgncIterationInfoBase : McConvergenceInfo, HySVersionManagement
    {
        /// <summary> グループ内要素数 </summary>
        protected long m_lElementNum = 0;
        /// <summary> グループ内要素演算中情報 </summary>
        protected McCalInfo[] m_csCalInfo = null;
        /// <summary> グループ内要素初期化情報 </summary>
        protected McInitialInfo[] m_csInitInfo = null;
        /// <summary> グループ内要素のID </summary>
        protected HySID[] m_csElementID = null;
        /// <summary> グループ内要素の名称 </summary>
        protected HySString[] m_csElementName = null;
        /// <summary> 強制DataFusion 時の値の目安 </summary>
        protected double[] m_dInitErrorVal;
        
        /// <summary> グループ内要素間の接続数 </summary>
        protected long m_lTranInfoNum = 0;
        /// <summary> 接続内を流れる伝送データ </summary>
        protected McTranInfo[] m_csTranInfo=null;

        /// <summary>収束演算制御クラスの初期化ファイル</summary>
        protected McInitialInfo m_csCtlInitInfo = null;
        /// <summary>収束演算制御クラスのプロパティ設定ファイル</summary>
        protected McPropertyInfo m_csCtlProptyInfo = null;

        /// <summary>収束演算計算の回数</summary>
        protected long m_lCvgceLoopCount = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCnvrgncIterationInfoBase csDt = new McCnvrgncIterationInfoBase() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McCnvrgncIterationInfoBase 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  McCnvrgncIterationInfoBase()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ内要素数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementNum(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementNum(long lElmNum)
        {
            m_lElementNum = lElmNum;
            m_csInitInfo = new McInitialInfo[m_lElementNum];
            m_csCalInfo = new McCalInfo[m_lElementNum];
            m_csElementName = new HySString[m_lElementNum];
            m_csElementID = new HySID[m_lElementNum];
            m_dInitErrorVal = new double[m_lElementNum];

            for (long lLp = 0; lLp < lElmNum; lLp++)
            {
                m_dInitErrorVal[lLp] = 0.0d;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetElementNum() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>グループ内要素数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetElementNum()
        {
            return m_lElementNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素演算中情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementCalInfo(lElmNum,csInitInfo) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <param name="csCalInfo">グループ内要素演算中情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementCalInfo(long lElmNum, McCalInfo csCalInfo)
        {
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                m_csCalInfo[lElmNum] = csCalInfo;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素演算中情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalInfo = GetElementCalInfo(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <returns>McCalInfo　演算中情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McCalInfo GetElementCalInfo(long lElmNum)
        {
            McCalInfo csRtn = null;
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                csRtn = m_csCalInfo[lElmNum];
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素初期化情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementInitialInfo(lElmNum,csInitInfo) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <param name="csInitInfo">グループ内要素初期化情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementInitialInfo(long lElmNum, McInitialInfo csInitInfo)
        {
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                m_csInitInfo[lElmNum] = csInitInfo;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内要素初期化情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McInitialInfo csInitInfo = GetElementInitialInfo(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <returns>McInitialInfo　初期化情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McInitialInfo GetElementInitialInfo(long lElmNum)
        {
            McInitialInfo csRtn = null;
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                csRtn = m_csInitInfo[lElmNum];
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内の要素ID設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementID(lElmNum,csElmID) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <param name="csElmID">グループ内要素ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementID(long lElmNum, HySID csElmID)
        {
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                if ((object)csElmID == null)
                {
                    m_csElementID[lElmNum] = new HySID("");
                }
                else
                {
                    m_csElementID[lElmNum] = csElmID;
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内のユーザーが指定してた要素のID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetElementID(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <returns>HySID　要素ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetElementID(long lElmNum)
        {
            HySID csRtn = null;
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                csRtn = m_csElementID[lElmNum];
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ内のユーザーが指定してた要素の名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementName(lElmNum,csElmName) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <param name="csElmName">グループ内のユーザーが指定してた要素の名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetElementName(long lElmNum, HySString csElmName)
        {
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                if ( (object)csElmName == null)
                {
                    m_csElementName[lElmNum] = new HySString("");
                }
                else
                {
                    m_csElementName[lElmNum] = csElmName;
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内のユーザーが指定してた要素の名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csElmName = GetElementName(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <returns>HySString　ユーザーが指定してた要素の名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetElementName(long lElmNum)
        {
            HySString csRtn = null;
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                csRtn = m_csElementName[lElmNum];
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内の要素の強制Datafusion コール時に与える引数の値を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInitErrorVal(lElmNum,dInitErrVal) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <param name="dInitErrVal">グループ内の要素の強制Datafusion コール時に与える引数の値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetInitErrorVal(long lElmNum, double dInitErrVal)
        {
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                m_dInitErrorVal[lElmNum] = dInitErrVal;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ内の要素の強制Datafusion コール時に与える引数の値を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> doule dErrorVal = GetInitErrorVal(lElmNum) </para>
        /// </example>
        /// <param name="lElmNum">グループ内要素番号（０相対）</param>
        /// <returns>double　強制Datafusion コール時の引数値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual double GetInitErrorVal(long lElmNum)
        {
            double dRtn = 0.0d;
            if (lElmNum >= 0 && lElmNum < m_lElementNum)
            {
                dRtn = m_dInitErrorVal[lElmNum];
            }
            return dRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素間の接続数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionNum(lCnnctNum) </para>
        /// </example>
        /// <param name="lCnnctNum">要素接続数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnectionNum(long lCnnctNum)
        {
            m_lTranInfoNum = lCnnctNum;
            m_csTranInfo = new McTranInfo[m_lTranInfoNum];
        }
        /// <summary><para>method outline:</para>
        /// <para>要素間の接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetConnectionNum() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>要素間接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetConnectionNum()
        {
            return m_lTranInfoNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetConnectionTranInfo(lCnnctNum,csTranInfo) </para>
        /// </example>
        /// <param name="lCnnctNum">要素間接続番号（０相対）</param>
        /// <param name="csTranInfo">要素間伝送情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetConnectionTranInfo(long lCnnctNum, McTranInfo csTranInfo)
        {
            if (lCnnctNum >= 0 && lCnnctNum < m_lTranInfoNum)
            {
                m_csTranInfo[lCnnctNum] = csTranInfo;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>要素間伝送情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfo csTrnInfo = GetConnectionTranInfo(lCnnctNum) </para>
        /// </example>
        /// <param name="lCnnctNum">要素間接続番号（０相対）</param>
        /// <returns>McTranInfo　要素間伝送情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfo GetConnectionTranInfo(long lCnnctNum)
        {
            McTranInfo csRtn = null;
            if (lCnnctNum >= 0 && lCnnctNum < m_lTranInfoNum)
            {
                csRtn = m_csTranInfo[lCnnctNum];
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>収束制御用初期化情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCtlInitInfo(csCtlInitInfo) </para>
        /// </example>
        /// <param name="csCtlInitInfo">収束制御用初期化情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCtlInitInfo(McInitialInfo csCtlInitInfo)
        {
            if (csCtlInitInfo != null)
            {
                m_csCtlInitInfo = csCtlInitInfo.Clone() as McInitialInfo;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>収束制御用初期化情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McInitialInfo csCtlInitInf = GetCtlInitInfo(　) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McInitialInfo　収束制御用初期化情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McInitialInfo GetCtlInitInfo( )
        {
            return m_csCtlInitInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>収束制御用プロパティ情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCtlPropertyInfo(csCtlProptyInfo) </para>
        /// </example>
        /// <param name="csCtlProptyInfo">収束制御用プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCtlPropertyInfo(McPropertyInfo csCtlProptyInfo)
        {
            if (csCtlProptyInfo != null)
            {
                m_csCtlProptyInfo = csCtlProptyInfo.Clone() as McPropertyInfo;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>収束制御用プロパティ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfo csCtlProptyInfo = GetCtlPropertyInfo(　) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfo　収束制御用プロパティ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyInfo GetCtlPropertyInfo()
        {
            return m_csCtlProptyInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>収束演算のループ回数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCnvrgncLoopCount(lCnt) </para>
        /// </example>
        /// <param name="lCnt">ループ回数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCnvrgncLoopCount(long lCnt)
        {
            this.m_lCvgceLoopCount = lCnt;
        }
        /// <summary><para>method outline:</para>
        /// <para>収束演算のループ回数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCnt = GetCnvrgnceLoopCount() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>ループ回数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetCnvrgnceLoopCount()
        {
            return this.m_lCvgceLoopCount;
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McCnvrgncIterationInfoBase csRtn = new McCnvrgncIterationInfoBase();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McCnvrgncIterationInfoBase csOrgDt = (McCnvrgncIterationInfoBase)csOrgInfo;
            this.SetElementNum(csOrgDt.GetElementNum());
            for (long lP = 0; lP < m_lElementNum; lP++)
            {
                if (this.m_csCalInfo[lP] == null)
                {
                    this.m_csCalInfo[lP] = csOrgDt.m_csCalInfo[lP].Clone();
                }
                else
                {
                    this.m_csCalInfo[lP].CopyInfo(csOrgDt.m_csCalInfo[lP]);
                }
                this.m_csCalInfo[lP].SetID(csOrgDt.m_csCalInfo[lP].GetID());
                this.m_csInitInfo[lP] = (McInitialInfo)csOrgDt.m_csInitInfo[lP].Clone();
                this.m_csElementName[lP] = csOrgDt.m_csElementName[lP].Clone();
                this.m_csElementID[lP] = csOrgDt.m_csElementID[lP].Clone();
                this.m_dInitErrorVal[lP] = csOrgDt.m_dInitErrorVal[lP];
            }
            this.SetConnectionNum(csOrgDt.GetConnectionNum());
            for (long lP = 0; lP < m_lTranInfoNum; lP++)
            {
                if (this.m_csTranInfo[lP] == null)
                {
                    this.m_csTranInfo[lP] = csOrgDt.m_csTranInfo[lP].Clone();
                }
                else
                {
                    this.m_csTranInfo[lP].CopyInfo(csOrgDt.m_csTranInfo[lP]);
                }
            }

            if (csOrgDt.m_csCtlInitInfo != null)
            {
                this.m_csCtlInitInfo = csOrgDt.m_csCtlInitInfo.Clone() as McInitialInfo;
            }
            if (csOrgDt.m_csCtlProptyInfo != null)
            {
                this.m_csCtlProptyInfo = csOrgDt.m_csCtlProptyInfo.Clone() as McPropertyInfo;
            }

            this.m_lCvgceLoopCount = csOrgDt.m_lCvgceLoopCount;
            return true;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public  string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public  void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                    default:
                        // Do nothing
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
