// <summary>ソースコード：マージモデル要素演算データ</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>データマージモデル演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McDataMergeModelCalInfo : McCalInfo, HySVersionManagement
    {
        /// <summary>入力接続数</summary>
        public long m_lInputNum = 0;
        /// <summary>接続情報</summary>
        public McDataMergePropertyInfo.McMergeConnection m_csConnectionData = null;

        /// <summary> データの次元 </summary>
        public long m_lDataDim = -1; // データの次元
        /// <summary> ｘ軸？の配列数 </summary>
        public long m_lDim1Num = -1; // ｘ軸？の配列数
        /// <summary> ｙ軸？の配列数 </summary>
        public long m_lDim2Num = -1; // ｙ軸？の配列数
        /// <summary> ｚ軸？の配列数 </summary>
        public long m_lDim3Num = -1; // ｚ軸？の配列数

        /// <summary> 送信セル内のデータ数 </summary>
        public long m_lValNumInCell = 0;

        /// <summary> 送信情報の一時保管データ（１次元） </summary>
        public HySCellData[   ] m_csD1RcvCellData = null;
        /// <summary> 送信情報の一時保管データ（２次元） </summary>
        public HySCellData[,] m_csD2RcvCellData = null;
        /// <summary> 送信情報の一時保管データ（３次元） </summary>
        public HySCellData[, ,] m_csD3RcvCellData = null;

        /// <summary>送信データに対する入力接続インデックス番号(入力接続線のインデックス) </summary>
        public long[] m_lInCnctnIdxNum = null;
        /// <summary>送信データに対する入力セル内のデータを示すインデックス番号(Read側接続線のIdx, 入力接続を呼び出した回数) </summary>
        public long[,] m_lReadIndexInCell = null;
        /// <summary>書き込み側のセル内データのインデックス番号 (Read側接続線のIdx,入力接続を呼び出した回数)</summary>
        public long[,] m_lWriteIdxInCell=null;


        // 内部に演算中のデータを保持する必要は無い

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McDataMergeModelCalInfo csDt = new McDataMergeModelCalInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> McDataMergeModelCalInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McDataMergeModelCalInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McDataMergeModelCalInfo csRtn = new McDataMergeModelCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McDataMergeModelCalInfo csOrdDt = csOrgInfo as McDataMergeModelCalInfo;
            if( csOrdDt != null )
            {
                m_lInputNum = csOrdDt.m_lInputNum;
                if (csOrdDt.m_csConnectionData != null) { m_csConnectionData = new McDataMergePropertyInfo.McMergeConnection(csOrdDt.m_csConnectionData); }
                m_lDataDim = csOrdDt.m_lDataDim;
                m_lDim1Num = csOrdDt.m_lDim1Num;
                m_lDim2Num = csOrdDt.m_lDim2Num;
                m_lDim3Num = csOrdDt.m_lDim3Num;

                // マージ結果格納用　セル情報を準備する
                if (csOrdDt.m_lDataDim == 1)
                {
                    m_csD1RcvCellData = new HySCellData[csOrdDt.m_lDim1Num];
                    for (long lP1 = 0; lP1 < csOrdDt.m_lDim1Num; lP1++)
                    {
                        m_csD1RcvCellData[lP1] = csOrdDt.m_csD1RcvCellData[lP1].Clone();
                    }
                }
                else if (csOrdDt.m_lDataDim == 2)
                {
                    m_csD2RcvCellData = new HySCellData[csOrdDt.m_lDim1Num, csOrdDt.m_lDim2Num];
                    for (long lP1 = 0; lP1 < csOrdDt.m_lDim1Num; lP1++)
                    {
                        for (long lP2 = 0; lP2 < csOrdDt.m_lDim2Num; lP2++)
                        {
                            m_csD2RcvCellData[lP1, lP2] = csOrdDt.m_csD2RcvCellData[lP1, lP2].Clone();
                        }
                    }
                }
                else if (csOrdDt.m_lDataDim == 3)
                {
                    m_csD3RcvCellData = new HySCellData[csOrdDt.m_lDim1Num, csOrdDt.m_lDim2Num, csOrdDt.m_lDim3Num];
                    for (long lP1 = 0; lP1 < csOrdDt.m_lDim1Num; lP1++)
                    {
                        for (long lP2 = 0; lP2 < csOrdDt.m_lDim2Num; lP2++)
                        {
                            for (long lP3 = 0; lP3 < csOrdDt.m_lDim3Num; lP3++)
                            {
                                m_csD3RcvCellData[lP1, lP2, lP3] = csOrdDt.m_csD3RcvCellData[lP1, lP2, lP3].Clone();
                            }
                        }
                    }
                }

                m_lValNumInCell = csOrdDt.m_lValNumInCell;
                m_lInCnctnIdxNum = new long[m_lInputNum];
                m_lReadIndexInCell = new long[m_lInputNum, m_lValNumInCell];
                for (int iLp1 = 0; iLp1 < m_lInputNum; iLp1++)
                {
                    m_lInCnctnIdxNum[iLp1] = csOrdDt.m_lInCnctnIdxNum[iLp1];
                    for (int iLp2 = 0; iLp2 < m_lValNumInCell; iLp2++)
                    {
                        m_lReadIndexInCell[iLp1, iLp2] = csOrdDt.m_lReadIndexInCell[iLp1, iLp2];
                        m_lWriteIdxInCell[iLp1, iLp2] = csOrdDt.m_lWriteIdxInCell[iLp1, iLp2];
                    }
                }
            }
            return true;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
