﻿// <summary>ソースコード：>演算結果DBアクセス出力要素データ出力クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;

using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>演算結果DBアクセス出力要素データ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/09][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McCalResultDBAOutData : McCmnElementOutData
    {
        /// <summary>演算結果格納先</summary>
        private HySTimeSeriesBase m_csStoreData = null;
        /// <summary>1演算結果レコード連番</summary>
        private long m_lCalResultRegistNo = 0;
        /// <summary>最終データ取得時刻</summary>
        private HySTime m_csLastTime = null;
        /// <summary>演算結果格納先データ型</summary>
        private HySObjectKind m_csStoreDataType = null;
        /// <summary>演算結果格納先データ次元数（0番目：1次元値　1番目：2次元値　2番目：3次元値</summary>
        private HySLong[] m_csStoreDataDimentionList = null;
        /// <summary>データ間引きカウント</summary>
        private long m_lThinOutDataCount = 0;

           
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalResultDBAOutData csDt = new McCalResultDBAOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McCalResultDBAOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalResultDBAOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStoreData( csStoreData )</para>
        /// </example>
        /// <param name="csStoreData">演算結果格納先データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetStoreData(HySTimeSeriesBase csStoreData)
        {
            m_csStoreData = csStoreData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTimeSeriesBase csStoreData = GetStoreData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTimeSeriesBase 演算結果格納先データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySTimeSeriesBase GetStoreData()
        {
            return m_csStoreData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果登録レコード連番設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCalResultRegistNo( lCalResultRegistNo )</para>
        /// </example>
        /// <param name="lCalResultRegistNo">演算結果登録レコード連番</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetCalResultRegistNo(long lCalResultRegistNo)
        {
            m_lCalResultRegistNo = lCalResultRegistNo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果登録レコード連番取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lCalResultRegistNo = GetCalResultRegistNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 演算結果登録レコード連番</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetCalResultRegistNo()
        {
            return m_lCalResultRegistNo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>最終データ取得時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLastTime(csLastTime)</para>
        /// </example>
        /// <param name="csLastTime">最終データ取得時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetLastTime(HySTime csLastTime)
        {
            m_csLastTime = csLastTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>最終データ取得時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csLastTime = GetLastTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 最終データ取得時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySTime GetLastTime()
        {
            return m_csLastTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ型設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStoreDataType(csStoreDataType)</para>
        /// </example>
        /// <param name="csStoreDataType">演算結果格納先データ型</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetStoreDataType(HySObjectKind csStoreDataType)
        {
            m_csStoreDataType = csStoreDataType;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ型取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySObjectKind csStoreDataType = GetStoreDataType()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind 演算結果格納先データ型</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySObjectKind GetStoreDataType()
        {
            return m_csStoreDataType;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ次元数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStoreDataDimentionList(csStoreDataDimentionList)</para>
        /// </example>
        /// <param name="csStoreDataDimentionList">演算結果格納先データ次元数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetStoreDataDimentionList(HySLong[] csStoreDataDimentionList)
        {
            m_csStoreDataDimentionList = csStoreDataDimentionList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算結果格納先データ次元数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySLong[] csStoreDataDimentionList = GetStoreDataDimentionList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySLong[] 演算結果格納先データ次元数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySLong[] GetStoreDataDimentionList()
        {
            return m_csStoreDataDimentionList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ間引きカウント設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetThinOutDataCount(lThinOutDataCount)</para>
        /// </example>
        /// <param name="lThinOutDataCount">データ間引きカウント</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetThinOutDataCount(long lThinOutDataCount)
        {
            m_lThinOutDataCount = lThinOutDataCount;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データ間引きカウント取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lThinOutDataCount = GetThinOutDataCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long データ間引きカウント</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetThinOutDataCount()
        {
            return m_lThinOutDataCount;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
