﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレータ固有データ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McFigureUnityOutData : McGrElementOutData
    {
        /// <summary>シミュレーション初期時刻</summary>
        protected HySTime m_csStartTime;

        /// <summary>計算状態</summary>
        protected long m_lCalStatus;

        /// <summary>ロット情報</summary>
        protected string m_sLotName="";

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McFigureUnityOutData csDt = new McFigureUnityOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McFigureUnityOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFigureUnityOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>シミュレーション初期時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStartTime( csTime )</para>
        /// </example>
        /// <param name="csTime">シミュレーション初期時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetStartTime(HySTime csTime)
        {
            m_csStartTime = csTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>シミュレーション初期時刻取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySTime csStartTime = GetStartTime()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーション初期時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetStartTime()
        {
            return m_csStartTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算状態設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCalStatus( lNum )</para>
        /// </example>
        /// <param name="lNum">計算状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCalStatus(long lNum)
        {
            m_lCalStatus = lNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算状態取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lCalStatus = GetCalStatus()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算状態</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCalStatus()
        {
            return m_lCalStatus;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ロット名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLotName( sLotName )</para>
        /// </example>
        /// <param name="sLotName">ロット名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLotName(string sLotName)
        {
            m_sLotName = sLotName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ロット名取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>string sLotName = GetLotName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ロット名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetLotName()
        {
            return m_sLotName;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
