﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>ファイル出力モデルデータ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    ///<remarks><para>remarks:</para>
    /// <para>McFileOutCtl派生モデルが独自にメンバ変数を持ってしまった場合
    /// このクラスを派生したデータクラス内で定義すること</para>
    /// </remarks>
    [Serializable]
    public class McFileCtlOutData : McCmnElementOutData //, IDeserializationCallback
    {
        /// <summary>出力データ</summary>
        protected McCalInfo m_csFileOutData;

        /// <summary>折れ線グラフファイル出力制御要素内データクラス</summary>
        protected McCalInfo m_csCtlInfoData;

        /// <summary>出力ファイル名称</summary>
        protected HySString m_csOutFileNameWithFullPath;

        /// <summary>出力ファイルインスタンス</summary>
        [NonSerialized]
        protected HySFile m_csOutFile;

        /// <summary>出力切替SWITCH（==true:ファイル出力ON,==false:ファイル出力OFF）</summary>
        protected bool m_bFileOutFlg;

        /// <summary>タイムステップ</summary>
        protected double m_dTimeStep;

               
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McFileCtlOutData csDt = new McFileCtlOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McFileCtlOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFileCtlOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileOutData( csData )</para>
        /// </example>
        /// <param name="csData">出力データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  void SetFileOutData(HySDataRoot csData)
        {
            if (csData is McCalInfo == true)
            {
                m_csFileOutData = (McCalInfo)(csData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力データ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCalInfo csFileOutData = GetFileOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>出力データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public  McCalInfo GetFileOutData()
        {
            return m_csFileOutData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>折れ線グラフファイル出力制御要素内データクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCtlInfoData( csData )</para>
        /// </example>
        /// <param name="csData">折れ線グラフファイル出力制御要素内データクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCtlInfoData(HySDataRoot csData)
        {
            if (csData is McCalInfo == true)
            {
                m_csCtlInfoData = (McCalInfo)(csData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>折れ線グラフファイル出力制御要素内データクラス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCalInfo csCtlInfoData = GetCtlInfoData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>折れ線グラフファイル出力制御要素内データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalInfo GetCtlInfoData()
        {
            return m_csCtlInfoData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力ファイル名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileName( csString )</para>
        /// </example>
        /// <param name="csString">出力ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileName(HySString csString)
        {
            m_csOutFileNameWithFullPath = csString;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力ファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString csFileName = GetFileName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>出力ファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetFileName()
        {
            return m_csOutFileNameWithFullPath;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力ファイルインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetOutFile( csFile )</para>
        /// </example>
        /// <param name="csFile">出力ファイルインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetOutFile(HySFile csFile)
        {
            m_csOutFile = csFile;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力ファイルインスタンス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySFile csOutFile = GetOutFile()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>出力ファイルインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFile GetOutFile()
        {
            return m_csOutFile;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力切替SWITCH設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileOutFlg( bFlg )</para>
        /// </example>
        /// <param name="bFlg">出力切替SWITCH</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileOutFlg(bool bFlg)
        {
            m_bFileOutFlg = bFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力切替SWITCH取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bOutFlg = GetFileOutFlg()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>出力切替SWITCH</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetFileOutFlg()
        {
            return m_bFileOutFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイムステップ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTimeStep( dStep )</para>
        /// </example>
        /// <param name="dStep">タイムステップ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTimeStep(double dStep)
        {
            m_dTimeStep = dStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイムステップ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>double dStep = GetTimeStep()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>タイムステップ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetTimeStep()
        {
            return m_dTimeStep;
        }

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>ファイル出力モデル固有データ設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetOriginalData( csOrigData )</para>
        ///// </example>
        ///// <param name="csOrigData">ファイル出力モデル固有データ</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetOriginalData(HySDataRoot csOrigData)
        //{
        //    m_csOriginalData = csOrigData;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>ファイル出力モデル固有データ取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>HySDataRoot csOriginalData = GetOriginalData()</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>ファイル出力モデル固有データ</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks>
        ///// <para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySDataRoot GetOriginalData()
        //{
        //    return m_csOriginalData;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>前回計算結果出力時刻設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetNextTimeStep( csTime )</para>
        ///// </example>
        ///// <param name="csTime">前回計算結果出力時刻</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetNextTimeStep(HySTime csTime)
        //{
        //    m_csNxTimeStep = csTime;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>前回計算結果出力時刻取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>HySTime csNextTime = GetNextTimeStep()</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>前回計算結果出力時刻</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks>
        ///// <para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySTime GetNextTimeStep()
        //{
        //    return m_csNxTimeStep;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>前回計算結果出力単位設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetNextStep( dStep )</para>
        ///// </example>
        ///// <param name="dStep">前回計算結果出力単位</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetNextStep(double dStep)
        //{
        //    m_dNxTimeStep = dStep;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>前回計算結果出力単位取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>double dNextStep = GetNextStep()</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>前回計算結果出力単位</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks>
        ///// <para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public double GetNextStep()
        //{
        //    return m_dNxTimeStep;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>計算結果データ件数設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>SetBaseCount( dCnt )</para>
        ///// </example>
        ///// <param name="dCnt">計算結果データ件数</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetBaseCount(double dCnt)
        //{
        //    m_dBaseCnt = dCnt;
        //}

        ///// <summary>
        ///// <para>method outline:</para>
        ///// <para>計算結果データ件数取得</para>
        ///// </summary>
        ///// <example>
        ///// <para>usage:</para>
        ///// <para>double dBaseCount = GetBaseCount()</para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>計算結果データ件数</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks>
        ///// <para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public double GetBaseCount()
        //{
        //    return m_dBaseCnt;
        //}

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {            
            base.PostDeserialize();
            
            // 出力ファイルインスタンスを生成し、ファイル名称設定
            m_csOutFile = new HySFile(m_csOutFileNameWithFullPath);  // <-- これが重要

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            // 出力ファイルインスタンスを生成し、ファイル名称設定
            m_csOutFile = new HySFile(m_csOutFileNameWithFullPath);
        }
        */
    }
}
