﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>ファイル入力モデルデータ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McFileInCtlOutData : McCmnElementOutData //, IDeserializationCallback
    {
        /// <summary>入力データ</summary>
        protected McCalInfo m_csFileInData;

        /// <summary>入力ファイル名称</summary>
        protected HySString m_csInFileNameWithFullPath;

        /// <summary>入力ファイルインスタンス</summary>
        [NonSerialized]
        protected HySFile m_csInFile;

        ///// <summary>入力ファイル形式</summary>
        //protected HySDefine.FileType  m_csOutType;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McFileInCtlOutData csDt = new McFileInCtlOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McFileInCtlOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFileInCtlOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileInData( csData )</para>
        /// </example>
        /// <param name="csData">入力データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileInData(HySDataRoot csData)
        {
            if (csData is McCalInfo == true)
            {
                m_csFileInData = (McCalInfo)(csData);
            }
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力データ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCalInfo csData = GetFileInData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>入力データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCalInfo GetFileInData()
        {
            return m_csFileInData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力ファイル名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileName( csString )</para>
        /// </example>
        /// <param name="csString">入力ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileName(HySString csString)
        {
            m_csInFileNameWithFullPath = csString;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力ファイル名称取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString csFileName = GetFileName()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>入力ファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetFileName()
        {
            return m_csInFileNameWithFullPath;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力ファイルインスタンス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetInFile( csFile )</para>
        /// </example>
        /// <param name="csFile">入力ファイルインスタンス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInFile(HySFile csFile)
        {
            m_csInFile = csFile;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力ファイルインスタンス取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySFile csFile = GetInFile()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>入力ファイルインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFile GetInFile()
        {
            return m_csInFile;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            // 入力ファイルインスタンスを生成し、ファイル名称設定
            m_csInFile = new HySFile(m_csInFileNameWithFullPath);  // <-- これが重要


            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> OnDeserialization(csObj) </para>
        /// </example>
        /// <param name="csObj">コールバックを開始したオブジェクト。このパラメータの機能は、現在実装されていません。</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            // 入力ファイルインスタンスを生成し、ファイル名称設定
            m_csInFile = new HySFile(m_csInFileNameWithFullPath);
        }
        */
    }
}
