﻿using System;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>グループ化要素データ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McGrElementOutData : McCmnElementOutData
    {
        /// <summary>
        /// 演算要素データクラスリスト
        /// </summary>
        protected HySDataLinkedList m_csElementOutDataList = new HySDataLinkedList();

        /// <summary>計算状態</summary>
        protected long m_lStatus;

        /// <summary>計算中のノード順番号</summary>
        protected int m_iNodeItemNo;

        /// <summary> Ｇｒ化要素独自のδＴ設定</summary>
        protected bool m_bOwnDltTSetFlg;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGrElementOutData csDt = new McGrElementOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McGrElementOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGrElementOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>各演算要素データの積み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddCalElementOutData( csData )</para>
        /// </example>
        /// <param name="csData">演算要素データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddCalElementOutData(McCmnElementOutData csData)
        {
            m_csElementOutDataList.AddLast(csData);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>各演算要素データの取り出し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McCmnElementOutData csElementOutData = GetCalElementOutData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCmnElementOutData GetCalElementOutData()
        {
            McCmnElementOutData csElementOutData = (McCmnElementOutData)(m_csElementOutDataList.GetCursorData());
            return csElementOutData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>カーソル位置を最初に持ってくる</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetCursorFirst()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorFirst()
        {
            m_csElementOutDataList.SetCursorFirst();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>カーソル位置を次の位置に持ってくる</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>MoveCursorNext()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorNext()
        {
            m_csElementOutDataList.MoveCursorNext();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>データクラス数の取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lDataCount = GetDataCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDataCount()
        {
            return m_csElementOutDataList.GetCount();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算状態設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetStatus( lNum )</para>
        /// </example>
        /// <param name="lNum">計算状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetStatus(long lNum)
        {
            m_lStatus = lNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算状態取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lStatus = GetStatus()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算状態</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetStatus()
        {
            return m_lStatus;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算中のノード順番号設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetNodeItemNo( iNum )</para>
        /// </example>
        /// <param name="iNum">計算中のノード順番号</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetNodeItemNo(int iNum)
        {
            m_iNodeItemNo = iNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算中のノード順番号取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>int iNumber = GetNodeItemNo()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算中のノード順番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetNodeItemNo()
        {
            return m_iNodeItemNo;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Ｇｒ化要素独自のδＴ設定のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDltTSetFlg( bFlg )</para>
        /// </example>
        /// <param name="bFlg">Ｇｒ化要素独自のδＴ設定</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDltTSetFlg(bool bFlg)
        {
            m_bOwnDltTSetFlg = bFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>Ｇｒ化要素独自のδＴ設定取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bDltTSetFlg = GetDltTSetFlg()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>Ｇｒ化要素独自のδＴ設定</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetDltTSetFlg()
        {
            return m_bOwnDltTSetFlg;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */

    }
}
