﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>折れ線グラフ画面出力制御クラス用データ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>McScreenCtl派生モデルが独自にメンバ変数を持ってしまった場合
    /// McScreenCtlOutDataを派生したデータクラス内で定義すること</para>
    /// </remarks>
    [Serializable]
    public class McLineGraphScreenOutData : McScreenCtlOutData
    {
        /// <summary>前回計算結果出力時刻</summary>
        protected HySTime m_csNxTimeStep;

        /// <summary>前回計算結果出力単位</summary>
        protected double m_dNxTimeStep;

        /// <summary>計算結果データ件数</summary>
        protected double m_dBaseCnt;

               
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLineGraphFileOutData csDt = new McLineGraphFileOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McLineGraphFileOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLineGraphScreenOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>前回計算結果出力時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetNextTimeStep( csTime )</para>
        /// </example>
        /// <param name="csTime">前回計算結果出力時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetNextTimeStep(HySTime csTime)
        {
            m_csNxTimeStep = csTime;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>前回計算結果出力時刻取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySTime csNextTime = GetNextTimeStep()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>前回計算結果出力時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetNextTimeStep()
        {
            return m_csNxTimeStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>前回計算結果出力単位設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetNextStep( dStep )</para>
        /// </example>
        /// <param name="dStep">前回計算結果出力単位</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetNextStep(double dStep)
        {
            m_dNxTimeStep = dStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>前回計算結果出力単位取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>double dNextStep = GetNextStep()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>前回計算結果出力単位</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetNextStep()
        {
            return m_dNxTimeStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算結果データ件数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetBaseCount( dCnt )</para>
        /// </example>
        /// <param name="dCnt">計算結果データ件数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetBaseCount(double dCnt)
        {
            m_dBaseCnt = dCnt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>計算結果データ件数取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>double dBaseCount = GetBaseCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>計算結果データ件数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetBaseCount()
        {
            return m_dBaseCnt;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
