﻿using System;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data.FileIO
{
    /// <summary><para>class outline:</para>
    /// <para>画面出力モデルデータ出力クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>McScreenCtl派生モデルが独自にメンバ変数を持ってしまった場合
    /// このクラスを派生したデータクラス内で定義すること</para>
    /// </remarks>
    [Serializable]
    public class McScreenCtlOutData : McCmnElementOutData
    {
        /// <summary>表示データ</summary>
        protected HySDataRoot m_csDispData;

        /// <summary>画面表示中フラグ</summary>
        protected bool m_bDispFlg;

        /// <summary>タイムステップ</summary>
        protected double m_dTimeStep;

        /// <summary>描画周期</summary>
        protected long m_lDispCycle;

        /// <summary> イベント発行待ち状態 </summary>
        protected bool m_EventHoldingState;

        /// <summary> 画面表示要求数 </summary>
        protected ulong m_lDispEventNum;

        /// <summary> 画面更新要求最低間隔（ミリ秒） </summary>
        protected int m_iDispTimeLag;

        /// <summary> 画面表示スレッド消去回数 </summary>
        protected ulong m_lDispEventTOutNum;

        /// <summary> 画面表示スレッド消去回数最大値 </summary>
        protected ulong m_lDispEventTOutMax;

              
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McScreenCtlOutData csDt = new McScreenCtlOutData()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McScreenCtlOutData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McScreenCtlOutData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispData( csData )</para>
        /// </example>
        /// <param name="csData">表示データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispData(HySDataRoot csData)
        {
            m_csDispData = csData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示データ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataRoot csDispData = GetDispData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>表示データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetDispData()
        {
            return m_csDispData;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示中フラグ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispFlg( bFlg )</para>
        /// </example>
        /// <param name="bFlg">画面表示中フラグ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispFlg(bool bFlg)
        {
            m_bDispFlg = bFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示中フラグ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bDispFlg = GetDispFlg()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面表示中フラグ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetDispFlg()
        {
            return m_bDispFlg;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイムステップ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTimeStep( dStep )</para>
        /// </example>
        /// <param name="dStep">タイムステップ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTimeStep(double dStep)
        {
            m_dTimeStep = dStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>タイムステップ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>double dStep = GetTimeStep()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>タイムステップ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetTimeStep()
        {
            return m_dTimeStep;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示周期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispCycle( lCycle )</para>
        /// </example>
        /// <param name="lCycle">表示周期</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispCycle(long lCycle)
        {
            m_lDispCycle = lCycle;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>表示周期取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lCycle = GetDispCycle()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>表示周期</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetDispCycle()
        {
            return m_lDispCycle;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベント発行待ち状態設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetEventHoldingState( bState )</para>
        /// </example>
        /// <param name="bState">イベント発行待ち状態</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetEventHoldingState(bool bState)
        {
            m_EventHoldingState = bState;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>イベント発行待ち状態取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bState = GetEventHoldingState()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>イベント発行待ち状態</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetEventHoldingState()
        {
            return m_EventHoldingState;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示要求数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispEventNum( ulNum )</para>
        /// </example>
        /// <param name="ulNum">画面表示要求数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispEventNum(ulong ulNum)
        {
            m_lDispEventNum = ulNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示要求数取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulNum = GetDispEventNum()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面表示要求数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ulong GetDispEventNum()
        {
            return m_lDispEventNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面更新要求最低間隔設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispTimeLag( iLag )</para>
        /// </example>
        /// <param name="iLag">画面更新要求最低間隔</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispTimeLag(int iLag)
        {
            m_iDispTimeLag = iLag;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面更新要求最低間隔取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>int iLag = GetDispTimeLag()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面更新要求最低間隔</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetDispTimeLag()
        {
            return m_iDispTimeLag;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示スレッド消去回数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispEventTOutNum( ulNum )</para>
        /// </example>
        /// <param name="ulNum">画面表示スレッド消去回数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispEventTOutNum(ulong ulNum)
        {
            m_lDispEventTOutNum = ulNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示スレッド消去回数取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulNum = GetDispEventTOutNum()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面表示スレッド消去回数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ulong GetDispEventTOutNum()
        {
            return m_lDispEventTOutNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示スレッド消去回数最大値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispEventTOutMax( ulNum )</para>
        /// </example>
        /// <param name="ulNum">画面表示スレッド消去回数最大値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDispEventTOutMax(ulong ulNum)
        {
            m_lDispEventTOutMax = ulNum;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>画面表示スレッド消去回数最大値取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ulong ulMaxNum = GetDispEventTOutMax()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>画面表示スレッド消去回数最大値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public ulong GetDispEventTOutMax()
        {
            return m_lDispEventTOutMax;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
