﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ管理表示情報データ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreImpl.Data.LibraryCtl
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ管理表示情報データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ライブラリ管理クラスから取得した「ライブラリ管理画面上に表示される情報」を格納</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McDispLibTreeData : HySDataRoot, HySVersionManagement
    {
        // 複数のMcModelLibraryData クラスの m_csCalModelList,m_csInputList 等の情報を元に画面に表示するデータを持つ
        // タブ毎にツリーが構築できる情報を格納する

        /// <summary>モデル管理ライブラリデータ</summary>
        protected McModelLibraryData m_csModelLibraryData;

        /// <summary>ライブラリ分類定義データ</summary>
        protected McLibCategoryData m_csLibCategoryData;

        /// <summary>ライブラリインストール情報</summary>
        private McLibraryInstallInfoData m_csLibraryInstallInfoData;

        /// <summary><para>method outline:</para>
        /// <para>モデル管理ライブラリデータクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetModelLibraryData( csModelLibraryData )</para>
        /// </example>
        /// <param name="csModelLibraryData">モデル管理ライブラリデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetModelLibraryData(McModelLibraryData csModelLibraryData)
        {
            m_csModelLibraryData = csModelLibraryData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル管理ライブラリデータクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelLibraryData csModelLibraryData = GetModelLibraryData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル管理ライブラリデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelLibraryData GetModelLibraryData()
        {
            return m_csModelLibraryData;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ分類定義データクラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLibCategoryData( csLibCategoryData )</para>
        /// </example>
        /// <param name="csLibCategoryData">ライブラリ分類定義データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibCategoryData(McLibCategoryData csLibCategoryData)
        {
            m_csLibCategoryData = csLibCategoryData;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ分類定義データクラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLibCategoryData csLibCategoryData = GetLibCategoryData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ分類定義データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibCategoryData GetLibCategoryData()
        {
            return m_csLibCategoryData;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリインストール情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLibraryInstallInfoData( csLibraryInstallInfoData )</para>
        /// </example>
        /// <param name="csLibraryInstallInfoData">ライブラリインストール情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibraryInstallInfoData(McLibraryInstallInfoData csLibraryInstallInfoData)
        {
            m_csLibraryInstallInfoData = csLibraryInstallInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリインストール情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McLibraryInstallInfoData csLibraryInstallInfoData = GetLibraryInstallInfoData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリインストール情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibraryInstallInfoData GetLibraryInstallInfoData()
        {
            return m_csLibraryInstallInfoData;
        }
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.10";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    m_csLibraryInstallInfoData = new McLibraryInstallInfoData();
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                m_csLibraryInstallInfoData = new McLibraryInstallInfoData();
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
