﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ分類定義データ</summary>
// <author>CommonMP</author>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CoreImpl.Data.LibraryCtl
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ分類定義データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ライブラリ分類定義ファイルから取得した「ライブラリ管理画面上に表示される分類情報」を格納</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/20][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McLibCategoryData : HySDataRoot, HySVersionManagement
    {

        /// <summary>ID属性</summary>
        private IList m_csID;

        /// <summary>階層属性</summary>
        private Hashtable m_csType;

        /// <summary>表示名称</summary>
        private Hashtable m_csName;

        /// <summary>分類情報のノードリスト</summary>
        private Hashtable m_csChildNodeList;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McLibCategoryData csLibCategoryData = new McLibCategoryData();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McLibCategoryData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McLibCategoryData()
        {
            m_csID = new ArrayList();
            m_csType = new Hashtable();
            m_csName = new Hashtable();
            m_csChildNodeList = new Hashtable();
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ分類定義データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddData(csID, csType, csName)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <param name="csType">階層属性</param>
        /// <param name="csName">表示名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddData(HySString csID, HySString csType, HySString csName)
        {
            m_csID.Add(csID);
            m_csType[csID] = csType;
            m_csName[csID] = csName;
        }

        /// <summary><para>method outline:</para>
        /// <para>分類情報ノード追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>AddChildNodeList( csID, csChildNodeList )</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <param name="csChildNodeList">子ノードリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddChildNodeList(HySString csID, List<McLibInfoNode> csChildNodeList)
        {
            m_csChildNodeList[csID] = csChildNodeList;
        }

        /// <summary><para>method outline:</para>
        /// <para>IDリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>IList csIDList = GetID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>IDリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public IList GetID()
        {
            return m_csID;
        }

        /// <summary><para>method outline:</para>
        /// <para>ID指定階層属性取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csType = GetType(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>階層属性</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetType(HySString csID)
        {
            return (HySString)m_csType[csID];
        }

        /// <summary><para>method outline:</para>
        /// <para>ID指定表示名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySString csName = GetName(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>表示名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetName(HySString csID)
        {
            return (HySString)m_csName[csID];
        }

        /// <summary><para>method outline:</para>
        /// <para>キー指定階層属性取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>List csNodeInfoList = GetChildNodeList(csID)</para>
        /// </example>
        /// <param name="csID">ID</param>
        /// <returns>ノード情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<McLibInfoNode> GetChildNodeList(HySString csID)
        {
            return (List<McLibInfoNode>)m_csChildNodeList[csID];
        }
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
