﻿// <summary>ソースコード：ＨＹＭＣＯライブラリ分類定義ノード情報データ</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.CoreImpl.Data.LibraryCtl
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ分類定義ノード情報データ</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ライブラリ分類定義ファイルから取得したノード情報を格納</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/01/20][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McLibInfoNode : HySDataRoot, HySVersionManagement
    {
        /// <summary> [Type](Division or Category or Library)</summary>
        private HySString m_csType;
        /// <summary> [name]属性 </summary>
        private HySString m_csName;
        /// <summary>[ID]属性</summary>
        private HySString m_csID;
        /// <summary> 属性値管理ハッシュテーブル </summary>
        private HySDataHashTable m_csAttributeTbl = new HySDataHashTable();
        /// <summary> 子ノードリスト </summary>
        private List<McLibInfoNode> m_csChildNodeList;

        /// <summary><para>property outline:</para>
        /// <para>XMLノードタグタイプの取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.Type</para>
        /// </example>
        /// <value>XMLノードタグタイプ</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Type
        {
            get 
            { 
                return m_csType;
            }
            set 
            {
                m_csType = value;
            }
        }

        /// <summary><para>property outline:</para>
        /// <para>ライブラリ分類表示名称の取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.Name</para>
        /// </example>
        /// <value>ライブラリ分類表示名称</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Name
        {
            get
            { 
                return m_csName;
            }
            set 
            {
                m_csName = value;
            }
        }

        /// <summary><para>property outline:</para>
        /// <para>ライブラリ分類IDの取得・設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.ID</para>
        /// </example>
        /// <value>ライブラリ分類ID</value>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        
        public HySString ID
        {
            get
            {
                return m_csID;
            }
            set
            {
                m_csID = value; 
            }
        }

        /// <summary><para>property Method:</para>
        /// <para>属性の追加・保持</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.SetAttribute(csKeyName,csValue)</para>
        /// </example>
        /// <param name="csKeyName">属性名称</param>
        /// <param name="csValue">属性値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetAttribute(HySString csKeyName, HySString csValue)
        {
            m_csAttributeTbl.AddObject(csKeyName, csValue);
        }

        /// <summary><para>property Method:</para>
        /// <para>属性情報の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.GetAttribute(csKeyName)</para>
        /// </example>
        /// <param name="csKeyName">属性名称</param>
        /// <returns>属性値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetAttribute(HySString csKeyName)
        {
            return (HySString)m_csAttributeTbl[csKeyName];
        }

        /// <summary><para>property Method:</para>
        /// <para>子ノードリストの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.SetChildNodeList</para>
        /// </example>
        /// <param name="csChildNodeList">子ノードリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetChildNodeList(List<McLibInfoNode> csChildNodeList)
        {
            m_csChildNodeList = csChildNodeList;
        }

        /// <summary><para>property Method:</para>
        /// <para>子ノードリストの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>csLibInfoNode.GetChildNodeList</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>csChildNodeList 　子ノードリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual List<McLibInfoNode> GetChildNodeList()
        {
            return m_csChildNodeList;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
    
}
