﻿// <summary>ソースコード：ＨＹＭＣＯモデル管理ライブラリデータクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.CoreImpl.Data.LibraryCtl;

namespace CommonMP.HYMCO.CoreImpl.Data.LibraryCtl
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル管理ライブラリデータクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルの要素に設定されるライブラリの情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McModelLibraryData : HySDataRoot, HySVersionManagement
    {
        /// <summary>ライブラリ識別子</summary>
        protected HySID m_csLibraryID;
        /// <summary>ライブラリ情報名称</summary>
        protected HySString m_csLibraryDataName;
        /// <summary>各種ライブラリ情報（バージョン情報、製作者、製作日時、備考等）</summary>
        protected McReleaseLibData m_csLibReleaseNote;

        /// <summary>演算モデル表示用情報</summary>
        protected HySDataLinkedList m_csCalModelList = new HySDataLinkedList(); // 演算モデル表示用情報  McModelInfoが保持される
        /// <summary>入力表示用情報</summary>
        protected HySDataLinkedList m_csInputModelList = new HySDataLinkedList();   //　入力表示用情報  McModelInfoが保持される
        /// <summary>出力表示用情報</summary>
        protected HySDataLinkedList m_csOutputModelList = new HySDataLinkedList();  //　出力表示用情報  McModelInfoが保持される
        /// <summary>伝送データ表示用情報</summary>
        protected HySDataLinkedList m_csTranInfoList = new HySDataLinkedList(); //　伝送データ表示用情報  McModelInfoが保持される


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McModelLibraryData csModelLibraryData = new McModelLibraryData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McModelLibraryData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelLibraryData()
        {
            m_csLibraryDataName = new HySString("");
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ識別子のセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetLibraryID(csID)</para>
        /// </example>
        /// <param name="csID">ライブラリ識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibraryID(HySID csID)
        {
            m_csLibraryID = csID;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ識別子の取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySID csID = GetLibraryID();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetLibraryID()
        {
            return m_csLibraryID;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ情報名称のセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetLibraryDataName(csLibraryDataName)</para>
        /// </example>
        /// <param name="csLibraryDataName">ライブラリ情報名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibraryDataName(HySString csLibraryDataName)
        {
            m_csLibraryDataName = csLibraryDataName;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>ライブラリ情報名称の取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySString csHySString = GetLibraryDataName();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ情報名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetLibraryDataName()
        {
            return m_csLibraryDataName;
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデル表示用情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddCalModelInfo(csModelInfo);</para>
        /// </example>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddCalModelInfo(McModelInfo csModelInfo)
        {
            m_csCalModelList.AddLast(csModelInfo);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力方式表示用情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddInputModelnfo(csModelInfo);</para>
        /// </example>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddInputModelnfo(McModelInfo csModelInfo)
        {
            m_csInputModelList.AddLast(csModelInfo);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力方式表示用情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddOutputModelInfo(csModelInfo);</para>
        /// </example>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddOutputModelInfo(McModelInfo csModelInfo)
        {
            m_csOutputModelList.AddLast(csModelInfo);
        }


        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ表示用情報追加</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>AddTranInfo(csModelInfo);</para>
        /// </example>
        /// <param name="csModelInfo">モデル情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddTranInfo(McModelInfo csModelInfo)
        {
            m_csTranInfoList.AddLast(csModelInfo);
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算モデル表示用情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetCalModelInfo();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデル表示用情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetCalModelInfo()
        {
            return m_csCalModelList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>入力方式表示用情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetInputModelnfo();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>入力方式表示用情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetInputModelInfo()
        {
            return m_csInputModelList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>出力方式表示用情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetOutputModelInfo();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>出力方式表示用情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetOutputModelInfo()
        {
            return m_csOutputModelList;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>伝送データ表示用情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csDataLinkedList = GetTranInfo();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>伝送データ表示用情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetTranInfo()
        {
            return m_csTranInfoList;
        }
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
