// <summary>ソースコード：ＨＹＭＣＯモデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McCellModelPropertyInfo : McModelPropertyInfo, McCellModelPropertyIF, HySVersionManagement
    {
        // start of XML化対象外
        /// <summary>入力接続数</summary>
        protected long m_lInputNum = 0;
        /// <summary>入力接続設定管理</summary>
        protected HySID[] m_csInputTbl = null;
        //protected Hashtable m_csInputTbl = new Hashtable();

        /// <summary>出力接続数 </summary>
        protected long m_lOutputNum = 0;
        /// <summary>出力接続設定管理()</summary>
        protected HySID[] m_csOutputTbl = null;
        /// <summary>送信するセル型情報を管理するクラステーブル（キーはm_csOutputTblで設定したＩＤ）</summary>
        protected HySDataHashTable m_csMcSendCellDataTbl = new HySDataHashTable();
        /// <summary>送信するセル型情報</summary>
        protected McSendCellDataIF[] m_csSendCellDataTbl = null;

        /// <summary>受信データパターンリスト</summary>
        protected HySDataHashTable m_csRevPttrnTbl = new HySDataHashTable();
        /// <summary>送信データパターンリスト </summary>
        protected HySDataHashTable m_csSendPttrnTbl = new HySDataHashTable();
        // end of XML化対象外

        // start of XML化対象外
        /// <summary>ワーク用：受信接続情報リスト </summary>
        [NonSerialized]
        protected HySDataLinkedList m_csInputList = null;
        /// <summary>ワーク用：送信接続情報リスト </summary>
        [NonSerialized]
        protected HySDataLinkedList m_csOutputList = null;
        // end of XML化対象外

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McCellModelPropertyInfo()
            : base(null,null)
        {
            //バージョン情報設定
            SetNowVersion();
        }  
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new McCellModelPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McCellModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McCellModelPropertyInfo csRtn = new McCellModelPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            McCellModelPropertyInfo csPrpOrgObj = csOrgObj as McCellModelPropertyInfo;
            if (csPrpOrgObj != null)
            {
                m_csRevPttrnTbl.Copy(csPrpOrgObj.m_csRevPttrnTbl);
                m_csSendPttrnTbl.Copy(csPrpOrgObj.m_csSendPttrnTbl);
            }
        }


        // モデルへの入力接続情報関連
        /// <summary><para>method outline:</para>
        /// <para>入力接続の情報リスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csCnctList = GetInputConnectionInfoList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  受信接続情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        public virtual HySDataLinkedList GetInputConnectionInfoList()
        {
            return m_csInputList;
        }
        /// <summary><para>method outline:</para>
        /// <para>入力接続の情報リスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionInfoList( csList ) </para>
        /// </example>
        /// <param name="csList">入力接続の情報リストし</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        public virtual void SetInputConnectionInfoList(HySDataLinkedList csList)
        {
            m_csInputList = csList;
            m_lInputNum = m_csInputList.GetCount();
            m_csInputTbl = new HySID[m_lInputNum];

            m_csInputList.SetCursorFirst();
            McModelInfo csMdlInfo = null;
            McCellArrayTranInfoPropertyInfo csCnctPrpty = null;
            McTranInfoPattern csPtn = null;
            for (long lLp = 0; lLp < m_lInputNum; lLp++)
            {
                m_csInputTbl[lLp] = null; // 初期設定
                csMdlInfo = m_csInputList.GetCursorData() as McModelInfo;
                csCnctPrpty = csMdlInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                if (csCnctPrpty != null)
                {
                    csPtn = csCnctPrpty.GetReceiveTranInfoPattern() as McTranInfoPattern;
                    if (csPtn != null)
                    {
                        m_csInputTbl[lLp] = csPtn.GetPatternID();
                    }
                }
                m_csInputList.MoveCursorNext();
            }
        }


        // モデルへの出力接続情報関連
        /// <summary><para>method outline:</para>
        /// <para>出力接続の情報リスト</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csCnctList = GetOutputConnectionInfoList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  送信接続情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        public virtual HySDataLinkedList GetOutputConnectionInfoList()
        {
            return m_csOutputList;
        }
        /// <summary><para>method outline:</para>
        /// <para>出力接続の情報リスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputConnectionInfoList(csList) </para>
        /// </example>
        /// <param name="csList">送信接続情報リスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する
        /// リスト内は　McModelInfoが入っており、プロパティは、.GetPropertyInfo();で取り出す必要があるが、モデル未設定等によりnull の場合もある
        /// </para>
        /// </remarks>
        public virtual void SetOutputConnectionInfoList(HySDataLinkedList csList)
        {
            m_csOutputList = csList;
            m_lOutputNum = m_csOutputList.GetCount();
            m_csOutputTbl = new HySID[m_lOutputNum];
            m_csSendCellDataTbl = new McSendCellDataIF[m_lOutputNum];

            m_csOutputList.SetCursorFirst();
            McModelInfo csMdlInfo = null;
            McCellArrayTranInfoPropertyInfo csCnctPrpty = null;
            McTranInfoPattern csPtn = null;
            //McSendCellData csSndCellData = null;
            for (long lLp = 0; lLp < m_lOutputNum; lLp++)
            {
                m_csOutputTbl[lLp] = null; // 初期設定
                csMdlInfo = m_csOutputList.GetCursorData() as McModelInfo;
                csCnctPrpty = csMdlInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                if (csCnctPrpty != null)
                {
                    csPtn = csCnctPrpty.GetSendTranInfoPattern() as McTranInfoPattern;
                    if (csPtn != null)
                    {
                        m_csOutputTbl[lLp] = csPtn.GetPatternID();

                        m_csSendCellDataTbl[lLp] = new McSendCellData();
                        m_csSendCellDataTbl[lLp].SetTranInfoPattern(csPtn);
                        m_csSendCellDataTbl[lLp].SetID(new HySID(lLp.ToString()));

                    }
                }
                m_csOutputList.MoveCursorNext();
            }
        }

        // 入力データ配列と実際の接続との対応をつける情報
        /// <summary><para>method outline:</para>
        /// <para>受信接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetInputConnectionNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  受信接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する</para>
        /// </remarks>
        public virtual long GetInputConnectionNumber()
        { return m_lInputNum; }
        /// <summary><para>method outline:</para>
        /// <para>受信情報配列に対応する受信ＩＤ（ユーザー設定）を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionIndex(lIdxNo,csConnectionID) </para>
        /// </example>
        /// <param name="lIdxNo">配列位置</param>
        /// <param name="csConnectionID">受信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続が完了した後に再度設定する必要がある</para>
        /// </remarks>
        public virtual void SetInputConnectionIndex(long lIdxNo, HySID csConnectionID)
        {
            if (lIdxNo >= 0 && lIdxNo < m_csInputTbl.Length)
            {
                m_csInputTbl[lIdxNo] = csConnectionID;
            }
        }

        // 出力データ配列と実際の接続の対応をつける情報
        /// <summary><para>method outline:</para>
        /// <para>送信接続数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetOutputConnectionNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  送信接続数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の際には、取得値も変化する</para>
        /// </remarks>
        public virtual long GetOutputConnectionNumber()
        { return m_lOutputNum; }
        /// <summary><para>method outline:</para>
        /// <para>送信情報配列に対応する受信ＩＤ（ユーザー設定）を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInputConnectionIndex(lIdxNo,csConnectionID) </para>
        /// </example>
        /// <param name="lIdxNo">配列位置</param>
        /// <param name="csConnectionID">送信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続が完了した後に再度設定する必要がある</para>
        /// </remarks>
        public virtual void SetOutputConnectionIndex(long lIdxNo, HySID csConnectionID)
        {
            if (lIdxNo >= 0 && lIdxNo < m_csOutputTbl.Length)
            {
                m_csOutputTbl[lIdxNo] = csConnectionID;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>端子毎に送信するセル型情報を管理するクラスを設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSendCellData(lIdxNo,csSendCellData) </para>
        /// </example>
        /// <param name="csSendCellDataID">配列位置</param>
        /// <param name="csSendCellData">送信情報識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>接続変更の場合には、再度設定する必要がある</para>
        /// </remarks>
        public virtual void SetSendCellData(HySID csSendCellDataID, McSendCellDataIF csSendCellData)
        {
            m_csMcSendCellDataTbl.AddObject((HySString)csSendCellDataID.GetString(), csSendCellData);
        }
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報を管理するクラスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McSendCellDataIF[] m_OutputCellData = CreateSendCellData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McSendCellDataIF[]  送信するセル型情報を管理するクラスの配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>McBasicCalculateModelBase派生モデルで使用する</para>
        /// </remarks>
        public virtual McSendCellDataIF[] CreateSendCellData()
        {
            return m_csSendCellDataTbl;
            /*

            McSendCellDataIF[] csRtn = new McSendCellDataIF[m_lOutputNum];
            for (long lLp = 0; lLp < m_lOutputNum; lLp++)
            {
                HySID csOutID = m_csOutputTbl[lLp];
                if( csOutID.Equals(McCellModelPropertyInfo.NO_DATA) == true )
                //if (csOutID == null)
                {
                    csRtn[lLp] = null;
                }
                else
                {
                    csRtn[lLp] = m_csMcSendCellDataTbl[(HySString)csOutID.GetString()] as McSendCellDataIF;
                   
                    McModelInfo csMcModelInfo = m_csOutputList.GetData(lLp) as McModelInfo;
                    if (csMcModelInfo != null)
                    {
                        McCellArrayTranInfoPropertyInfo csCellTranInfo = csMcModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                        if (csCellTranInfo.GetSendTranInfoPattern() != null)
                        {
                            csRtn[lLp].SetTranInfoPattern(csCellTranInfo.GetSendTranInfoPattern());
                        }
                    }
                }
            }

            /*
            long lTranInfoNumber = m_csOutputList.GetCount();
            McModelInfo csMcModelInfo = null;
            m_csOutputList.SetCursorFirst();
            for (long lLp = 0; lLp < lTranInfoNumber; lLp++)
            {
                csMcModelInfo = m_csOutputList.GetCursorData() as McModelInfo;
                if (csMcModelInfo != null)
                {
                    McCellArrayTranInfoPropertyInfo csCellTranInfo = csMcModelInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                    if (csRtn[lLp] != null)
                    {   // 送信すべきパターン情報を設定
                        csCellTranInfo.SetSendTranInfoPattern(csRtn[lLp].GetTranInfoPattern());
                    }
                }
                m_csOutputList.MoveCursorNext();
            }
            return csRtn;
            */
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>デフォルトで　送信端子に合った セル型情報を管理するクラスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeRecommendCellData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        public void MakeRecommendCellData( )
        {
            if (m_csOutputList == null) { return; }

            long lTranInfoNumber=0;


            McModelInfo[] csMcModelInfo=null;  // 出力伝送データ情報

            lTranInfoNumber = m_csOutputList.GetCount();
            csMcModelInfo = new McModelInfo[lTranInfoNumber];
            // 出力伝送データの情報設定
            m_csOutputList.SetCursorFirst();
            for (long lLp = 0; lLp < lTranInfoNumber; lLp++)
            {
                csMcModelInfo[lLp] = m_csOutputList.GetCursorData() as McModelInfo;
                m_csOutputList.MoveCursorNext();
            }


            if (m_csMcSendCellDataTbl.GetCount() < 1)
            {
                this.MakeRecommendCellType();
            }
            m_lOutputNum = lTranInfoNumber;
            m_csOutputTbl = new HySID[m_lOutputNum];

            HySID csID = new HySID("");
            McSendCellData csCellDt = null;
            for (long lLp = 0; lLp < lTranInfoNumber; lLp++)
            {
                csCellDt = FindSendCellData(csMcModelInfo[lLp], ref csID);
                if (csCellDt != null)
                {
                    m_csOutputTbl[lLp] = csID;
                }
                else
                {
                    m_csOutputTbl[lLp] = McCellModelPropertyInfo.NO_DATA;
                }
            }
        }
        */
        /*
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報を管理するクラスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MakeRecommendCellType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        protected virtual void MakeRecommendCellType()
        {
            McSendCellData csSndCellData = null;
            McTranInfoPattern csCellPtn = null;
            HySDataLinkedList csSndPtnList = this.GetSendPatternList();
            long lNum = csSndPtnList.GetCount();
            csSndPtnList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {
                csCellPtn = csSndPtnList.GetCursorData() as McTranInfoPattern;
                csSndCellData = new McSendCellData();
                csSndCellData.SetTranInfoPattern(csCellPtn);
                csSndCellData.SetID(new HySID(lLp.ToString()));

                m_csMcSendCellDataTbl.AddObject(new HySString(lLp.ToString()), csSndCellData);

                csSndPtnList.MoveCursorNext();
            }
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>送信するセル型情報のＩＤを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> FindSendCellData(csTranInfo,csID) </para>
        /// </example>
        /// <param name="csTranInfo">伝送データの情報</param>
        /// <param name="csID">ＩＤ情報</param>
        /// <returns>McSendCellData 伝送データと型が一致したセル型情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ｵﾍﾟﾚｰﾀが何も設定しない場合等に用いる</para>
        /// </remarks>
        protected virtual McSendCellData FindSendCellData(McModelInfo csTranInfo, ref HySID csID)
        {
            McSendCellData csRtn = null;
            HySDataLinkedList csKeyList = m_csMcSendCellDataTbl.GetKeyList();   // セルデータのキー情報
            HySDataLinkedList csList = m_csMcSendCellDataTbl.GetDataList();// セルデータ
            if (csKeyList == null || csList == null)
            { return csRtn; }

            long lNum = csList.GetCount(); // 送信するセルデータの数
            csList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {
                McSendCellData csSndDt = csList.GetCursorData() as McSendCellData;  // セルデータ取得
                if (csTranInfo.GetModelKind().Equals(csSndDt.GetTranInfoPattern().GetTranDataKind()) == true)
                {   // セルデータの種別が同じであれば

                    long lTD1 = 0; long lTD2 = 0; long lTD3 = 0; long lDataDimInCell = 0; // パターン側の配列
                    long lCellDim = csSndDt.GetDimension(ref lTD1, ref lTD2, ref lTD3, ref lDataDimInCell);

                    // 引数で与えた送信情報がセル型か？
                    McCellArrayTranInfoPropertyInfo csCellTrnInfo = csTranInfo.GetPropertyInfo() as McCellArrayTranInfoPropertyInfo;
                    if (csCellTrnInfo != null)
                    {   // セル型ならば
                        long lPD1 = 0; long lPD2 = 0; long lPD3 = 0; long lPCellDim = 0; // 伝送データの配列
                        lPD1 = csCellTrnInfo.GetDim1();
                        lPD2 = csCellTrnInfo.GetDim2();
                        lPD3 = csCellTrnInfo.GetDim3();
                        lPCellDim = csCellTrnInfo.GetDimInCell();

                        //if (lTD1 >= lPD1 && lTD2 >= lPD2 && lTD3 >= lPD3)  // この判断必要か？
                        {
                            csRtn = csSndDt;
                            csID = new HySID(((HySString)csKeyList.GetData(lLp)).ToString());
                            break;
                        }
                    }
                }
                csList.MoveCursorNext();
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>全送信するセル型情報は設定されているか？</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = IsAllSendCellDataSet() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool  全送信するセル型情報は設定されている場合＝true が返る</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>return 値が false の場合には　プロパティが設定されていない可能性がある</para>
        /// </remarks>
        public virtual bool IsAllSendCellDataSet()
        {
            bool bRtn = true;
            for( long lLp=0; lLp<m_lOutputNum;lLp++)
            {
                if( ((object)m_csOutputTbl[lLp]) == null )
                {
                    bRtn = false;
                    break;
                }
            }
            return bRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>モデルの送受信パターン情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McTranInfoPatternPropertyIF csPtn = CreateTranInforPattern(csID,csTranInfoKind,sName) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <param name="csTranInfoKind">伝送データ種別</param>
        /// <param name="sName">パターン名称</param>
        /// <returns>McTranInfoPatternPropertyIF モデルの送受信パターン情報</returns>
        /// <exception cref="">無し </exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF CreateTranInforPattern(HySID csID, HySObjectKind csTranInfoKind, String sName)
        {
            McTranInfoPatternPropertyIF csRtn = new McTranInfoPattern( csID,  csTranInfoKind,  sName);
            if (csTranInfoKind == McTranInfoDefine.MUTUAL_SINGLE_TRAN_SERIAL)
            {
                csRtn = new McMutualTranInfoPattern(csID, csTranInfoKind, sName);
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_D1_TRAN_SERIAL)
            {
                csRtn = new McMutualTranInfoPattern(csID, csTranInfoKind, sName);
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_D2_TRAN_SERIAL)
            {
                csRtn = new McMutualTranInfoPattern(csID, csTranInfoKind, sName);
            }
            else if (csTranInfoKind == McTranInfoDefine.MUTUAL_D3_TRAN_SERIAL)
            {
                csRtn = new McMutualTranInfoPattern(csID, csTranInfoKind, sName);
            }
            return csRtn;
        }

        // モデルが期待する受信情報パターン  

        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddReceivePattern(csID,csPtn) </para>
        /// </example>
        /// <param name="csPtn">パターン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddReceivePattern(McTranInfoPatternPropertyIF csPtn)
        {
            if (csPtn == null) { return; }
            m_csRevPttrnTbl.AddObject((HySString)csPtn.GetPatternID().GetString(), csPtn);

            McMutualTranInfoPattern csMutualTrnInf = csPtn as McMutualTranInfoPattern;
            if (csMutualTrnInf != null)
            {
                McTranInfoPatternPropertyIF csDwnPtn = csMutualTrnInf.GetDwnPattern();
                if (csDwnPtn != null)
                {
                    this.AddReceivePattern(csDwnPtn);
                }
                McTranInfoPatternPropertyIF csUpPtn = csMutualTrnInf.GetUpPattern();
                if (csUpPtn != null)
                {
                    this.AddSendPattern(csUpPtn);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターンの数</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetReceivePatternNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  受信情報パターン数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetReceivePatternNumber()
        {
            return m_csRevPttrnTbl.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csPtnList = GetReceivePatternList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  受信情報パターン(リンクリスト形式）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>データがない場合には　null が返る</para>
        /// </remarks>
        public virtual HySDataLinkedList GetReceivePatternList()
        {
            return m_csRevPttrnTbl.GetDataList();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルが期待する受信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPtn = GetReceivePattern(csID) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <returns>McTranInfoPatternPropertyIF  受信情報パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF GetReceivePattern(HySID csID)
        {
            return m_csRevPttrnTbl.GetObject((HySString)csID.GetString()) as McTranInfoPatternPropertyIF;
        }


        // モデルが送信する情報パターン
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddSendPattern(csID,csPtn) </para>
        /// </example>
        /// <param name="csPtn">パターン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void AddSendPattern(McTranInfoPatternPropertyIF csPtn)
        {
            if(csPtn == null ) { return; }
            m_csSendPttrnTbl.AddObject((HySString)csPtn.GetPatternID().GetString(), csPtn);

            McMutualTranInfoPattern csMutualTrnInf = csPtn as McMutualTranInfoPattern;
            if (csMutualTrnInf != null)
            {
                McTranInfoPatternPropertyIF csDwnPtn = csMutualTrnInf.GetDwnPattern();
                if (csDwnPtn != null)
                {
                    this.AddSendPattern(csDwnPtn);
                }
                McTranInfoPatternPropertyIF csUpPtn = csMutualTrnInf.GetUpPattern();
                if (csUpPtn != null)
                {
                    this.AddReceivePattern(csUpPtn);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターンの数</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetSendPatternNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  送信情報パターン数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetSendPatternNumber()
        {
            return m_csSendPttrnTbl.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csPtnList = GetSendPatternList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList  送信情報パターン(リンクリスト形式）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataLinkedList GetSendPatternList()
        {
            HySDataLinkedList csRtnList = m_csSendPttrnTbl.GetDataList();
            if (csRtnList == null)
            {   // Null リターンは避けたい
                csRtnList = new HySDataLinkedList();
            }
            return csRtnList;
            //return m_csSendPttrnTbl.GetDataList();
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルが出力する送信情報パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McTranInfoPatternPropertyIF csPtn = GetSendPattern(csID) </para>
        /// </example>
        /// <param name="csID">パターンＩＤ</param>
        /// <returns>McTranInfoPatternPropertyIF  送信情報パターン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McTranInfoPatternPropertyIF GetSendPattern(HySID csID)
        {
            return m_csSendPttrnTbl.GetObject((HySString)csID.GetString()) as McTranInfoPatternPropertyIF;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            m_csInputList = null;
            m_csOutputList = null;

            PostDeserialize();
        }

        /// <summary>対象無し識別子 </summary>
        static readonly HySID NO_DATA = new HySID("non");

    }
}
