﻿// <summary>ソースコード：プロジェクトプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;


namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロジェクトプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/23][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>プロジェクトプロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    [Serializable]
    public class McFigUnityPropertyInfo : McGroupPropertyInfo, HySVersionManagement
    {
        /// <summary> タイムステップ </summary>
        protected HySTime m_csTimeStep = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McFigUnityPropertyInfo()
            : base(null, null)
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelPropertyInfoRoot csDt = new McGroupPropertyInfo(csLibraryID, csModelKind, csTimeStep)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csTimeStep">タイムステップ</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McFigUnityPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind, HySTime csTimeStep)
            : base(csLibraryID, csModelKind)
        {
            m_csTimeStep = csTimeStep;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csNewObj = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McFigUnityPropertyInfo csRtn = new McFigUnityPropertyInfo();
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);

            if (m_csTimeStep != null)
            {
                m_csTimeStep.SetTime(((McFigUnityPropertyInfo)csOrgObj).m_csTimeStep.GetTime());
            }
            else
            {
                m_csTimeStep = ((McFigUnityPropertyInfo)csOrgObj).m_csTimeStep;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>タイムステップ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetTimeStep(csTimeStep)</para>
        /// </example>
        /// <param name="csTimeStep"> タイムステップ </param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTimeStep(HySTime csTimeStep)
        {
            if (m_csTimeStep != null)
            {
                m_csTimeStep.SetTime(csTimeStep.GetTime());
            }
            else
            {
                m_csTimeStep = csTimeStep;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>タイムステップ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySTime csTimeStep = GetTimeStep()</para>
        /// </example>
        /// <param name=""> 無し</param>
        /// <returns>HySTime タイムステップ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetTimeStep()
        {
            return m_csTimeStep;
        }


        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStepTime(dDltT) </para>
        /// </example>
        /// <param name="dDltT">演算実行刻み時間（δT)(sec)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetStepTime(double dDltT)
        {
            this.SetTimeStep( new HySTime(dDltT));
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDltT = GetStepTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double  演算実行刻み時間（δT) (sec)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override double GetStepTime()
        {
            return this.GetTimeStep().GetTime();
        }


        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(McDefine.xml_PROPERTY, csXmlWriter);

            //Gr化要素は　g_bXmlOutFlgに関係なく出力
            if (m_eDtFusionTiming == McDefine.DataFusionTiming.SYNCHRONOUS)
            {
                csRtn.SetAttribute(McDefine.xml_DATAFUSIONTIMING, "SYNCHRONOUS");
            }
            else
            {
                csRtn.SetAttribute(McDefine.xml_DATAFUSIONTIMING, "ASYNCHRONOUS");
                csRtn.SetAttribute(McDefine.xml_TIMESTEP, m_csTimeStep.GetTime().ToString());
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csXml)
        {
            base.XmlIN(csXml);
            string sTimeStep = csXml.GetAttribute(McDefine.xml_TIMESTEP);
            if (sTimeStep != "")
            {
                m_csTimeStep.SetTime(Convert.ToDouble(sTimeStep));
                return true;
            }
            return true;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
