﻿// <summary>ソースコード：グループプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;


namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>グループプロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>グループプロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    [Serializable]
    public class McGroupPropertyInfo : McPropertyInfo, HySVersionManagement 
    {
        /// <summary> グループ化解除のロック（=falseならば、解除できず） </summary>
        protected bool m_bDisbandLockSW = true;

        /// <summary> DataFusion()発行のタイミング（演算フロー制御）
        /// （同期：全ての要素が演算終了後DataFutionを行う／非同期：要素が演算終了後個別にDataFutionを行う） </summary>
        protected McDefine.DataFusionTiming m_eDtFusionTiming = McDefine.DataFusionTiming.ASYNCHRONOUS;
     
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private McGroupPropertyInfo()
            : base(null,null)
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McModelPropertyInfoRoot csDt = new McGroupPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGroupPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csNewObj = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McGroupPropertyInfo csRtn = new McGroupPropertyInfo();
            csRtn.CopyInf(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);

            m_bDisbandLockSW = ((McGroupPropertyInfo)csOrgObj).m_bDisbandLockSW;

            m_eDtFusionTiming = ((McGroupPropertyInfo)csOrgObj).m_eDtFusionTiming;
        }

        /// <summary><para>method outline:</para>
        /// <para>グループ化解除可能か否かを問い合わせる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bSW = CanDisband( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> =true:グループ化解除可、=false:グループ化解除不可</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool CanDisband()
        {
            return m_bDisbandLockSW;
        }
        /// <summary><para>method outline:</para>
        /// <para>グループ化解除可能か否か設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDisband( bSW ) </para>
        /// </example>
        /// <param name="bSW"> =true:グループ化解除可、=false:グループ化解除不可</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDisband(bool bSW)
        {
            m_bDisbandLockSW = bSW;
        }

        /// <summary><para>method outline:</para>
        /// <para>DataFusion()発行のタイミング（演算フロー制御）設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataFusionTiming(eDtFusionTiming)</para>
        /// </example>
        /// <param name="eDtFusionTiming"> 同期／非同期
        /// McDefine.DataFusionTiming.SYNCHRONOUS：全ての要素が演算終了後DataFutionを行う
        /// McDefine.DataFusionTiming.ASYNCHRONOUS：非同期：要素が演算終了後個別にDataFutionを行う）
        /// </param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataFusionTiming(McDefine.DataFusionTiming eDtFusionTiming)
        {
            m_eDtFusionTiming = eDtFusionTiming;
        }
        /// <summary><para>method outline:</para>
        /// <para>DataFusion()発行のタイミング（演算フロー制御）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McDefine.DataFusionTiming eTm = GetDataFusionTiming()</para>
        /// </example>
        /// <param name=""> 無し</param>
        /// <returns>同期／非同期</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McDefine.DataFusionTiming GetDataFusionTiming()
        {
            return m_eDtFusionTiming;
        }


        /// <summary><para>method outline:</para>
        /// <para>Ｇｒ内のループ接続許可フラグ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLoopPermission(bFlg) </para>
        /// </example>
        /// <param name="bFlg">Ｇｒ内のループ接続許可 　true:許可、fase:禁止</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLoopPermission(bool bFlg)
        {
            HySString csPropatyName = new HySString("");
            McDefine.ValKind lObjKind = McDefine.ValKind.BOOL;
            if( GetInfoType(new HySString(LOOP_PERMISSION), ref csPropatyName, ref lObjKind) == false )
            {
                AddInfoType(LOOP_PERMISSION, "接続ループの存在許可", McDefine.ValKind.BOOL);
            }           
            this.SetInfo(LOOP_PERMISSION, bFlg);
        }
        /// <summary><para>method outline:</para>
        /// <para>Ｇｒ内のループ接続許可フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bFlg = GetLoopPermission() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool  Ｇｒ内のループ接続許可 　true:許可、fase:禁止</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool GetLoopPermission()
        {
            bool bRtn = false;
            HySString csPropatyName = new HySString("");
            McDefine.ValKind lObjKind = McDefine.ValKind.LONG;
            if (GetInfoType(new HySString(LOOP_PERMISSION), ref csPropatyName, ref lObjKind) == true)
            {
                this.GetInfo(LOOP_PERMISSION, ref bRtn);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>Ｇｒ内のループ接続許可フラグ設定解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveLoopPermission() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveLoopPermission()
        {
            RemoveInfoType(LOOP_PERMISSION);
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csFile) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);
                   
            //Gr化要素は　g_bXmlOutFlgに関係なく出力
            if (m_eDtFusionTiming == McDefine.DataFusionTiming.SYNCHRONOUS)
            {
                csRtn.SetAttribute(McDefine.xml_DATAFUSIONTIMING, "SYNCHRONOUS");
            }
            else
            {
                csRtn.SetAttribute(McDefine.xml_DATAFUSIONTIMING, "ASYNCHRONOUS");
            }

            if (m_bDisbandLockSW == true)
            {
                csRtn.SetAttribute(McDefine.xml_DISBANDLOCK, "UNLOCK");
            }
            else
            {
                csRtn.SetAttribute(McDefine.xml_DISBANDLOCK, "LOCK");
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力XML</param>
        /// <returns>bool　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csXml)
        {
            string sTiming = csXml.GetAttribute(McDefine.xml_DATAFUSIONTIMING);
            if (sTiming == "SYNCHRONOUS")
            {
                m_eDtFusionTiming = McDefine.DataFusionTiming.SYNCHRONOUS;
            }
            else if (sTiming == "ASYNCHRONOUS")
            {
                m_eDtFusionTiming = McDefine.DataFusionTiming.ASYNCHRONOUS;
            }

            string sLock = csXml.GetAttribute(McDefine.xml_DISBANDLOCK);
            if (sLock == "UNLOCK")
            {
                m_bDisbandLockSW = true;
            }
            else if (sLock == "LOCK")
            {
                m_bDisbandLockSW = false;
            }

            return true;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>セルと識別子の対応管理データの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCellIDMngIF csDt = CreateCellIDMngData(csKind) </para>
        /// </example>
        /// <param name="csKind">識別子</param>
        /// <returns>McCellIDMngIF  セルと識別子の対応管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellIDMngIF CreateCellIDMngData(HySKind csKind)
        {
            return null;
        }

        // ================================================
        //   常数
        // ================================================
        /// <summary> ループの存在を許可 </summary>
        public static string LOOP_PERMISSION = "LOOP_PERMISSION";


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
