﻿// <summary>ソースコード：モデル個別情報格納クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデル個別情報格納クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルの情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/11/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McModelInfo : HySDataRoot, HySVersionManagement
    {
        /// <summary>要素識別子</summary>
        protected HySID m_csElementID=null;

        /// <summary>ライブラリ識別子（必須）</summary>
        protected HySID m_csLibraryID = null;
        /// <summary>モデル/伝送データの大区分（必須）</summary>
        protected HySObjectKind m_csModelDivision = null;
        /// <summary>モデル/伝送データの小区分（必須）</summary>
        protected HySObjectKind m_csModelClassification = null;
        /// <summary>モデル/伝送データの種別（必須）</summary>
        protected HySObjectKind m_csModelKind = null;
        /// <summary>モデル/伝送データの名称（必須）</summary>
        protected HySString m_csModelName = null;
        //// <summary>要素内演算中データ種別（必須 但し、伝送データの場合には不要）</summary>
        //protected HySObjectKind m_csCalInfoKind;

        /// <summary>アイコン名称（必須）</summary>
        protected HySString m_csIconName = null;

        /// <summary>モデルタイプ（必須）(通常モデル、グループ化モデル等)</summary>
        protected HySObjectKind m_csModelType = null;

        /// <summary>ライブラリ管理表示／非表示指定（必須）</summary>
        protected bool m_bLibraryDispMode = true;

        /// <summary>付属画面有無区分 false:無し true:有り（必須）</summary>
        protected bool m_bAttachedScreenKind = false;

        /// <summary>プロパティ情報設定（必須）</summary>
        protected McPropertyInfoRoot m_csPropertyInf = null;
        /// <summary>初期化情報設定（必須）</summary>
        protected McPropertyInfoRoot m_csInitialInfo = null;

        /// <summary>ユーザーがＧＵＩ上で設定した名称</summary>
        protected HySString m_csUserName = null;

        // == 以下は、モデル説明に表示される内容 ==
        /// <summary>モデル作成者</summary>
        protected HySString m_csCreator = new HySString("");
        /// <summary>バージョン情報</summary>
        protected HySString m_csVersion = new HySString("");
        /// <summary>概要説明</summary>
        protected HySString m_csSummary = new HySString("");
        /// <summary>付属マニュアル名称</summary>
        protected HySString m_csManualName = new HySString("");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected McModelInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        //必須情報はコンストラクタ内に入れる
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csMdlInf = new McModelInfo(csLibraryID, csModelClassification, csModelKind, csModelName, csCalInfoKind) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelClassification">モデル区分</param>
        /// <param name="csModelKind">モデル種別</param>
        /// <param name="csModelName">モデル名称</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>プロトタイプと互換性を取る為　使用を奨励しない</para>
        /// </remarks>
        public McModelInfo(HySID csLibraryID, HySObjectKind csModelClassification, HySObjectKind csModelKind, HySString csModelName)
        {
            m_csLibraryID = csLibraryID;
            m_csModelClassification = csModelClassification;
            m_csModelKind = csModelKind;
            m_csModelName = csModelName;
            m_csModelType = McDefine.MODEL_TYPE_STANDARD;
            //バージョン情報設定
            SetNowVersion();
        }


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csMdlInf = new McModelInfo(csLibraryID, csModelDivision, csModelClassification, csModelKind, csModelName, csCalInfoKind) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelDivision">モデル大区分</param>
        /// <param name="csModelClassification">モデル小区分</param>
        /// <param name="csModelKind">モデル種別</param>
        /// <param name="csModelName">モデル名称</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo(HySID csLibraryID, HySObjectKind csModelDivision, HySObjectKind csModelClassification, HySObjectKind csModelKind, HySString csModelName)
        {
            m_csLibraryID = csLibraryID;
            m_csModelDivision = csModelDivision;
            m_csModelClassification = csModelClassification;
            m_csModelKind = csModelKind;
            m_csModelName = csModelName;
            m_csModelType = McDefine.MODEL_TYPE_STANDARD;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csMdlInf = new McModelInfo(csLibraryID, csModelClassification, csModelKind, csModelName, csCalInfoKind, csModelType) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelClassification">モデル区分</param>
        /// <param name="csModelKind">モデル種別</param>
        /// <param name="csModelName">モデル名称</param>
        /// <param name="csModelType">モデルタイプ(通常モデル、グループ化モデル等)</param>
        /// <returns>エレメントクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelInfo(HySID csLibraryID, HySObjectKind csModelClassification, HySObjectKind csModelKind, HySString csModelName, HySObjectKind csModelType)
        {
            m_csLibraryID = csLibraryID;
            m_csModelClassification = csModelClassification;
            m_csModelKind = csModelKind;
            m_csModelName = csModelName;
            m_csModelType = csModelType;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPropertyInfo( csPropertyInf )</para>
        /// </example>
        /// <param name="csPropertyInf">プロパティ設定情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPropertyInfo(McPropertyInfoRoot csPropertyInf)
        {
            m_csPropertyInf = csPropertyInf;
            if (m_csPropertyInf != null)
            {
                m_csPropertyInf.SetModelName(m_csModelName);    // モデル名称をセット
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfoRoot csInf = GetPropertyInfo( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot GetPropertyInfo()
        {
            return m_csPropertyInf;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報クラス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInitialInfo( csInitialInf ) </para>
        /// </example>
        /// <param name="csInitialInf">初期化設定情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInitialInfo(McPropertyInfoRoot csInitialInf)
        {
            m_csInitialInfo = csInitialInf;

            if (m_csInitialInfo != null)
            {
                m_csInitialInfo.SetModelName(m_csModelName);    // モデル名称をセット
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化情報クラス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInf = GetInitialInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot  初期化情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McPropertyInfoRoot GetInitialInfo()
        {
            return m_csInitialInfo;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetElementID( csElementID ) </para>
        /// </example>
        /// <param name="csElementID">要素識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetElementID(HySID csElementID)
        {
            m_csElementID = csElementID;
        }
        /// <summary><para>method outline:</para>
        /// <para>要素識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csElmID = GetElementID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID 要素識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetElementID()
        {
            return m_csElementID;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csLibraryID = GetLibraryID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID ライブラリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetLibraryID()
        {
            return m_csLibraryID;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル大区分取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelDivision = GetDivision() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデル区分</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>LibraryCategory.xml に記載してある値</para>
        /// </remarks>
        public HySObjectKind GetDivision()
        {
            return m_csModelDivision;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル小区分取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelClassification = GetClassification() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデル区分</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>LibraryCategory.xml に記載してある値</para>
        /// </remarks>
        public HySObjectKind GetClassification()
        {
            return m_csModelClassification;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelKind = GetModelKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデル種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetModelKind()
        {
            return m_csModelKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csModelName = GetModelName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString モデル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetModelName()
        {
            return m_csModelName;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル作成者設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCreatorInf(csInf) </para>
        /// </example>
        /// <param name="csInf">モデル作成者</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCreatorInf(HySString csInf)
        {
            m_csCreator = csInf;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル作成者設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCreatorInf(csInf) </para>
        /// </example>
        /// <param name="csInf">モデル作成者</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCreatorInf(String csInf)
        {
            m_csCreator = new HySString(csInf);
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル作成者取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csCreator = GetCreatorInf() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString モデル作成者</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetCreatorInf()
        {
            return m_csCreator;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetVersionInf(csInf) </para>
        /// </example>
        /// <param name="csInf">バージョン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetVersionInf(HySString csInf)
        {
            m_csVersion = csInf;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetVersionInf(csInf) </para>
        /// </example>
        /// <param name="csInf">バージョン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetVersionInf(String csInf)
        {
            m_csVersion = new HySString(csInf);
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csVersion = GetVersionInf() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetVersionInf()
        {
            return m_csVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>概要説明設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSummaryInf(csInf) </para>
        /// </example>
        /// <param name="csInf">概要説明</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSummaryInf(HySString csInf)
        {
            m_csSummary = csInf;
        }
        /// <summary><para>method outline:</para>
        /// <para>概要説明設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSummaryInf(csInf) </para>
        /// </example>
        /// <param name="csInf">概要説明</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSummaryInf(String csInf)
        {
            m_csSummary = new HySString(csInf);
        }
        /// <summary><para>method outline:</para>
        /// <para>概要説明取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csSummary = GetSummaryInf() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 概要説明</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetSummaryInf()
        {
            return m_csSummary;
        }

        /// <summary><para>method outline:</para>
        /// <para>付属マニュアルファイル名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetManualFileName(csManualFileName) </para>
        /// </example>
        /// <param name="csManualFileName">付属マニュアルファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>マニュアルの形式は　PDFのみ</para>
        /// </remarks>
        public void SetManualFileName(HySString csManualFileName)
        {
            m_csManualName = csManualFileName;
        }
        /// <summary><para>method outline:</para>
        /// <para>付属マニュアルファイル名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetManualFileName(sManualFileName) </para>
        /// </example>
        /// <param name="sManualFileName">付属マニュアルファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>マニュアルの形式は　PDFのみ</para>
        /// </remarks>
        public void SetManualFileName(String sManualFileName)
        {
            m_csManualName = new HySString(sManualFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>付属マニュアルファイル名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csManualFile = GetManualFileName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 付属マニュアルファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetManualFileName()
        {
            return m_csManualName;
        }

        /// <summary><para>method outline:</para>
        /// <para>画面からのユーザー設定名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csName = GetUserName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString 画面からのユーザー設定名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetUserName()
        {
            return m_csUserName;
        }
        /// <summary><para>method outline:</para>
        /// <para>画面からのユーザー設定名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUserName(csName) </para>
        /// </example>
        /// <param name="csName">ユーザー設定名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUserName(HySString csName)
        {
            m_csUserName = csName;
        }

        /// <summary><para>method outline:</para>
        /// <para>アイコン名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetIconName(csName) </para>
        /// </example>
        /// <param name="csName">アイコン名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetIconName(HySString csName)
        {
            m_csIconName = csName;
        }
        /// <summary><para>method outline:</para>
        /// <para>アイコン名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetIconName(csName) </para>
        /// </example>
        /// <param name="csName">アイコン名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetIconName(String csName)
        {
            m_csIconName = new HySString(csName);
        }
        /// <summary><para>method outline:</para>
        /// <para>アイコン名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csIconName = GetIconName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString アイコン名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetIconName()
        {
            return m_csIconName;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルタイプ取得(通常モデル、グループ化モデル等)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csModelType = GetModelType() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind モデルタイプ(通常モデル、グループ化モデル等)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetModelType()
        {
            return m_csModelType;
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ管理表示／非表示指定設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLibraryDispMode(bLibraryDispMode) </para>
        /// </example>
        /// <param name="bLibraryDispMode">ライブラリ管理表示／非表示指定  false:非表示 true:表示</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLibraryDispMode(bool bLibraryDispMode)
        {
            m_bLibraryDispMode = bLibraryDispMode;
        }
        /// <summary><para>method outline:</para>
        /// <para>ライブラリ管理表示／非表示指定取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bLibraryDispMode = GetLibraryDispMode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool ライブラリ管理表示／非表示指定</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetLibraryDispMode()
        {
            return m_bLibraryDispMode;
        }

        /// <summary><para>method outline:</para>
        /// <para>付属画面有無区分設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAttachedScreenKind(bKind) </para>
        /// </example>
        /// <param name="bKind">付属画面有無区分 false:無し true:有り</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAttachedScreenKind(bool bKind)
        {
            m_bAttachedScreenKind = bKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>付属画面有無区分取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bKind = GetAttachedScreenKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool 付属画面有無区分 false:無し true:有り</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetAttachedScreenKind()
        {
            return m_bAttachedScreenKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McCalModel.XmlOUT(csFile)</para>
        /// </example>
        /// <param name="csXmlWriter">ＸＭＬ書き出しクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = HySXmlNode.CreateElement(McDefine.xml_CALMODEL, csXmlWriter);
            csRtn.SetAttribute(McDefine.xml_NAME, m_csModelName.ToString());
            csRtn.SetAttribute(McDefine.xml_MODELKIND, m_csModelKind.GetString().ToString());
            csRtn.SetAttribute(McDefine.xml_MODELFACTORYID, m_csLibraryID.GetString().ToString());
            csRtn.SetAttribute(McDefine.xml_DIVISION, m_csModelDivision.GetString().ToString());
            csRtn.SetAttribute(McDefine.xml_CLASSIFICATION, m_csModelClassification.GetString().ToString());
            csRtn.SetAttribute(McDefine.xml_MODELTYPE, m_csModelType.ToString());
            if (m_csPropertyInf != null)
            {
                HySXmlNode csPrpty = m_csPropertyInf.XmlOUT(ref csXmlWriter);
                csRtn.AppendChild(csPrpty);
            }
            // CUIモデルリスト出力にて、初期値表示を行う
            if (m_csInitialInfo != null)
            {
                HySXmlNode csPrpty = m_csInitialInfo.XmlOUT(ref csXmlWriter);
                csRtn.AppendChild(csPrpty);
            }

            bool bAddFlg = false;
            HySXmlNode csSupp = HySXmlNode.CreateElement(McDefine.xml_SUPPLEMENTAL, csXmlWriter);
            if ((object)m_csCreator != null)
            {
                csSupp.SetAttribute(McDefine.xml_CREATOR, m_csCreator.ToString());
                bAddFlg = true;
            }
            if ((object)m_csVersion != null)
            {
                csSupp.SetAttribute(McDefine.xml_VERSION, m_csVersion.ToString());
                bAddFlg = true;
            }
            if ((object)m_csVersion != null)
            {
                csSupp.SetAttribute(McDefine.xml_SUMMARY, m_csSummary.ToString());
                bAddFlg = true;
            }
            if (bAddFlg == true)
            {
                csRtn.AppendChild(csSupp);
            }

            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> XmlIN(csFile) </para>
        /// </example>
        /// <param name="csXml">入力ＸＭＬ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>スタブとして提供する。</para>
        /// </remarks>
        public virtual bool XmlIN(HySXmlNode csXml)
        {
// 将来用
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelInfo csNewObj = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McModelInfo Clone()
        {
            McModelInfo csRtn = new McModelInfo();

            if (this.m_csLibraryID != null)
            {   // オリジナルデータ有り 
                csRtn.m_csLibraryID = this.m_csLibraryID.Clone();
            }
            if (this.m_csModelClassification != null)
            {   // オリジナルデータ有り 
                csRtn.m_csModelClassification = this.m_csModelClassification.Clone();
            }
            if (this.m_csModelKind != null)
            {   // オリジナルデータ有り 
                csRtn.m_csModelKind = this.m_csModelKind.Clone();
            }
            if ((object)this.m_csModelName != null)
            {   // オリジナルデータ有り 
                csRtn.m_csModelName = this.m_csModelName.Clone();
            }
            if (this.m_csPropertyInf != null)
            {   // オリジナルデータ有り 
                csRtn.m_csPropertyInf = this.m_csPropertyInf.Clone();
            }
            if (this.m_csInitialInfo != null)
            {   // オリジナルデータ有り 
                csRtn.m_csInitialInfo = this.m_csInitialInfo.Clone();
            }
            if ((object)this.m_csCreator != null)
            {   // オリジナルデータ有り 
                csRtn.m_csCreator = this.m_csCreator.Clone();
            }
            if ((object)this.m_csVersion != null)
            {   // オリジナルデータ有り 
                csRtn.m_csVersion = this.m_csVersion.Clone();
            }
            if ((object)this.m_csSummary != null)
            {   // オリジナルデータ有り 
                csRtn.m_csSummary = this.m_csSummary.Clone();
            }
            if ((object)this.m_csElementID != null)
            {   // オリジナルデータ有り 
                csRtn.m_csElementID = this.m_csElementID.Clone();
            }
            if ((object)this.m_csIconName != null)
            {   // オリジナルデータ有り 
                csRtn.m_csIconName = this.m_csIconName.Clone();
            }
            if ((object)this.m_csModelType != null)
            {   // オリジナルデータ有り 
                csRtn.m_csModelType = this.m_csModelType.Clone();
            }
            if ((object)m_csUserName != null)
            {   // オリジナルデータ有り 
                csRtn.m_csUserName = this.m_csUserName.Clone();
            }
            if ((object)m_csManualName != null)
            {   // オリジナルデータ有り 
                csRtn.m_csManualName = this.m_csManualName.Clone();
            }

            csRtn.m_bLibraryDispMode = this.m_bLibraryDispMode;
            csRtn.m_bAttachedScreenKind = this.m_bAttachedScreenKind;

            return csRtn;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        //
    }
}
