﻿// <summary>ソースコード：ＨＹＭＣＯモデルプロパティ表示／設定情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>プロパティ表示／設定情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>プロパティ画面に表示すべき情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/12/23][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class McModelPropertyInfo : McPropertyInfo, McModelPropertyIF, HySVersionManagement
    {
        //// <summary>内挿方法式 </summary>
        //protected HySDefine.InterpolateType m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
        //// <summary>セル内データを取得するクラスを管理するクラス </summary>
        //protected McCellDataGetterManager m_csCellDataGetterMng = new McCellDataGetterManager();

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new McModelPropertyInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McModelPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            //this.Init();
            //バージョン情報設定
            SetNowVersion();
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>初期設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void Init()
        {
            this.AddInfoType(TIME_STEP, Properties.HymcoImplResources.MODELCTL_PROPERTY_INFO_TIME_STEP, McDefine.ValKind.DOUBLE);   //"タイムステップ（秒）"
            this.SetInfo(TIME_STEP, 60.0);  // 1 min
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McModelPropertyInfo csRtn = new McModelPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            McModelPropertyInfo csPrpOrgObj = csOrgObj as McModelPropertyInfo;
            if (csPrpOrgObj != null)
            {
                //this.m_eInterpolateType = csPrpOrgObj.m_eInterpolateType;
            }
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetStepTime(dDltT) </para>
        /// </example>
        /// <param name="dDltT">演算実行刻み時間（δT)(sec)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetStepTime(double dDltT)
        {
            this.SetInfo(TIME_STEP, dDltT);
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間（δT)取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dDltT = GetStepTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double  演算実行刻み時間（δT) (sec)</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual double GetStepTime()
        {
            double dRtn = 0.0;
            this.GetInfo(TIME_STEP, ref dRtn);
            return dRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行刻み時間設定解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveStepTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveStepTime()
        {
            RemoveInfoType(TIME_STEP);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode  XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);
                /*
            //if (g_bXmlOutFlg == true)
            {   // XML出力ONならば
                // 内挿ホウ素期を出力
                HySXmlNode csLclNode = HySXmlNode.CreateElement(McDefine.xml_INTERPOLATETYPE, csXmlWriter);
                if (m_eInterpolateType == HySDefine.InterpolateType.LINEAR)
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sLINEAR_INTERPOLATE);
                }
                else if (m_eInterpolateType == HySDefine.InterpolateType.POLYNOMIAL)
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sPOLYNOMIAL_INTERPOLATE);
                }
                else
                {
                    csLclNode.SetAttribute(McDefine.xml_MODELKIND, HySDefine.sNO_INTERPOLATE);
                }
                csRtn.AppendChild(csLclNode);   // AppendChildは最後に行う
            }
                */
            return csRtn;
        }    
        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>bool  =true:正常、=false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csPrptyXml)
        {
            bool bRtn = base.XmlIN(csPrptyXml);
            /*           
            HySXmlNode csXml = null;
            HySXmlNodeList csXmlVariableList = csPrptyXml.GetChildNodeListByTagName(McDefine.xml_INTERPOLATETYPE);
            //long lValCnt = csXmlVariableList.GetCount();  <-- 通常は１個
            //for (long lLoop = 0; lLoop < lValCnt; lLoop++)
            {
                csXml = csXmlVariableList.GetNode(0);
                if (csXml != null)
                {
                    string sKeyAttr = csXml.GetAttribute(McDefine.xml_MODELKIND);
                    if (HySDefine.sLINEAR_INTERPOLATE.Equals(sKeyAttr) == true)
                    {
                        m_eInterpolateType = HySDefine.InterpolateType.LINEAR;
                    }
                    else if (HySDefine.sPOLYNOMIAL_INTERPOLATE.Equals(sKeyAttr) == true)
                    {
                        m_eInterpolateType = HySDefine.InterpolateType.POLYNOMIAL;
                    }
                    else
                    {
                        m_eInterpolateType = HySDefine.InterpolateType.NO_INTERPOLATE;
                    }
                }
            }
            */
            return bRtn;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

   
        // ================================================
        //   常数
        // ================================================
        /// <summary> 演算実行刻み時間（δT) </summary>
        [Obsolete("旧バージョン互換用：使用を奨励しない(McPropertyInfo.TIME_STEP を使用する事)")]
        public static new string TIME_STEP = "TIME_STEP";
    }
}
