// <summary>ソースコード：モデルプデータジェネレーターの応答情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary>
    /// <para>class outline:</para>
    /// <para>モデルプデータジェネレーターの応答情報クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>remarks:</para>
    /// <para>モデルプデータジェネレーターからの応答情報を格納</para>
    /// </remarks>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public class McMdlDtGenAckInfo : HySDataRoot, HySVersionManagement
    {
        /// <summary> OK or NG </summary>
        protected bool m_bOK_NG = false;
        /// <summary>応答メッセージ</summary>
        protected HySString m_csMessage = null;
        /// <summary> 応答番号 </summary>
        protected long m_lAckNo = 0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMdlDtGenAckInfo csData = new McMdlDtGenAckInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McMdlDtGenAckInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McMdlDtGenAckInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMdlDtGenAckInfo csData = new McMdlDtGenAckInfo(bOkNg, csMessage, lAckNo) </para>
        /// </example>
        /// <param name="bOkNg">OK／NG区分</param>
        /// <param name="csMessage">メッセージ情報</param>
        /// <param name="lAckNo">情報区分番号</param>
        /// <returns>McMdlDtGenAckInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMdlDtGenAckInfo(bool bOkNg, HySString csMessage, long lAckNo)
        {
            m_bOK_NG = bOkNg;
            m_csMessage = csMessage;
            m_lAckNo = lAckNo;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>OK／NG区分取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetAckNack( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>OK／NG区分</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetAckNack()
        { return m_bOK_NG; }
        /// <summary><para>method outline:</para>
        /// <para>メッセージ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csStr = GetMessage( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>メッセージ情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetMessage()
        { return m_csMessage; }
        /// <summary><para>method outline:</para>
        /// <para>情報区分番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lAckNo = GetAckNo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>情報区分番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetAckNo()
        { return m_lAckNo; }

        /// <summary> モデル生成応答 </summary>
        public static readonly long MODEL_GENERATION_ACK = -100;
        /// <summary>　モデル生成状況報告 </summary>
        public static readonly long MODEL_GENERATION_PROGRESS = -200;

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
