// <summary>ソースコード：モデルデータ作成制御画面表示条件等のクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.CoreImpl.Data
{
    /// <summary><para>class outline:</para>
    /// <para>モデルデータ作成制御画面表示条件等のクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    [Serializable]
    public class McMdlDtGenScreenReqInfo : McMdlDtGenScreenReqInfoIF, HySVersionManagement
    {

        /// <summary>情報格納管理テーブル</summary>
        protected HySDataHashTable m_csDataTable = new HySDataHashTable();

        
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McMdlDtGenScreenReqInfo csData = new McMdlDtGenScreenReqInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McMdlDtGenScreenReqInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McMdlDtGenScreenReqInfo()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーターのリストを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGeneratorList(csMdlGenList) </para>
        /// </example>
        /// <param name="csMdlGenList">モデルジェネレーターのリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーターのリストを設定する</para>
        /// </remarks>
        public virtual void SetModelGeneratorList(HySDataLinkedList csMdlGenList)
        {
            if (m_csDataTable.GetObject(MdlGenListKey) != null)
            {
                m_csDataTable.DeleteData(MdlGenListKey);
            }
            m_csDataTable.AddObject(MdlGenListKey, csMdlGenList);
        }
        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーターのリストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csMdlGenList = GetModelGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 使用できるモデルジェネレーターのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーターのリストを取得する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorList()
        {
            return m_csDataTable.GetObject(MdlGenListKey) as HySDataLinkedList;
        }

        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーター固有画面のリストを設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetModelGeneratorScreenList(csMdlGenScreenList) </para>
        /// </example>
        /// <param name="csMdlGenScreenList">モデルジェネレーター固有画面のリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーター固有画面のリストを設定する</para>
        /// </remarks>
        public virtual void SetModelGeneratorScreenList(HySDataLinkedList csMdlGenScreenList)
        {
            if (m_csDataTable.GetObject(MdlGenScreenListKey) != null)
            {
                m_csDataTable.DeleteData(MdlGenScreenListKey);
            }
            m_csDataTable.AddObject(MdlGenScreenListKey, csMdlGenScreenList);
        }
        /// <summary><para>method outline:</para>
        /// <para>使用できるモデルジェネレーター固有画面のリストを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csMdlGenScreenList = GetModelGeneratorScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataLinkedList 使用できるモデルジェネレーター固有画面のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>画面上で選択可能なモデルジェネレーター固有画面のリストを取得する</para>
        /// </remarks>
        public virtual HySDataLinkedList GetModelGeneratorScreenList()
        {
            return m_csDataTable.GetObject(MdlGenScreenListKey) as HySDataLinkedList;
        }
        /// <summary><para>method outline:</para>
        /// <para>内部情報クリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void Clear()
        {
            m_csDataTable.ClearAllObject();
        }

        /// <summary> モデルジェネレーター情報リスト：キー </summary>
        private static HySString MdlGenListKey = new HySString("MdlGenList");
        /// <summary> モデルジェネレーター用スクリーン情報リスト：キー </summary>
        private static HySString MdlGenScreenListKey = new HySString("MdlGenScreenList");

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
